/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router.dispatcher;

import android.os.Handler;
import android.os.HandlerThread;
import com.silencedut.router.dispatcher.Dispatcher;

class BackgroundDispatcher
implements Dispatcher {
    private HandlerThread mBackgroundThread = new HandlerThread("Background");
    private Handler mBackgroundHandler;

    BackgroundDispatcher() {
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    @Override
    public void dispatch(Runnable runnable) {
        if (!this.mBackgroundThread.isAlive()) {
            return;
        }
        this.mBackgroundHandler.post(runnable);
    }

    @Override
    public boolean stop() {
        if (!this.mBackgroundThread.isAlive()) {
            return true;
        }
        this.mBackgroundHandler.removeCallbacksAndMessages(null);
        return true;
    }
}

