/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.ReceiverHandler;
import com.silencedut.router.RouterException;
import com.silencedut.router.dispatcher.Dispatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class Router {
    private Map<Class<?>, ReceiverHandler> mReceiverHandlerByInterface = new ConcurrentHashMap();
    private WeakHashMap<Class<?>, Object> mReceiversByType = new WeakHashMap();
    private Set<Dispatcher> mDispatchers = new HashSet<Dispatcher>();
    boolean mAnnotateMethodOnInterface;

    private Router() {
    }

    public static Router getInstance() {
        return InstanceHolder.sInstance;
    }

    public <T> T getReceiver(Class<T> interfaceType) {
        ReceiverHandler receiverHandler = this.mReceiverHandlerByInterface.get(interfaceType);
        if (!interfaceType.isInterface()) {
            throw new RouterException(String.format("receiverType must be a interface , %s is not a interface", interfaceType.getName()));
        }
        if (receiverHandler == null) {
            receiverHandler = new ReceiverHandler(this, interfaceType, this.mReceiversByType);
            this.mReceiverHandlerByInterface.put(interfaceType, receiverHandler);
        }
        return (T)receiverHandler.mReceiverProxy;
    }

    public void setmAnnotateMethodOnInterface(boolean mAnnotateMethodOnInterface) {
        this.mAnnotateMethodOnInterface = mAnnotateMethodOnInterface;
    }

    void addDispatch(Dispatcher dispatcher) {
        this.mDispatchers.add(dispatcher);
    }

    public void register(Object receiver) {
        if (receiver == null) {
            return;
        }
        this.mReceiversByType.put(receiver.getClass(), receiver);
    }

    public void unregister(Object receiver) {
        this.mReceiversByType.remove(receiver.getClass());
        Iterator<Class<?>> iterator = this.mReceiverHandlerByInterface.keySet().iterator();
        while (iterator.hasNext()) {
            Class<?> type = iterator.next();
            if (!type.isInstance(receiver) || this.mReceiverHandlerByInterface.get(type).getSameTypeReceivesCount() != 0) continue;
            iterator.remove();
        }
        if (this.mReceiversByType.size() == 0) {
            this.stopRouter();
        }
    }

    private void stopRouter() {
        for (Dispatcher dispatcher : this.mDispatchers) {
            dispatcher.stop();
        }
    }

    private static class InstanceHolder {
        private static Router sInstance = new Router();

        private InstanceHolder() {
        }
    }
}

