/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.Reception;
import com.silencedut.router.Router;
import com.silencedut.router.RouterException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class ReceiverHandler
implements InvocationHandler {
    private Router mRouter;
    private Class mReceiverType;
    private WeakHashMap<Class<?>, Object> mReceiversByType;
    private AtomicInteger sameTypeReceivesCount = new AtomicInteger(0);
    Object mReceiverProxy;

    ReceiverHandler(Router router, Class receiverType, WeakHashMap<Class<?>, Object> mReceiversByType) {
        this.mRouter = router;
        this.mReceiverType = receiverType;
        this.mReceiversByType = mReceiversByType;
        this.mReceiverProxy = Proxy.newProxyInstance(this.mReceiverType.getClassLoader(), new Class[]{this.mReceiverType}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        for (Object receiver : this.mReceiversByType.values()) {
            if (!this.mReceiverType.isInstance(receiver)) continue;
            if (!this.mRouter.mAnnotateMethodOnInterface) {
                try {
                    method = receiver.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RouterException(String.format("%s no method %s", receiver.getClass().getName(), method.getName()), e);
                }
            }
            Reception reception = new Reception(receiver, method, args);
            reception.dispatchEvent();
            this.mRouter.addDispatch(reception.mDispatcher);
        }
        return null;
    }

    int getSameTypeReceivesCount() {
        this.sameTypeReceivesCount.set(0);
        for (Object receiver : this.mReceiversByType.values()) {
            if (!this.mReceiverType.isInstance(receiver)) continue;
            this.sameTypeReceivesCount.incrementAndGet();
        }
        return this.sameTypeReceivesCount.get();
    }
}

