/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.ReceiverHandler;
import com.silencedut.router.RouterException;
import com.silencedut.router.dispatcher.Dispatcher;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class Router {
    private Map<Class<?>, ReceiverHandler> mReceiverHandlerByType = new ConcurrentHashMap();
    private Set<Object> mAllReceivers = new CopyOnWriteArraySet<Object>();
    private Set<Dispatcher> mDispatchers = new HashSet<Dispatcher>();
    boolean mAnnotateMethodOnInterface;

    private Router() {
    }

    public static Router getInstance() {
        return InstanceHolder.sInstance;
    }

    public <T> T getReceiver(Class<T> receiverType) {
        ReceiverHandler receiverHandler = this.mReceiverHandlerByType.get(receiverType);
        if (!receiverType.isInterface()) {
            throw new RouterException(String.format("receiverType must be a interface , %s is not a interface", receiverType.getName()));
        }
        if (receiverHandler == null) {
            receiverHandler = new ReceiverHandler(this, receiverType, this.mAllReceivers);
            this.mReceiverHandlerByType.put(receiverType, receiverHandler);
        }
        return (T)receiverHandler.mReceiverProxy;
    }

    public void setmAnnotateMethodOnInterface(boolean mAnnotateMethodOnInterface) {
        this.mAnnotateMethodOnInterface = mAnnotateMethodOnInterface;
    }

    void addDispatch(Dispatcher dispatcher) {
        this.mDispatchers.add(dispatcher);
    }

    public void register(Object receiver) {
        this.mAllReceivers.add(receiver);
    }

    public void unregister(Object receiver) {
        this.mAllReceivers.remove(receiver);
        Iterator<Class<?>> iterator = this.mReceiverHandlerByType.keySet().iterator();
        while (iterator.hasNext()) {
            Class<?> type = iterator.next();
            if (!type.isInstance(receiver) || this.mReceiverHandlerByType.get(type).getSameTypeReceivesCount() != 0) continue;
            iterator.remove();
        }
        if (this.mAllReceivers.size() == 0) {
            this.closeCenter();
        }
    }

    private void closeCenter() {
        for (Dispatcher dispatcher : this.mDispatchers) {
            dispatcher.stop();
        }
    }

    private static class InstanceHolder {
        private static Router sInstance = new Router();

        private InstanceHolder() {
        }
    }
}

