/*
 * Decompiled with CFR 0.152.
 */
package com.silencedut.router;

import com.silencedut.router.Reception;
import com.silencedut.router.Router;
import com.silencedut.router.RouterException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

class ReceiverHandler
implements InvocationHandler {
    private Router mRouter;
    private Class mReceiverType;
    private Set<Object> mReceivers;
    private AtomicInteger sameTypeReceivesCount = new AtomicInteger(0);
    Object receiverProxy;

    ReceiverHandler(Router router, Class receiverType, Set<Object> receivers) {
        this.mRouter = router;
        this.mReceiverType = receiverType;
        this.mReceivers = receivers;
        this.receiverProxy = Proxy.newProxyInstance(this.mReceiverType.getClassLoader(), new Class[]{this.mReceiverType}, (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        for (Object receiver : this.mReceivers) {
            if (!this.mReceiverType.isInstance(receiver)) continue;
            if (!this.mRouter.annotateMethodOnInterface) {
                try {
                    method = receiver.getClass().getMethod(method.getName(), method.getParameterTypes());
                }
                catch (NoSuchMethodException e) {
                    throw new RouterException(String.format("%s no method %s", receiver.getClass().getName(), method.getName()), e);
                }
            }
            Reception reception = new Reception(receiver, method, args);
            this.mRouter.dispatchEvent(reception);
        }
        return null;
    }

    int getSameTypeReceivesCount() {
        this.sameTypeReceivesCount.set(0);
        for (Object receiver : this.mReceivers) {
            if (!this.mReceiverType.isInstance(receiver)) continue;
            this.sameTypeReceivesCount.incrementAndGet();
        }
        return this.sameTypeReceivesCount.get();
    }
}

