/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.silanis.esl.api.model.CustomField;
import com.silanis.esl.api.model.UserCustomField;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.List;

public class CustomFieldApiClient {
    private UrlTemplate template;
    private RestClient restClient;

    public CustomFieldApiClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public CustomField createCustomField(CustomField customField) throws EslException {
        String path = this.template.urlFor("/account/customfields").build();
        try {
            String stringResponse = this.doesCustomFieldExist(customField.getId()) ? this.restClient.put(path, Serialization.toJson(customField)) : this.restClient.post(path, Serialization.toJson(customField));
            return Serialization.fromJson(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add/update the custom field to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public boolean doesCustomFieldExist(String id) {
        String path = this.template.urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.restClient.get(path);
            return stringResponse != null && !stringResponse.isEmpty();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from account.", e);
        }
    }

    public CustomField getCustomField(String id) {
        String path = this.template.urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJson(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from account.", e);
        }
    }

    public List<CustomField> getCustomFields(Direction direction, PageRequest request) {
        String path = this.template.urlFor("/account/customfields?dir={dir}&from={from}&to={to}").replace("{dir}", direction.getDirection()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, CustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the list of custom fields from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the list of custom fields from account.", e);
        }
    }

    public void deleteCustomField(String id) {
        String path = this.template.urlFor("/account/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the custom field from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the custom field from account.", e);
        }
    }

    public List<UserCustomField> getUserCustomFields() throws EslException {
        String path = this.template.urlFor("/user/customfields").build();
        try {
            String response = this.restClient.get(path);
            return Serialization.fromJsonToList(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom fields for the user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom fields for the user.", e);
        }
    }

    public UserCustomField getUserCustomField(String customFieldId) {
        String path = this.template.urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", customFieldId).build();
        try {
            String response = this.restClient.get(path);
            return Serialization.fromJson(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field for the user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field for the user.", e);
        }
    }

    public UserCustomField submitCustomFieldValue(UserCustomField userCustomField) throws EslException {
        String path = this.template.urlFor("/user/customfields").build();
        try {
            String payload = Serialization.toJson(userCustomField);
            String response = this.doesCustomFieldValueExist(userCustomField.getId()) ? this.restClient.put(path, payload) : this.restClient.post(path, payload);
            return Serialization.fromJson(response, UserCustomField.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add/update the custom field to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add/update the custom field to account.", e);
        }
    }

    public void deleteUserCustomField(String id) throws EslException {
        String path = this.template.urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete the custom field from user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete the custom field from user.", e);
        }
    }

    public boolean doesCustomFieldValueExist(String id) {
        String path = this.template.urlFor("/user/customfields/{customFieldId}").replace("{customFieldId}", id).build();
        try {
            String stringResponse = this.restClient.get(path);
            return stringResponse != null && !stringResponse.isEmpty();
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get the custom field from user.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get the custom field from user.", e);
        }
    }
}

