/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service.apiclient;

import com.fasterxml.jackson.core.type.TypeReference;
import com.silanis.esl.api.model.DelegationUser;
import com.silanis.esl.api.model.Result;
import com.silanis.esl.api.model.Sender;
import com.silanis.esl.api.model.VerificationType;
import com.silanis.esl.api.util.JacksonUtil;
import com.silanis.esl.sdk.Direction;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PageRequest;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;
import java.util.List;

public class AccountApiClient {
    private UrlTemplate template;
    private RestClient restClient;

    public AccountApiClient(RestClient restClient, String apiUrl) {
        this.restClient = restClient;
        this.template = new UrlTemplate(apiUrl);
    }

    public Sender inviteUser(Sender sender) {
        String path = this.template.urlFor("/account/senders").build();
        try {
            String stringResponse = this.restClient.post(path, Serialization.toJson(sender));
            Sender apiResponse = Serialization.fromJson(stringResponse, Sender.class);
            return apiResponse;
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to invite member to account.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to invite member to account.", e);
        }
    }

    public void sendInvite(String senderId) {
        String path = this.template.urlFor("/account/senders/{senderUid}/invite").replace("{senderUid}", senderId).build();
        try {
            this.restClient.post(path, null);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to send invite to member.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to send invite to member.", e);
        }
    }

    public Result<Sender> getSenders(Direction direction, PageRequest request) {
        String path = this.template.urlFor("/account/senders?to={to}&from={from}&dir={dir}").replace("{dir}", direction.getDirection()).replace("{from}", Integer.toString(request.getFrom())).replace("{to}", Integer.toString(request.to())).build();
        try {
            String stringResponse = this.restClient.get(path);
            Result<Sender> apiResponse = JacksonUtil.deserialize(stringResponse, new TypeReference<Result<Sender>>(){});
            return apiResponse;
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to retrieve Account Members List.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to retrieve Account Members List.", e);
        }
    }

    public Sender getSender(String senderId) {
        String path = this.template.urlFor("/account/senders/{senderUid}").replace("{senderUid}", senderId).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJson(stringResponse, Sender.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Unable to get member from account.", e);
        }
        catch (Exception e) {
            throw new EslException("Unable to get member from account.", e);
        }
    }

    public void deleteSender(String senderId) {
        String path = this.template.urlFor("/account/senders/{senderUid}").replace("{senderUid}", senderId).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not delete sender.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not delete sender. Exception: " + e.getMessage(), e);
        }
    }

    public void updateSender(Sender sender, String senderId) {
        String path = this.template.urlFor("/account/senders/{senderUid}").replace("{senderUid}", senderId).build();
        try {
            String json = Serialization.toJson(sender);
            this.restClient.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update sender.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update sender. Exception: " + e.getMessage(), e);
        }
    }

    public List<DelegationUser> getDelegates(String senderId) {
        String path = this.template.urlFor("/account/senders/{senderId}/delegates").replace("{senderId}", senderId).build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, DelegationUser.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get delegates.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get delegates. Exception: " + e.getMessage(), e);
        }
    }

    public void updateDelegates(String senderId, List<String> delegateIds) {
        String path = this.template.urlFor("/account/senders/{senderId}/delegates").replace("{senderId}", senderId).build();
        try {
            String json = Serialization.toJson(delegateIds);
            this.restClient.put(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not update delegates.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not update delegates. Exception: " + e.getMessage(), e);
        }
    }

    public void addDelegate(String senderId, DelegationUser delegationUser) {
        String path = this.template.urlFor("/account/senders/{senderId}/delegates/{delegateId}").replace("{senderId}", senderId).replace("{delegateId}", delegationUser.getId()).build();
        try {
            String json = Serialization.toJson(delegationUser);
            this.restClient.post(path, json);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not add a delegate.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not add a delegate. Exception: " + e.getMessage(), e);
        }
    }

    public void removeDelegate(String senderId, String delegateId) {
        String path = this.template.urlFor("/account/senders/{senderId}/delegates/{delegateId}").replace("{senderId}", senderId).replace("{delegateId}", delegateId).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not remove a delegate.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not remove a delegate. Exception: " + e.getMessage(), e);
        }
    }

    public void clearDelegates(String senderId) {
        String path = this.template.urlFor("/account/senders/{senderId}/delegates").replace("{senderId}", senderId).build();
        try {
            this.restClient.delete(path);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not clear delegates.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not clear delegates. Exception: " + e.getMessage(), e);
        }
    }

    public List<Sender> getContacts() {
        String path = this.template.urlFor("/users").build();
        try {
            String stringResponse = this.restClient.get(path);
            return Serialization.fromJsonToList(stringResponse, Sender.class);
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get contacts.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get contacts. Exception: " + e.getMessage(), e);
        }
    }

    public List<VerificationType> getVerificationTypes() {
        String path = this.template.urlFor("/account/{accountId}/verificationTypes").replace("{accountId}", "dummyAccountId").build();
        try {
            String stringResponse = this.restClient.get(path);
            Result result = Serialization.fromJson(stringResponse, Result.class);
            List<VerificationType> verificationTypes = Serialization.fromJsonToList(Serialization.toJson(result.getResults()), VerificationType.class);
            return verificationTypes;
        }
        catch (RequestException e) {
            throw new EslServerException("Could not get verification types.", e);
        }
        catch (Exception e) {
            throw new EslException("Could not get verification types. Exception: " + e.getMessage(), e);
        }
    }
}

