/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.service;

import com.silanis.esl.api.model.Document;
import com.silanis.esl.api.model.SignedDocuments;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.internal.EslServerException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.Serialization;
import com.silanis.esl.sdk.internal.UrlTemplate;

public class SigningService {
    private final UrlTemplate template;
    private final RestClient client;

    public SigningService(RestClient client, String baseUrl) {
        this.template = new UrlTemplate(baseUrl);
        this.client = client;
    }

    public void signDocument(PackageId packageId, Document document) {
        String path = this.template.urlFor("/packages/{packageId}/documents/signConfirm").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.post(path, Serialization.toJson(document));
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to sign a document.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to sign a document.", e);
        }
    }

    public void signDocuments(PackageId packageId, SignedDocuments signedDocumentses) {
        String path = this.template.urlFor("/packages/{packageId}/documents/signed_documents").replace("{packageId}", packageId.getId()).build();
        try {
            this.client.post(path, Serialization.toJson(signedDocumentses));
        }
        catch (RequestException e) {
            throw new EslServerException("Failed to sign documents.", e);
        }
        catch (Exception e) {
            throw new EslException("Failed to sign documents.", e);
        }
    }
}

