/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.io;

import com.silanis.esl.sdk.EslException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Streams {
    private Streams() {
    }

    public static byte[] toByteArray(InputStream input) {
        byte[] byArray;
        BufferedInputStream bis = null;
        try {
            int r;
            bis = new BufferedInputStream(input);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((r = bis.read(buf)) != -1) {
                output.write(buf, 0, r);
            }
            byArray = output.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new EslException("Could not read content from InputStream", e);
            }
            catch (Throwable throwable) {
                Streams.close(bis);
                throw throwable;
            }
        }
        Streams.close(bis);
        return byArray;
    }

    public static String toString(InputStream input) throws UnsupportedEncodingException {
        return new String(Streams.toByteArray(input), "UTF-8");
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

