/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.sdk.Sender;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.internal.converter.ExternalConverter;
import com.silanis.esl.sdk.internal.converter.SenderStatusConverter;
import com.silanis.esl.sdk.internal.converter.SenderTypeConverter;

public class SenderConverter {
    private SenderInfo sdkSenderInfo = null;
    private Sender sdkSender = null;
    private com.silanis.esl.api.model.Sender apiSender = null;

    public SenderConverter(com.silanis.esl.api.model.Sender apiSender) {
        this.apiSender = apiSender;
    }

    public SenderConverter(SenderInfo sdkSenderInfo) {
        this.sdkSenderInfo = sdkSenderInfo;
    }

    public com.silanis.esl.api.model.Sender toAPISender() {
        if (this.sdkSenderInfo == null) {
            return this.apiSender;
        }
        com.silanis.esl.api.model.Sender result = new com.silanis.esl.api.model.Sender();
        if (this.sdkSenderInfo.getEmail() != null) {
            result.setEmail(this.sdkSenderInfo.getEmail());
        }
        if (this.sdkSenderInfo.getFirstName() != null) {
            result.setFirstName(this.sdkSenderInfo.getFirstName());
        }
        if (this.sdkSenderInfo.getLastName() != null) {
            result.setLastName(this.sdkSenderInfo.getLastName());
        }
        if (this.sdkSenderInfo.getCompany() != null) {
            result.setCompany(this.sdkSenderInfo.getCompany());
        }
        if (this.sdkSenderInfo.getTitle() != null) {
            result.setTitle(this.sdkSenderInfo.getTitle());
        }
        return result;
    }

    public SenderInfo toSDKSenderInfo() {
        if (this.apiSender == null) {
            return this.sdkSenderInfo;
        }
        SenderInfo result = new SenderInfo();
        result.setEmail(this.apiSender.getEmail());
        result.setFirstName(this.apiSender.getFirstName());
        result.setLastName(this.apiSender.getLastName());
        result.setCompany(this.apiSender.getCompany());
        result.setTitle(this.apiSender.getTitle());
        return result;
    }

    public Sender toSDKSender() {
        if (this.apiSender == null) {
            return this.sdkSender;
        }
        Sender result = new Sender();
        result.setEmail(this.apiSender.getEmail());
        result.setId(this.apiSender.getId());
        result.setFirstName(this.apiSender.getFirstName());
        result.setLastName(this.apiSender.getLastName());
        result.setCompany(this.apiSender.getCompany());
        result.setCreated(this.apiSender.getCreated());
        result.setLanguage(this.apiSender.getLanguage());
        result.setName(this.apiSender.getName());
        result.setPhone(this.apiSender.getPhone());
        result.setStatus(new SenderStatusConverter(this.apiSender.getStatus()).toSDKSenderStatus());
        result.setType(new SenderTypeConverter(this.apiSender.getType()).toSDKSenderType());
        result.setTitle(this.apiSender.getTitle());
        result.setUpdated(this.apiSender.getUpdated());
        result.setExternal(new ExternalConverter(this.apiSender.getExternal()).toSDKExternal());
        return result;
    }
}

