/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.silanis.esl.api.model.Callback;
import com.silanis.esl.sdk.EventNotificationConfig;
import com.silanis.esl.sdk.NotificationEvent;
import com.silanis.esl.sdk.internal.converter.EventNotificationConverter;

public class EventNotificationConfigConverter {
    private Callback apiCallback = null;
    private EventNotificationConfig sdkEventNotificationConfig = null;

    public EventNotificationConfigConverter(Callback apiCallback) {
        this.apiCallback = apiCallback;
    }

    public EventNotificationConfigConverter(EventNotificationConfig sdkEventNotificationConfig) {
        this.sdkEventNotificationConfig = sdkEventNotificationConfig;
    }

    public Callback toAPICallback() {
        if (this.sdkEventNotificationConfig == null) {
            return this.apiCallback;
        }
        Callback callback = new Callback();
        callback.setUrl(this.sdkEventNotificationConfig.getUrl());
        callback.setKey(this.sdkEventNotificationConfig.getKey());
        for (NotificationEvent event : this.sdkEventNotificationConfig.getEvents()) {
            callback.addEvent(new EventNotificationConverter(event).toAPICallbackEvent());
        }
        return callback;
    }

    public EventNotificationConfig toSDKEventNotificationConfig() {
        if (this.apiCallback == null) {
            return this.sdkEventNotificationConfig;
        }
        EventNotificationConfig eventNotificationConfig = new EventNotificationConfig(this.apiCallback.getUrl());
        eventNotificationConfig.setKey(this.apiCallback.getKey());
        for (String callbackEvent : this.apiCallback.getEvents()) {
            eventNotificationConfig.addEvent(new EventNotificationConverter(callbackEvent).toSDKNotificationEvent());
        }
        return eventNotificationConfig;
    }
}

