/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.External;
import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.Role;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.ExtractionType;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.FieldStyle;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.internal.converter.ConversionService;
import com.silanis.esl.sdk.internal.converter.ExternalConverter;
import com.silanis.esl.sdk.internal.converter.FieldConverter;
import com.silanis.esl.sdk.internal.converter.SignatureConverter;
import java.util.Map;

public class DocumentConverter {
    private com.silanis.esl.api.model.Document apiDocument = null;
    private Package apiPackage = null;
    private Document sdkDocument = null;

    public DocumentConverter(com.silanis.esl.api.model.Document apiDocument, Package apiPackage) {
        this.apiDocument = apiDocument;
        this.apiPackage = apiPackage;
    }

    public DocumentConverter(Document sdkDocument) {
        this.sdkDocument = sdkDocument;
    }

    public Document toSDKDocument() {
        if (this.apiDocument == null) {
            return this.sdkDocument;
        }
        DocumentBuilder documentBuilder = DocumentBuilder.newDocumentWithName(this.apiDocument.getName());
        documentBuilder.withId(this.apiDocument.getId());
        if (this.apiDocument.getIndex() != null) {
            documentBuilder.atIndex(this.apiDocument.getIndex());
        }
        documentBuilder.withDescription(this.apiDocument.getDescription());
        documentBuilder.withExternal(new ExternalConverter(this.apiDocument.getExternal()).toSDKExternal());
        for (String extractionType : this.apiDocument.getExtractionTypes()) {
            documentBuilder.withExtractionType(ExtractionType.valueOf(extractionType));
        }
        documentBuilder.withData(this.apiDocument.getData());
        for (Approval apiApproval : this.apiDocument.getApprovals()) {
            documentBuilder.withSignature(new SignatureConverter(apiApproval, this.apiPackage).toSDKSignature());
        }
        for (com.silanis.esl.api.model.Field apiField : this.apiDocument.getFields()) {
            Field sdkField = new FieldConverter(apiField).toSDKField();
            if (sdkField.getStyle() != FieldStyle.BOUND_QRCODE) {
                documentBuilder.withInjectedField(sdkField);
                continue;
            }
            documentBuilder.withQRCode(sdkField);
        }
        return documentBuilder.build();
    }

    public com.silanis.esl.api.model.Document toAPIDocument(final Package createdPackage) {
        if (this.sdkDocument == null) {
            return this.apiDocument;
        }
        com.silanis.esl.api.model.Document result = ((com.silanis.esl.api.model.Document)new com.silanis.esl.api.model.Document().setIndex(this.sdkDocument.getIndex()).setExtract(this.sdkDocument.isExtract()).setExtractionTypes(this.sdkDocument.getExtractionTypes()).setData((Map)this.sdkDocument.getData())).setName(this.sdkDocument.getName());
        if (this.sdkDocument.getId() != null) {
            result.safeSetId(this.sdkDocument.getId().getId());
        }
        result.safeSetDescription(this.sdkDocument.getDescription());
        if (this.sdkDocument.getExternal() != null) {
            External external = new ExternalConverter(this.sdkDocument.getExternal()).toAPIExternal();
            result.setExternal(external);
        }
        result.safeSetApprovals(Lists.newArrayList((Iterable)Iterables.transform(this.sdkDocument.getSignatures(), (Function)new Function<Signature, Approval>(){

            public Approval apply(Signature input) {
                Approval approval = new SignatureConverter(input).toAPIApproval();
                if (input.isPlaceholderSignature()) {
                    approval.setRole(input.getRoleId().getId());
                } else if (input.isGroupSignature()) {
                    approval.setRole(DocumentConverter.this.findRoleIdForGroup(input.getGroupId(), createdPackage));
                } else {
                    approval.setRole(DocumentConverter.this.findRoleIdForSignature(input.getSignerEmail(), createdPackage));
                }
                return approval;
            }
        })));
        for (Field field : this.sdkDocument.getInjectedFields()) {
            result.addField(ConversionService.convert(field));
        }
        for (Field field : this.sdkDocument.getQrCodes()) {
            result.addField(ConversionService.convert(field));
        }
        return result;
    }

    public com.silanis.esl.api.model.Document toAPIDocumentMetadata() {
        if (this.sdkDocument == null) {
            throw new IllegalArgumentException("No SDK document available to perform conversion");
        }
        com.silanis.esl.api.model.Document result = new com.silanis.esl.api.model.Document().safeSetIndex(this.sdkDocument.getIndex()).safeSetExtract(this.sdkDocument.isExtract()).setExtractionTypes(this.sdkDocument.getExtractionTypes()).safeSetName(this.sdkDocument.getName()).safeSetExternal(new ExternalConverter(this.sdkDocument.getExternal()).toAPIExternal()).safeSetDescription(this.sdkDocument.getDescription());
        if (this.sdkDocument.getId() != null) {
            result.setId(this.sdkDocument.getId().toString());
        }
        return result;
    }

    private String findRoleIdForGroup(GroupId groupId, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getGroup() == null || !role.getSigners().get(0).getGroup().getId().equals(groupId.getId())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer group " + groupId.getId());
    }

    private String findRoleIdForSignature(String signerEmail, Package createdPackage) {
        for (Role role : createdPackage.getRoles()) {
            if (role.getSigners().isEmpty() || role.getSigners().get(0).getEmail() == null || !signerEmail.equalsIgnoreCase(role.getSigners().get(0).getEmail())) continue;
            return role.getId();
        }
        throw new IllegalStateException("No role found for signer email " + signerEmail);
    }
}

