/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.Support;
import com.silanis.esl.sdk.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class UnauthenticatedRestClient {
    private final Support support = new Support();
    private final ResponseHandler<String> jsonHandler = new JsonHandler();

    public String get(String path) throws IOException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader((Header)new BasicHeader("Accept", "application/json; esl-api-version=11.9"));
        return UnauthenticatedRestClient.execute((HttpUriRequest)get, this.jsonHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T execute(HttpUriRequest request, ResponseHandler<T> handler) throws IOException, RequestException {
        CloseableHttpClient client = null;
        try {
            client = UnauthenticatedRestClient.buildHttpClient();
        }
        catch (HttpException e) {
            throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), 500, "No SSL Socket Factory", "Could not build request because of SSL socket Factory");
        }
        try {
            CloseableHttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() >= 400) {
                String errorDetails = Streams.toString(response.getEntity().getContent());
                throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errorDetails);
            }
            if (response.getStatusLine().getStatusCode() == 204) {
                T errorDetails = null;
                return errorDetails;
            }
            InputStream bodyContent = response.getEntity().getContent();
            T t = handler.extract(bodyContent);
            return t;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    private static CloseableHttpClient buildHttpClient() throws HttpException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)UnauthenticatedRestClient.buildSSLSocketFactory());
        return httpClientBuilder.build();
    }

    private static SSLConnectionSocketFactory buildSSLSocketFactory() throws HttpException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
    }

    private class JsonHandler
    implements ResponseHandler<String> {
        private JsonHandler() {
        }

        @Override
        public String extract(InputStream input) {
            try {
                String responseBody = Streams.toString(input);
                UnauthenticatedRestClient.this.support.logResponse(responseBody);
                return responseBody;
            }
            catch (UnsupportedEncodingException e) {
                throw new EslException("", e);
            }
        }
    }

    private static interface ResponseHandler<T> {
        public T extract(InputStream var1);
    }
}

