/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.internal.HttpUtil;
import com.silanis.esl.sdk.internal.MimeTypeUtils;
import com.silanis.esl.sdk.internal.RequestException;
import com.silanis.esl.sdk.internal.Support;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;

public class RestClient {
    public static final String CHARSET_UTF_8 = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    public static final String ESL_API_VERSION = "11.9";
    public static final String ESL_API_VERSION_HEADER = "esl-api-version=11.9";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String ESL_CONTENT_TYPE_APPLICATION_JSON = "application/json; esl-api-version=11.9";
    public static final String HEADER_KEY_ACCEPT = "Accept";
    public static final String ACCEPT_TYPE_APPLICATION_JSON = "application/json";
    public static final String ACCEPT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String ACCEPT_TYPE_APPLICATION = "*/*";
    public static final String ESL_ACCEPT_TYPE_APPLICATION_JSON = "application/json; esl-api-version=11.9";
    public static final String ESL_ACCEPT_TYPE_APPLICATION_OCTET_STREAM = "application/octet-stream; esl-api-version=11.9";
    public static final String ESL_ACCEPT_TYPE_APPLICATION = "*/*; esl-api-version=11.9";
    private final ResponseHandler<DownloadedFile> bytesHandler = new BytesHandler();
    private final ResponseHandler<String> jsonHandler = new JsonHandler();
    private final String apiToken;
    private final Support support = new Support();
    private final boolean allowAllSSLCertificates;
    private ProxyConfiguration proxyConfiguration;

    public RestClient(String apiToken) {
        this(apiToken, false);
    }

    public RestClient(String apiToken, boolean allowAllSSLCertificates) {
        this(apiToken, allowAllSSLCertificates, null);
    }

    public RestClient(String apiToken, ProxyConfiguration proxyConfiguration) {
        this(apiToken, false, proxyConfiguration);
    }

    public RestClient(String apiToken, boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration) {
        this.apiToken = apiToken;
        this.allowAllSSLCertificates = allowAllSSLCertificates;
        this.proxyConfiguration = proxyConfiguration;
    }

    public String post(String path, String jsonPayload) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        HttpPost post = new HttpPost(path);
        post.addHeader(this.buildAcceptHeaderForEslApi());
        if (jsonPayload != null) {
            StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
            body.setContentType("application/json; esl-api-version=11.9");
            post.setEntity((HttpEntity)body);
        }
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    public String put(String path, String jsonPayload) throws IOException, RequestException {
        this.support.logRequest("PUT", path, jsonPayload);
        HttpPut put = new HttpPut(path);
        put.addHeader(this.buildAcceptHeaderForEslApi());
        StringEntity body = new StringEntity(jsonPayload, Charset.forName(CHARSET_UTF_8));
        body.setContentType("application/json; esl-api-version=11.9");
        put.setEntity((HttpEntity)body);
        return this.execute((HttpUriRequest)put, this.jsonHandler);
    }

    public String postMultipartFile(String path, String fileName, byte[] fileBytes, String jsonPayload) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart("payload", (ContentBody)this.buildPartForPayload(jsonPayload));
        multipartEntityBuilder.addPart("file", this.buildPartForFile(fileBytes, fileName));
        HttpPost post = new HttpPost(path);
        post.setEntity(multipartEntityBuilder.build());
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    public String postMultipartPackage(String path, Collection<Document> documents, String jsonPayload) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("POST", path, jsonPayload);
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.addPart("payload", (ContentBody)this.buildPartForPayload(jsonPayload));
        for (Document document : documents) {
            multipartEntityBuilder.addPart("file", (ContentBody)this.buildPartForFile(document));
        }
        HttpPost post = new HttpPost(path);
        post.setEntity(multipartEntityBuilder.build());
        return this.execute((HttpUriRequest)post, this.jsonHandler);
    }

    private StringBody buildPartForPayload(String jsonPayload) {
        return new StringBody(jsonPayload, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
    }

    private ContentBody buildPartForFile(byte[] content, String fileName) {
        return this.buildPartForFile(content, fileName, fileName);
    }

    private ByteArrayBody buildPartForFile(Document document) {
        return this.buildPartForFile(document.getContent(), document.getFileName(), document.getName());
    }

    private ByteArrayBody buildPartForFile(byte[] content, String fileName, String name) {
        String contentType = MimeTypeUtils.getContentTypeByFileName(fileName);
        return new ByteArrayBody(content, ContentType.create((String)contentType), name);
    }

    protected void addAuthorizationHeader(HttpUriRequest request) {
        request.setHeader("Authorization", "Basic " + this.apiToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(HttpUriRequest request, ResponseHandler<T> handler) throws IOException, RequestException {
        CloseableHttpClient client = null;
        try {
            client = this.buildHttpClient();
        }
        catch (HttpException e) {
            throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), 500, "No SSL Socket Factory", "Could not build request because of SSL socket Factory");
        }
        try {
            this.addAuthorizationHeader(request);
            this.support.log(request);
            CloseableHttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() >= 400) {
                String errorDetails = Streams.toString(response.getEntity().getContent());
                throw new RequestException(request.getRequestLine().getMethod(), request.getRequestLine().getUri(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), errorDetails);
            }
            if (response.getStatusLine().getStatusCode() == 204) {
                T errorDetails = null;
                return errorDetails;
            }
            InputStream bodyContent = response.getEntity().getContent();
            if (null != response.getHeaders("Content-Disposition") && response.getHeaders("Content-Disposition").length > 0) {
                String fileName = this.getFilename(response.getHeaders("Content-Disposition")[0].getValue());
                DownloadedFile downloadedFile = (DownloadedFile)handler.extract(bodyContent);
                downloadedFile.setFilename(fileName);
                DownloadedFile downloadedFile2 = downloadedFile;
                return (T)downloadedFile2;
            }
            T t = handler.extract(bodyContent);
            return t;
        }
        finally {
            if (null != client) {
                client.close();
            }
        }
    }

    private String getFilename(String disposition) {
        String[] parts;
        String fileNameTitle = "filename*=UTF-8''";
        for (String part : parts = disposition.split(";")) {
            int index = part.indexOf(fileNameTitle);
            if (index <= 0) continue;
            return HttpUtil.percentDecode(part.substring(index + fileNameTitle.length(), part.length()));
        }
        return "";
    }

    private CloseableHttpClient buildHttpClient() throws HttpException {
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (this.allowAllSSLCertificates) {
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.buildSSLSocketFactory());
        }
        if (this.proxyConfiguration != null) {
            if (this.proxyConfiguration.hasCredentials()) {
                httpClientBuilder.setDefaultCredentialsProvider(this.buildCredentialsConfiguration(this.proxyConfiguration));
            }
            httpClientBuilder.setDefaultRequestConfig(this.buildProxyConfiguration(this.proxyConfiguration));
            return httpClientBuilder.build();
        }
        return httpClientBuilder.build();
    }

    private SSLConnectionSocketFactory buildSSLSocketFactory() throws HttpException {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            return new SSLConnectionSocketFactory(sslContext, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        catch (KeyManagementException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HttpException("Problem configuring SSL Socket factory", (Throwable)e);
        }
    }

    private RequestConfig buildProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        return RequestConfig.custom().setProxy(new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getScheme())).build();
    }

    private CredentialsProvider buildCredentialsConfiguration(ProxyConfiguration proxyConfiguration) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUserName(), proxyConfiguration.getPassword()));
        return credentialsProvider;
    }

    public String get(String path) throws IOException, HttpException, URISyntaxException, RequestException {
        return this.get(path, "application/json; esl-api-version=11.9");
    }

    public String get(String path, String acceptType) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader(this.buildAcceptHeader(acceptType));
        return this.execute((HttpUriRequest)get, this.jsonHandler);
    }

    private Header buildAcceptHeaderForEslApi() {
        return this.buildAcceptHeader("application/json; esl-api-version=11.9");
    }

    private Header buildAcceptHeader(String acceptType) {
        return new BasicHeader(HEADER_KEY_ACCEPT, acceptType);
    }

    public DownloadedFile getBytes(String path) throws IOException, HttpException, URISyntaxException, RequestException {
        return this.getBytes(path, ESL_ACCEPT_TYPE_APPLICATION);
    }

    public DownloadedFile getBytes(String path, String acceptType) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader(this.buildAcceptHeader(acceptType));
        return this.execute((HttpUriRequest)get, this.bytesHandler);
    }

    public DownloadedFile getBytesAsOctetStream(String path) throws IOException, HttpException, URISyntaxException, RequestException {
        return this.getBytesAsOctetStream(path, ESL_ACCEPT_TYPE_APPLICATION_OCTET_STREAM);
    }

    public DownloadedFile getBytesAsOctetStream(String path, String acceptType) throws IOException, HttpException, URISyntaxException, RequestException {
        this.support.logRequest("GET", path);
        HttpGet get = new HttpGet(path);
        get.addHeader(this.buildAcceptHeader(acceptType));
        return this.execute((HttpUriRequest)get, this.bytesHandler);
    }

    public String delete(String path) throws HttpException, IOException, URISyntaxException, RequestException {
        this.support.logRequest("DELETE", path);
        HttpDelete delete = new HttpDelete(path);
        delete.addHeader(this.buildAcceptHeaderForEslApi());
        return this.execute((HttpUriRequest)delete, this.jsonHandler);
    }

    private class JsonHandler
    implements ResponseHandler<String> {
        private JsonHandler() {
        }

        @Override
        public String extract(InputStream input) {
            try {
                String responseBody = Streams.toString(input);
                RestClient.this.support.logResponse(responseBody);
                return responseBody;
            }
            catch (UnsupportedEncodingException e) {
                throw new EslException("", e);
            }
        }
    }

    private class BytesHandler
    implements ResponseHandler<DownloadedFile> {
        private BytesHandler() {
        }

        @Override
        public DownloadedFile extract(InputStream input) {
            return new DownloadedFile("", Streams.toByteArray(input));
        }
    }

    private static interface ResponseHandler<T> {
        public T extract(InputStream var1);
    }
}

