/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.internal;

import java.util.Map;

public class AuthRequestParameters {
    private final String sessionToken;
    private final String apiKey;
    private String tempToken;
    private String connectorsAuth;
    private final Map<String, String> headers;

    public AuthRequestParameters(String sessionToken, String apiKey, Map<String, String> headers) {
        this.sessionToken = sessionToken;
        this.apiKey = apiKey;
        this.headers = headers;
        this.tempToken = null;
    }

    public AuthRequestParameters(String sessionToken, String apiKey, String tempToken, Map<String, String> headers) {
        this.sessionToken = sessionToken;
        this.apiKey = apiKey;
        this.tempToken = tempToken;
        this.headers = headers;
    }

    public AuthRequestParameters(String sessionToken, String apiKey, String tempToken, String connectorsAuth, Map<String, String> headers) {
        this.sessionToken = sessionToken;
        this.apiKey = apiKey;
        this.tempToken = tempToken;
        this.connectorsAuth = connectorsAuth;
        this.headers = headers;
    }

    private AuthRequestParameters() {
        this.apiKey = null;
        this.sessionToken = null;
        this.tempToken = null;
        this.headers = null;
    }

    public AuthRequestParameters(String sessionId, String apiKey) {
        this.apiKey = apiKey;
        this.sessionToken = sessionId;
        this.tempToken = null;
        this.headers = null;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getTempToken() {
        return this.tempToken;
    }

    public boolean hasSessionToken() {
        return this.sessionToken != null;
    }

    public boolean hasApiKey() {
        return this.apiKey != null;
    }

    public boolean hasTempToken() {
        return this.tempToken != null;
    }

    public boolean hasConnectorsAuth() {
        return this.connectorsAuth != null;
    }

    public String getConnectorsAuth() {
        return this.connectorsAuth;
    }

    public static AuthRequestParameters empty() {
        return new AuthRequestParameters();
    }

    public boolean hasHeaders() {
        return this.headers != null;
    }

    public static AuthRequestParameters withTempToken(String tempToken) {
        AuthRequestParameters authRequestParameters = new AuthRequestParameters();
        authRequestParameters.tempToken = tempToken;
        return authRequestParameters;
    }
}

