/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.Field;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.DocumentPackageSettingsBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import java.util.ArrayList;

public class UpdateInjectedFieldsFromTemplateExample
extends SDKSample {
    public static final String DOCUMENT_NAME = "First Document";
    public static final String DOCUMENT_ID = "doc1";
    public static final String PACKAGE_DESCRIPTION = "This is a package created using the eSignLive SDK";
    public static final String PACKAGE_EMAIL_MESSAGE = "This message should be delivered to all signers";
    public static final String PACKAGE_EMAIL_MESSAGE2 = "Changed the email message";
    public static final String PLACEHOLDER_ID = "PlaceholderId1";
    public static final String SIGNER1_FIRST = "John";
    public static final String SIGNER1_LAST = "Smith";
    public static final String SIGNER1_TITLE = "Manager";
    public static final String SIGNER1_COMPANY = "Acme Inc.";

    public static void main(String ... args) {
        new UpdateInjectedFieldsFromTemplateExample().run();
    }

    public UpdateInjectedFieldsFromTemplateExample() {
        this.documentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
        this.documentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
    }

    @Override
    public void execute() {
        DocumentPackage template = PackageBuilder.newPackageNamed("Template").withEmailMessage(PACKAGE_EMAIL_MESSAGE).withSigner(SignerBuilder.newSignerPlaceholder(new Placeholder(PLACEHOLDER_ID))).withDocument(DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withId(DOCUMENT_ID).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID)).onPage(0).atPosition(100.0, 100.0)).build()).build();
        template.setId(this.eslClient.getTemplateService().createTemplate(template));
        DocumentPackage newPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs(PACKAGE_DESCRIPTION).withEmailMessage(PACKAGE_EMAIL_MESSAGE2).withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName(SIGNER1_FIRST).withLastName(SIGNER1_LAST).withTitle(SIGNER1_TITLE).withCompany(SIGNER1_COMPANY).withCustomId(PLACEHOLDER_ID)).withSettings(DocumentPackageSettingsBuilder.newDocumentPackageSettings().withInPerson().build()).build();
        this.packageId = this.eslClient.getTemplateService().createPackageFromTemplate(template.getId(), newPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        Document documentToChange = DocumentBuilder.newDocumentWithName(DOCUMENT_NAME).fromStream(this.documentInputStream2, DocumentType.PDF).withId(DOCUMENT_ID).withSignature(SignatureBuilder.signatureFor(new Placeholder(PLACEHOLDER_ID)).onPage(0).atPosition(100.0, 100.0)).build();
        ArrayList<Field> injectedFields = new ArrayList<Field>();
        injectedFields.add(FieldBuilder.textField().withName("AGENT_SIG_1").withValue("AGENT_SIG_1").build());
        documentToChange.addInjectedFields(injectedFields);
        Document retrievedDocument = this.retrievedPackage.getDocument(DOCUMENT_NAME);
        this.eslClient.getPackageService().deleteDocument(this.packageId, retrievedDocument.getId().getId());
        this.eslClient.uploadDocument(documentToChange.getFileName(), documentToChange.getContent(), documentToChange, this.packageId);
    }
}

