/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.EslClient;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.ProxyConfigurationBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.Props;
import com.silanis.esl.sdk.examples.SDKSample;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.joda.time.DateMidnight;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;

public class ProxyConfigurationExample
extends SDKSample {
    private boolean allowAllSSLCertificates = true;
    private EslClient eslClientWithHttpProxy;
    private EslClient eslClientWithHttpProxyHasCredentials;
    private ProxyConfiguration httpProxyConfiguration = ProxyConfigurationBuilder.newProxyConfiguration().withHttpHost(this.proxyHost).withHttpPort(this.proxyPort).build();
    private ProxyConfiguration httpProxyWithCredentialsConfiguration = ProxyConfigurationBuilder.newProxyConfiguration().withHttpHost(this.proxyWithCredentialsHost).withHttpPort(this.proxyWithCredentialsPort).withCredentials(this.proxyUserName, this.proxyPassword).build();
    public DocumentPackage retrievedPackage1;
    public DocumentPackage retrievedPackage2;

    public static void main(String ... args) {
        new ProxyConfigurationExample(Props.get()).run();
    }

    public ProxyConfigurationExample(Properties props) {
        this(props.getProperty("api.key"), props.getProperty("api.url"));
    }

    public ProxyConfigurationExample(String apiKey, String apiUrl) {
        super(apiKey, apiUrl);
        this.eslClientWithHttpProxy = new EslClient(apiKey, apiUrl, this.allowAllSSLCertificates, this.httpProxyConfiguration);
        this.eslClientWithHttpProxyHasCredentials = new EslClient(apiKey, apiUrl, this.allowAllSSLCertificates, this.httpProxyWithCredentialsConfiguration);
    }

    @Override
    public void execute() {
        HttpProxyServer httpProxyServer = DefaultHttpProxyServer.bootstrap().withPort(this.proxyPort).start();
        DocumentPackage package1 = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document pdf").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId1 = this.eslClientWithHttpProxy.createAndSendPackage(package1);
        this.retrievedPackage1 = this.eslClientWithHttpProxy.getPackage(packageId1);
        httpProxyServer.stop();
        HttpProxyServer httpProxyWithCredentialsServer = this.startHttpProxyWithCredentials(this.proxyWithCredentialsPort, "httpUser", "httpPwd");
        DocumentPackage package2 = PackageBuilder.newPackageNamed("ProxyConfigurationExample2 " + new SimpleDateFormat("HH:mm:ss").format(new Date())).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith")).withDocument(DocumentBuilder.newDocumentWithName("First Document pdf").fromStream(this.documentInputStream2, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).atPosition(100.0, 100.0))).build();
        PackageId packageId2 = this.eslClientWithHttpProxyHasCredentials.createAndSendPackage(package2);
        this.retrievedPackage2 = this.eslClientWithHttpProxyHasCredentials.getPackage(packageId2);
        httpProxyWithCredentialsServer.stop();
    }

    private HttpProxyServer startHttpProxyWithCredentials(int port, final String acceptedUsername, final String acceptedPassword) {
        HttpProxyServer httpProxyServer = DefaultHttpProxyServer.bootstrap().withPort(port).withProxyAuthenticator(new ProxyAuthenticator(){

            public boolean authenticate(String s1, String s2) {
                return acceptedUsername.equals(s1) && acceptedPassword.equals(s2);
            }
        }).start();
        return httpProxyServer;
    }
}

