/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.FieldBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.examples.SDKSample;
import org.joda.time.DateMidnight;

public class DocumentUploadExample
extends SDKSample {
    public static final String UPLOADED_DOCUMENT_NAME = "First Document";
    public Document document;
    public Document uploadedDocument;

    public static void main(String ... args) {
        new DocumentUploadExample().run();
    }

    @Override
    public void execute() {
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").expiresAt(DateMidnight.now().plusMonths(1).toDate()).withEmailMessage("This message should be delivered to all signers").withSigner(SignerBuilder.newSignerWithEmail(this.email1).withCustomId("Client1").withFirstName("John").withLastName("Smith").withTitle("Managing Director").withCompany("Acme Inc.")).build();
        this.packageId = this.eslClient.createPackage(superDuperPackage);
        superDuperPackage.setId(this.packageId);
        this.document = DocumentBuilder.newDocumentWithName(UPLOADED_DOCUMENT_NAME).fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).onPage(0).withField(FieldBuilder.checkBox().onPage(0).atPosition(400.0, 200.0).withValue("X")).atPosition(100.0, 100.0)).build();
        this.uploadedDocument = this.eslClient.uploadDocument(this.document.getFileName(), this.document.getContent(), this.document, this.packageId);
        this.eslClient.sendPackage(superDuperPackage.getId());
        SessionToken sessionToken = this.eslClient.getSessionService().createSessionToken(superDuperPackage.getId().toString(), "Client1");
    }
}

