/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.examples;

import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentType;
import com.silanis.esl.sdk.RequirementStatus;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.builder.AttachmentRequirementBuilder;
import com.silanis.esl.sdk.builder.DocumentBuilder;
import com.silanis.esl.sdk.builder.PackageBuilder;
import com.silanis.esl.sdk.builder.SignatureBuilder;
import com.silanis.esl.sdk.builder.SignerBuilder;
import com.silanis.esl.sdk.builder.internal.StreamDocumentSource;
import com.silanis.esl.sdk.examples.SDKSample;
import com.silanis.esl.sdk.io.DownloadedFile;
import com.silanis.esl.sdk.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipFile;

public class AttachmentRequirementExample
extends SDKSample {
    private InputStream attachmentInputStream1 = this.getClass().getClassLoader().getResourceAsStream("document-for-anchor-extraction.pdf");
    private InputStream attachmentInputStream2 = this.getClass().getClassLoader().getResourceAsStream("document-with-fields.pdf");
    private InputStream attachmentInputStream3 = this.getClass().getClassLoader().getResourceAsStream("extract_document.pdf");
    private Signer signer1;
    private String attachment1Id;
    public static final String NAME1 = "Driver's license";
    public static final String DESCRIPTION1 = "Please upload a scanned copy of your driver's license.";
    public static final String NAME2 = "Medicare card";
    public static final String DESCRIPTION2 = "Optional attachment.";
    public static final String NAME3 = "Attachment3";
    public static final String DESCRIPTION3 = "Third description";
    public static final String SIGNER1_ID = "signer1Id";
    public static final String SIGNER2_ID = "signer2Id";
    public static final String REJECTION_COMMENT = "Reject: uploaded wrong attachment.";
    public static final String ATTACHMENT_FILE_NAME1 = "The attachment1 for signer1.pdf";
    public static final String ATTACHMENT_FILE_NAME2 = DocumentType.PDF.normalizeName("The attachment1 for signer2");
    public static final String ATTACHMENT_FILE_NAME3 = "The attachment2 for signer2.pdf";
    public static final String DOWNLOADED_ALL_ATTACHMENTS_FOR_PACKAGE_ZIP = "downloadedAllAttachmentsForPackage.zip";
    public static final String DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER1_IN_PACKAGE_ZIP = "downloadedAllAttachmentsForSigner1InPackage.zip";
    public static final String DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER2_IN_PACKAGE_ZIP = "downloadedAllAttachmentsForSigner2InPackage.zip";
    public DocumentPackage retrievedPackageAfterRejection;
    public DocumentPackage retrievedPackageAfterAccepting;
    public List<AttachmentRequirement> signer1Attachments;
    public List<AttachmentRequirement> signer2Attachments;
    public AttachmentRequirement signer1Att1;
    public AttachmentRequirement signer2Att1;
    public AttachmentRequirement signer2Att2;
    public RequirementStatus retrievedSigner1Att1RequirementStatus;
    public RequirementStatus retrievedSigner2Att1RequirementStatus;
    public RequirementStatus retrievedSigner2Att2RequirementStatus;
    public RequirementStatus retrievedSigner1Att1RequirementStatusAfterRejection;
    public RequirementStatus retrievedSigner1Att1RequirementStatusAfterAccepting;
    public String retrievedSigner1Att1RequirementSenderCommentAfterRejection;
    public String retrievedSigner1Att1RequirementSenderCommentAfterAccepting;
    public File downloadedAttachemnt1;
    public long attachment1ForSigner1FileSize;
    public ZipFile downloadedAllAttachmentsForPackageZip;
    public ZipFile downloadedAllAttachmentsForSigner1InPackageZip;
    public ZipFile downloadedAllAttachmentsForSigner2InPackageZip;

    public static void main(String ... args) {
        new AttachmentRequirementExample().run();
    }

    @Override
    public void execute() {
        this.signer1 = SignerBuilder.newSignerWithEmail(this.email1).withFirstName("John").withLastName("Smith").withCustomId(SIGNER1_ID).withAttachmentRequirement(AttachmentRequirementBuilder.newAttachmentRequirementWithName(NAME1).withDescription(DESCRIPTION1).isRequiredAttachment().build()).build();
        Signer signer2 = SignerBuilder.newSignerWithEmail(this.email2).withFirstName("Patty").withLastName("Galant").withCustomId(SIGNER2_ID).withAttachmentRequirement(AttachmentRequirementBuilder.newAttachmentRequirementWithName(NAME2).withDescription(DESCRIPTION2).build()).withAttachmentRequirement(AttachmentRequirementBuilder.newAttachmentRequirementWithName(NAME3).withDescription(DESCRIPTION3).isRequiredAttachment().build()).build();
        DocumentPackage superDuperPackage = PackageBuilder.newPackageNamed(this.getPackageName()).describedAs("This is a package created using the eSignLive SDK").withSigner(this.signer1).withSigner(signer2).withDocument(DocumentBuilder.newDocumentWithName("test document").fromStream(this.documentInputStream1, DocumentType.PDF).withSignature(SignatureBuilder.signatureFor(this.email1).build()).build()).build();
        this.packageId = this.eslClient.createAndSendPackage(superDuperPackage);
        this.retrievedPackage = this.eslClient.getPackage(this.packageId);
        this.attachment1Id = this.retrievedPackage.getSigner(this.email1).getAttachmentRequirement(NAME1).getId();
        this.signer1 = this.retrievedPackage.getSigner(this.email1);
        this.signer1Attachments = this.retrievedPackage.getSigner(this.email1).getAttachmentRequirements();
        this.signer2Attachments = this.retrievedPackage.getSigner(this.email2).getAttachmentRequirements();
        this.signer1Att1 = this.signer1Attachments.get(0);
        this.signer2Att1 = this.signer2Attachments.get(0);
        this.signer2Att2 = this.signer2Attachments.get(1);
        this.retrievedSigner1Att1RequirementStatus = this.signer1Att1.getStatus();
        this.retrievedSigner2Att1RequirementStatus = this.signer2Att1.getStatus();
        this.retrievedSigner2Att2RequirementStatus = this.signer2Att2.getStatus();
        byte[] attachment1ForSigner1FileContent = new StreamDocumentSource(this.attachmentInputStream1).content();
        this.eslClient.uploadAttachment(this.packageId, this.signer1Att1.getId(), ATTACHMENT_FILE_NAME1, attachment1ForSigner1FileContent, SIGNER1_ID);
        this.attachment1ForSigner1FileSize = attachment1ForSigner1FileContent.length;
        this.eslClient.uploadAttachment(this.packageId, this.signer2Att1.getId(), ATTACHMENT_FILE_NAME2, new StreamDocumentSource(this.attachmentInputStream2).content(), SIGNER2_ID);
        this.eslClient.uploadAttachment(this.packageId, this.signer2Att2.getId(), ATTACHMENT_FILE_NAME3, new StreamDocumentSource(this.attachmentInputStream3).content(), SIGNER2_ID);
        this.eslClient.getAttachmentRequirementService().rejectAttachment(this.packageId, this.signer1, NAME1, REJECTION_COMMENT);
        this.retrievedPackageAfterRejection = this.eslClient.getPackage(this.packageId);
        this.retrievedSigner1Att1RequirementStatusAfterRejection = this.retrievedPackageAfterRejection.getSigner(this.email1).getAttachmentRequirement(NAME1).getStatus();
        this.retrievedSigner1Att1RequirementSenderCommentAfterRejection = this.retrievedPackageAfterRejection.getSigner(this.email1).getAttachmentRequirement(NAME1).getSenderComment();
        this.eslClient.getAttachmentRequirementService().acceptAttachment(this.packageId, this.signer1, NAME1);
        this.retrievedPackageAfterAccepting = this.eslClient.getPackage(this.packageId);
        this.retrievedSigner1Att1RequirementStatusAfterAccepting = this.retrievedPackageAfterAccepting.getSigner(this.email1).getAttachmentRequirement(NAME1).getStatus();
        this.retrievedSigner1Att1RequirementSenderCommentAfterAccepting = this.retrievedPackageAfterAccepting.getSigner(this.email1).getAttachmentRequirement(NAME1).getSenderComment();
        DownloadedFile downloadedAttachment = this.eslClient.getAttachmentRequirementService().downloadAttachmentFile(this.packageId, this.attachment1Id);
        Files.saveTo(downloadedAttachment.getContents(), downloadedAttachment.getFilename());
        DownloadedFile downloadedAllAttachmentsForPackage = this.eslClient.getAttachmentRequirementService().downloadAllAttachmentFilesForPackage(this.packageId);
        Files.saveTo(downloadedAllAttachmentsForPackage.getContents(), DOWNLOADED_ALL_ATTACHMENTS_FOR_PACKAGE_ZIP);
        DownloadedFile downloadedAllAttachmentsForSigner1InPackage = this.eslClient.getAttachmentRequirementService().downloadAllAttachmentFilesForSignerInPackage(this.retrievedPackage, this.signer1);
        Files.saveTo(downloadedAllAttachmentsForSigner1InPackage.getContents(), DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER1_IN_PACKAGE_ZIP);
        DownloadedFile downloadedAllAttachmentsForSigner2InPackage = this.eslClient.getAttachmentRequirementService().downloadAllAttachmentFilesForSignerInPackage(this.retrievedPackage, signer2);
        Files.saveTo(downloadedAllAttachmentsForSigner2InPackage.getContents(), DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER2_IN_PACKAGE_ZIP);
        try {
            this.downloadedAttachemnt1 = new File(downloadedAttachment.getFilename());
            this.downloadedAllAttachmentsForPackageZip = new ZipFile(DOWNLOADED_ALL_ATTACHMENTS_FOR_PACKAGE_ZIP);
            this.downloadedAllAttachmentsForSigner1InPackageZip = new ZipFile(DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER1_IN_PACKAGE_ZIP);
            this.downloadedAllAttachmentsForSigner2InPackageZip = new ZipFile(DOWNLOADED_ALL_ATTACHMENTS_FOR_SIGNER2_IN_PACKAGE_ZIP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

