/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.AttachmentRequirement;
import com.silanis.esl.sdk.Authentication;
import com.silanis.esl.sdk.AuthenticationMethod;
import com.silanis.esl.sdk.Challenge;
import com.silanis.esl.sdk.GroupId;
import com.silanis.esl.sdk.KnowledgeBasedAuthentication;
import com.silanis.esl.sdk.Placeholder;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.SignerInformationForEquifaxCanada;
import com.silanis.esl.sdk.SignerInformationForEquifaxUSA;
import com.silanis.esl.sdk.builder.AttachmentRequirementBuilder;
import com.silanis.esl.sdk.builder.SignerInformationForEquifaxCanadaBuilder;
import com.silanis.esl.sdk.builder.SignerInformationForEquifaxUSABuilder;
import com.silanis.esl.sdk.internal.Asserts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class SignerBuilder {
    public static final int DEFAULT_SIGNING_ORDER = 0;
    private final String email;
    private final GroupId groupId;
    private String firstName;
    private String lastName;
    private int signingOrder = 0;
    private AuthenticationBuilder authenticationBuilder = new AuthenticationBuilder();
    private Authentication authentication = null;
    private String title = "";
    private String company = "";
    private Locale language;
    private boolean canChangeSigner;
    private String message = "";
    private boolean deliverSignedDocumentsByEmail;
    private String id = null;
    private String placeholderName = null;
    private List<AttachmentRequirement> attachments = new ArrayList<AttachmentRequirement>();
    private KnowledgeBasedAuthentication knowledgeBasedAuthentication;

    private SignerBuilder(String email) {
        this.email = email == null ? email : email.toLowerCase();
        this.groupId = null;
    }

    private SignerBuilder(GroupId groupId) {
        this.email = null;
        this.groupId = groupId;
    }

    private SignerBuilder(Placeholder placeholder) {
        this.email = null;
        this.groupId = null;
        this.id = placeholder.getId();
        this.placeholderName = placeholder.getName();
        this.signingOrder = placeholder.getSigningOrder();
    }

    public static SignerBuilder newSignerWithEmail(String email) {
        return new SignerBuilder(email);
    }

    public static SignerBuilder newSignerFromGroup(GroupId groupId) {
        return new SignerBuilder(groupId);
    }

    public static SignerBuilder newSignerPlaceholder(Placeholder placeholder) {
        return new SignerBuilder(placeholder);
    }

    public SignerBuilder withCustomId(String id) {
        this.id = id;
        return this;
    }

    public SignerBuilder replacing(Placeholder placeholder) {
        this.id = placeholder.getId();
        return this;
    }

    public SignerBuilder withFirstName(String firstName) {
        Asserts.genericAssert(!this.isGroupSigner(), "first name can not be set for a group signer");
        this.firstName = firstName;
        return this;
    }

    public SignerBuilder withLastName(String lastName) {
        Asserts.genericAssert(!this.isGroupSigner(), "last name can not be set for a group signer");
        this.lastName = lastName;
        return this;
    }

    public SignerBuilder signingOrder(int signingOrder) {
        this.signingOrder = signingOrder;
        return this;
    }

    private Signer buildGroupSigner() {
        Signer result = new Signer(this.groupId);
        result.setSigningOrder(this.signingOrder);
        result.setCanChangeSigner(this.canChangeSigner);
        result.setMessage(this.message);
        result.setId(this.id);
        result.setAttachmentRequirements(this.attachments);
        return result;
    }

    private Signer buildPlaceholderSigner() {
        Signer result = new Signer(this.id);
        result.setPlaceholderName(this.placeholderName);
        Asserts.notNullOrEmpty(this.id, "No placeholder set for this signer!");
        result.setSigningOrder(this.signingOrder);
        result.setCanChangeSigner(this.canChangeSigner);
        result.setMessage(this.message);
        result.setAttachmentRequirements(this.attachments);
        return result;
    }

    private Signer buildRegularSigner() {
        if (this.authentication == null) {
            this.authentication = this.authenticationBuilder.build();
        }
        Asserts.notNullOrEmpty(this.firstName, "first name");
        Asserts.notNullOrEmpty(this.lastName, "last name");
        Signer result = new Signer(this.email, this.firstName, this.lastName, this.authentication);
        result.setTitle(this.title);
        result.setCompany(this.company);
        result.setLanguage(this.language);
        result.setDeliverSignedDocumentsByEmail(this.deliverSignedDocumentsByEmail);
        result.setSigningOrder(this.signingOrder);
        result.setCanChangeSigner(this.canChangeSigner);
        result.setMessage(this.message);
        result.setId(this.id);
        result.setAttachmentRequirements(this.attachments);
        result.setKnowledgeBasedAuthentication(this.knowledgeBasedAuthentication);
        return result;
    }

    public Signer build() {
        Signer signer = this.isGroupSigner() ? this.buildGroupSigner() : (this.isPlaceholder() ? this.buildPlaceholderSigner() : this.buildRegularSigner());
        return signer;
    }

    public SignerBuilder challengedWithQuestions(ChallengeBuilder challengeBuilder) {
        this.authenticationBuilder = challengeBuilder;
        return this;
    }

    public SignerBuilder withSmsSentTo(String phoneNumber) {
        this.authenticationBuilder = new SMSAuthenticationBuilder(phoneNumber);
        return this;
    }

    public SignerBuilder withAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public SignerBuilder withTitle(String title) {
        Asserts.genericAssert(!this.isGroupSigner(), "title can not be set for a group signer");
        this.title = title;
        return this;
    }

    public SignerBuilder withCompany(String company) {
        Asserts.genericAssert(!this.isGroupSigner(), "company can not be set for a group signer");
        this.company = company;
        return this;
    }

    public SignerBuilder withLanguage(Locale language) {
        Asserts.genericAssert(!this.isGroupSigner(), "language can not be set for a group signer");
        this.language = language;
        return this;
    }

    public SignerBuilder canChangeSigner() {
        this.canChangeSigner = true;
        return this;
    }

    public SignerBuilder withEmailMessage(String message) {
        this.message = message;
        return this;
    }

    public SignerBuilder deliverSignedDocumentsByEmail() {
        this.deliverSignedDocumentsByEmail = true;
        return this;
    }

    @Deprecated
    public SignerBuilder withRoleId(String roleId) {
        return this.withCustomId(roleId);
    }

    public SignerBuilder withAttachmentRequirement(AttachmentRequirementBuilder builder) {
        return this.withAttachmentRequirement(builder.build());
    }

    public SignerBuilder withAttachmentRequirement(AttachmentRequirement attachmentRequirement) {
        this.addAttachment(attachmentRequirement);
        return this;
    }

    private void addAttachment(AttachmentRequirement attachmentRequirement) {
        this.attachments.add(attachmentRequirement);
    }

    public SignerBuilder challengedWithKnowledgeBasedAuthentication(KnowledgeBasedAuthentication knowledgeBasedAuthentication) {
        this.knowledgeBasedAuthentication = knowledgeBasedAuthentication;
        return this;
    }

    public SignerBuilder challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxCanadaBuilder signerInformationForEquifaxCanadaBuilder) {
        return this.challengedWithKnowledgeBasedAuthentication(signerInformationForEquifaxCanadaBuilder.build());
    }

    public SignerBuilder challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxCanada signerInformationForEquifaxCanada) {
        if (this.knowledgeBasedAuthentication == null) {
            this.knowledgeBasedAuthentication = new KnowledgeBasedAuthentication();
        }
        this.knowledgeBasedAuthentication.setSignerInformationForEquifaxCanada(signerInformationForEquifaxCanada);
        return this;
    }

    public SignerBuilder challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxUSABuilder signerInformationForEquifaxUSABuilder) {
        return this.challengedWithKnowledgeBasedAuthentication(signerInformationForEquifaxUSABuilder.build());
    }

    public SignerBuilder challengedWithKnowledgeBasedAuthentication(SignerInformationForEquifaxUSA signerInformationForEquifaxUSA) {
        if (this.knowledgeBasedAuthentication == null) {
            this.knowledgeBasedAuthentication = new KnowledgeBasedAuthentication();
        }
        this.knowledgeBasedAuthentication.setSignerInformationForEquifaxUSA(signerInformationForEquifaxUSA);
        return this;
    }

    private boolean isGroupSigner() {
        return this.groupId != null;
    }

    private boolean isPlaceholder() {
        return this.groupId == null && this.email == null;
    }

    public static class SMSAuthenticationBuilder
    extends AuthenticationBuilder {
        private final String phoneNumber;

        public SMSAuthenticationBuilder(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public Authentication build() {
            Asserts.notNullOrEmpty(this.phoneNumber, "phone number");
            return new Authentication(this.phoneNumber);
        }
    }

    public static class ChallengeBuilder
    extends AuthenticationBuilder {
        private String question;
        private final List<Challenge> challenges = new ArrayList<Challenge>();

        public ChallengeBuilder(String question) {
            this.question = question;
        }

        public static ChallengeBuilder firstQuestion(String question) {
            return new ChallengeBuilder(question);
        }

        public ChallengeBuilder secondQuestion(String question) {
            this.question = question;
            return this;
        }

        public ChallengeBuilder answer(String answer) {
            this.challenges.add(new Challenge(this.question, answer));
            return this;
        }

        @Deprecated
        public ChallengeBuilder answer(String answer, Challenge.MaskOptions maskOption) {
            this.challenges.add(new Challenge(this.question, answer, maskOption));
            return this;
        }

        public ChallengeBuilder answerWithMaskInput(String answer) {
            this.challenges.add(new Challenge(this.question, answer, Challenge.MaskOptions.MaskInput));
            return this;
        }

        @Override
        public Authentication build() {
            if (this.questionProvided() && this.challenges.isEmpty()) {
                throw new IllegalStateException("Question challenge was provided with no answer");
            }
            return new Authentication(this.challenges);
        }

        private boolean questionProvided() {
            return this.question != null && !this.question.trim().isEmpty();
        }
    }

    public static class AuthenticationBuilder {
        private final AuthenticationMethod method;

        private AuthenticationBuilder() {
            this.method = AuthenticationMethod.EMAIL;
        }

        private AuthenticationBuilder(AuthenticationMethod method) {
            this.method = method;
        }

        public static AuthenticationBuilder newAuthenticationWithMethod(AuthenticationMethod method) {
            return new AuthenticationBuilder(method);
        }

        public Authentication build() {
            return new Authentication(this.method);
        }
    }
}

