/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.google.common.base.Preconditions;
import com.silanis.esl.api.util.EmailValidator;
import com.silanis.esl.sdk.SenderInfo;

public class SenderInfoBuilder {
    private String email = null;
    private String firstName = null;
    private String lastName = null;
    private String company = null;
    private String title = null;

    public static SenderInfoBuilder newSenderInfo(String email) {
        return new SenderInfoBuilder(email);
    }

    private SenderInfoBuilder(String email) {
        String checkedEmail = (String)Preconditions.checkNotNull((Object)email, (Object)"email cannot be null.");
        Preconditions.checkArgument((!checkedEmail.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)new EmailValidator().valid(checkedEmail));
        this.email = checkedEmail;
    }

    public SenderInfoBuilder withName(String firstName, String lastName) {
        this.firstName = firstName;
        this.lastName = lastName;
        return this;
    }

    public SenderInfoBuilder withCompany(String company) {
        this.company = company;
        return this;
    }

    public SenderInfoBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public SenderInfo build() {
        SenderInfo result = new SenderInfo();
        result.setEmail(this.email);
        result.setFirstName(this.firstName);
        result.setLastName(this.lastName);
        result.setCompany(this.company);
        result.setTitle(this.title);
        return result;
    }
}

