/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.FieldValidator;
import java.util.ArrayList;
import java.util.List;

public class FieldValidatorBuilder {
    public static final String EMAIL_REGEX = "^([a-z0-9_\\.-]+)@([\\da-z\\.-]+)\\.([a-z\\.]{2,6})$";
    public static final String URL_REGEX = "^(https?:\\/\\/)?([\\da-z\\.-]+)\\.([a-z\\.]{2,6})([\\/\\w \\.-]*)*\\/?$";
    public static final String ALPHABETIC_REGEX = "^[\\sa-zA-Z]+$";
    public static final String ALPHANUMERIC_REGEX = "^[\\s0-9a-zA-Z]+$";
    public static final String NUMERIC_REGEX = "^[-+]?[0-9]*\\.?[0-9]*$";
    public static final String DEFAULT_REGEX = null;
    public static final String DEFAULT_DATEPICKER_FORMAT = "YYYY-MM-dd";
    public static final String ALPHABETIC_ERROR_MESSAGE = "Value entered must by alphabetic only.";
    public static final String ALPHANUMERIC_ERROR_MESSAGE = "Value entered must be alphanumeric only.";
    public static final String NUMERIC_ERROR_MESSAGE = "Value entered must be numeric only.";
    public static final String EMAIL_ERROR_MESSAGE = "Value entered must be an email.";
    public static final String URL_ERROR_MESSAGE = "Value entered must be a URL.";
    public static final String DATEPICKER_ERROR_MESSAGE = "Value entered must be valid DateTimeFormat only.";
    private static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    private List<String> options = new ArrayList<String>();
    private int minLength = 0;
    private int maxLength = Integer.MAX_VALUE;
    private String regex;
    private boolean required;
    private String errorMessage;

    private FieldValidatorBuilder(String regex) {
        this.regex = regex;
    }

    public static FieldValidatorBuilder url() {
        return new FieldValidatorBuilder(URL_REGEX).withErrorMessage(URL_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder email() {
        return new FieldValidatorBuilder(EMAIL_REGEX).withErrorMessage(EMAIL_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder alphabetic() {
        return new FieldValidatorBuilder(ALPHABETIC_REGEX).withErrorMessage(ALPHABETIC_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder alphanumeric() {
        return new FieldValidatorBuilder(ALPHANUMERIC_REGEX).withErrorMessage(ALPHANUMERIC_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder numeric() {
        return new FieldValidatorBuilder(NUMERIC_REGEX).withErrorMessage(NUMERIC_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder datepickerFormat() {
        return new FieldValidatorBuilder(DEFAULT_DATEPICKER_FORMAT).withErrorMessage(DATEPICKER_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder datepickerFormat(String format) {
        return new FieldValidatorBuilder(format).withErrorMessage(DATEPICKER_ERROR_MESSAGE);
    }

    public static FieldValidatorBuilder regex(String regex) {
        return new FieldValidatorBuilder(regex);
    }

    public static FieldValidatorBuilder basic() {
        return new FieldValidatorBuilder(DEFAULT_REGEX);
    }

    public FieldValidatorBuilder withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public FieldValidatorBuilder minLength(int minLength) {
        this.minLength = minLength;
        return this;
    }

    public FieldValidatorBuilder maxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public FieldValidatorBuilder withOption(String option) {
        this.options.add(option);
        return this;
    }

    public FieldValidatorBuilder required() {
        this.required = true;
        return this;
    }

    public FieldValidator build() {
        FieldValidator result = new FieldValidator();
        if (this.minLength < 0) {
            throw new IllegalArgumentException("minLength can not be less than 0");
        }
        result.setMinLength(this.minLength);
        if (this.maxLength < 0) {
            throw new IllegalArgumentException("maxLength can not be less than 0");
        }
        result.setMaxLength(this.maxLength);
        if (this.minLength > this.maxLength) {
            throw new IllegalArgumentException("maxLength can not be less than minLength");
        }
        result.setRegex(this.regex);
        result.getOptions().addAll(this.options);
        result.setRequired(this.required);
        result.setErrorMessage(this.errorMessage);
        return result;
    }
}

