/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk.builder;

import com.silanis.esl.sdk.CeremonyLayoutSettings;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.builder.CeremonyLayoutSettingsBuilder;
import com.silanis.esl.sdk.internal.Asserts;
import java.util.ArrayList;
import java.util.List;

public class DocumentPackageSettingsBuilder {
    private Boolean enableInPerson = null;
    private Boolean enableOptOut = null;
    private Boolean enableDecline = null;
    private Boolean hideWatermark = null;
    private Boolean hideCaptureText = null;
    private List<String> declineReasons = new ArrayList<String>();
    private List<String> optOutReasons = new ArrayList<String>();
    private Integer maxAuthAttempts = null;
    private Boolean showDocumentToolbarDownloadButton = null;
    private Boolean showDialogOnComplete = null;
    private Boolean showPackageOwnerInPerson = null;
    private Boolean showLanguageDropDown = null;
    private Boolean enableFirstAffidavit = null;
    private Boolean enableSecondAffidavit = null;
    private Boolean disableDeclineOther = null;
    private Boolean disableOptOutOther = null;
    private String linkText = null;
    private String linkTooltip = null;
    private String linkHref = null;
    private CeremonyLayoutSettings ceremonyLayoutSettings = null;

    private DocumentPackageSettingsBuilder() {
    }

    public static DocumentPackageSettingsBuilder newDocumentPackageSettings() {
        return new DocumentPackageSettingsBuilder();
    }

    public DocumentPackageSettingsBuilder showOwnerInPersonDropDown() {
        this.showPackageOwnerInPerson = true;
        return this;
    }

    public DocumentPackageSettingsBuilder hideOwnerInPersonDropDown() {
        this.showPackageOwnerInPerson = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withLanguageDropDown() {
        this.showLanguageDropDown = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutLanguageDropDown() {
        this.showLanguageDropDown = false;
        return this;
    }

    public DocumentPackageSettingsBuilder enableFirstAffidavit() {
        this.enableFirstAffidavit = true;
        return this;
    }

    public DocumentPackageSettingsBuilder disableFirstAffidavit() {
        this.enableFirstAffidavit = false;
        return this;
    }

    public DocumentPackageSettingsBuilder enableSecondAffidavit() {
        this.enableSecondAffidavit = true;
        return this;
    }

    public DocumentPackageSettingsBuilder disableSecondAffidavit() {
        this.enableSecondAffidavit = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withDialogOnComplete() {
        this.showDialogOnComplete = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDialogOnComplete() {
        this.showDialogOnComplete = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withInPerson() {
        this.enableInPerson = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutInPerson() {
        this.enableInPerson = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withOptOut() {
        this.enableOptOut = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutOptOut() {
        this.enableOptOut = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withDecline() {
        this.enableDecline = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDecline() {
        this.enableDecline = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withWatermark() {
        this.hideWatermark = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutWatermark() {
        this.hideWatermark = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withCaptureText() {
        this.hideCaptureText = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutCaptureText() {
        this.hideCaptureText = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkHref(String href) {
        Asserts.notNullOrEmpty(href, "href");
        this.linkHref = href;
        if (!this.linkHref.startsWith("http://") && !this.linkHref.startsWith("https://")) {
            this.linkHref = "https://" + this.linkHref;
        }
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkText(String text) {
        this.linkText = text;
        return this;
    }

    public DocumentPackageSettingsBuilder withHandOverLinkTooltip(String tooltip) {
        this.linkTooltip = tooltip;
        return this;
    }

    public DocumentPackageSettingsBuilder withCeremonyLayoutSettings(CeremonyLayoutSettingsBuilder ceremonyLayoutSettingsBuilder) {
        return this.withCeremonyLayoutSettings(ceremonyLayoutSettingsBuilder.build());
    }

    public DocumentPackageSettingsBuilder withCeremonyLayoutSettings(CeremonyLayoutSettings ceremonyLayoutSettings) {
        this.ceremonyLayoutSettings = ceremonyLayoutSettings;
        return this;
    }

    public DocumentPackageSettings build() {
        DocumentPackageSettings result = new DocumentPackageSettings();
        result.setEnableInPerson(this.enableInPerson);
        result.setEnableOptOut(this.enableOptOut);
        result.setEnableDecline(this.enableDecline);
        result.setHideWatermark(this.hideWatermark);
        result.setHideCaptureText(this.hideCaptureText);
        result.getDeclineReasons().addAll(this.declineReasons);
        result.getOptOutReasons().addAll(this.optOutReasons);
        result.setMaxAuthAttempts(this.maxAuthAttempts);
        result.setShowDocumentToolbarDownloadButton(this.showDocumentToolbarDownloadButton);
        result.setShowDialogOnComplete(this.showDialogOnComplete);
        result.setEnableFirstAffidavit(this.enableFirstAffidavit);
        result.setEnableSecondAffidavit(this.enableSecondAffidavit);
        result.setShowLanguageDropDown(this.showLanguageDropDown);
        result.setShowPackageOwnerInPerson(this.showPackageOwnerInPerson);
        result.setLinkHref(this.linkHref);
        result.setLinkText(this.linkText);
        result.setLinkTooltip(this.linkTooltip);
        result.setDisableDeclineOther(this.disableDeclineOther);
        result.setDisableOptOutOther(this.disableOptOutOther);
        result.setCeremonyLayoutSettings(this.ceremonyLayoutSettings);
        return result;
    }

    public DocumentPackageSettingsBuilder withDeclineReason(String reason) {
        this.declineReasons.add(reason);
        return this;
    }

    public DocumentPackageSettingsBuilder withOptOutReason(String reason) {
        this.optOutReasons.add(reason);
        return this;
    }

    public DocumentPackageSettingsBuilder withDocumentToolbarDownloadButton() {
        this.showDocumentToolbarDownloadButton = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDocumentToolbarDownloadButton() {
        this.showDocumentToolbarDownloadButton = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withDeclineOther() {
        this.disableDeclineOther = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutDeclineOther() {
        this.disableDeclineOther = true;
        return this;
    }

    public DocumentPackageSettingsBuilder withOptOutOther() {
        this.disableOptOutOther = false;
        return this;
    }

    public DocumentPackageSettingsBuilder withoutOptOutOther() {
        this.disableOptOutOther = true;
        return this;
    }
}

