/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.api.model.Package;
import com.silanis.esl.api.model.SignedDocuments;
import com.silanis.esl.api.model.Verification;
import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentId;
import com.silanis.esl.sdk.DocumentPackage;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentVisibility;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.FieldSummary;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.ProxyConfiguration;
import com.silanis.esl.sdk.SessionToken;
import com.silanis.esl.sdk.Signature;
import com.silanis.esl.sdk.SignatureStyle;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.SignerId;
import com.silanis.esl.sdk.SignerVerification;
import com.silanis.esl.sdk.SigningStatus;
import com.silanis.esl.sdk.VersionUtil;
import com.silanis.esl.sdk.internal.Asserts;
import com.silanis.esl.sdk.internal.RestClient;
import com.silanis.esl.sdk.internal.SignerRestClient;
import com.silanis.esl.sdk.internal.converter.DocumentConverter;
import com.silanis.esl.sdk.internal.converter.DocumentPackageConverter;
import com.silanis.esl.sdk.internal.converter.SignerVerificationConverter;
import com.silanis.esl.sdk.service.AccountService;
import com.silanis.esl.sdk.service.ApprovalService;
import com.silanis.esl.sdk.service.AttachmentRequirementService;
import com.silanis.esl.sdk.service.AuditService;
import com.silanis.esl.sdk.service.AuthenticationService;
import com.silanis.esl.sdk.service.AuthenticationTokensService;
import com.silanis.esl.sdk.service.CustomFieldService;
import com.silanis.esl.sdk.service.EventNotificationService;
import com.silanis.esl.sdk.service.FieldSummaryService;
import com.silanis.esl.sdk.service.GroupService;
import com.silanis.esl.sdk.service.LayoutService;
import com.silanis.esl.sdk.service.PackageService;
import com.silanis.esl.sdk.service.QRCodeService;
import com.silanis.esl.sdk.service.ReminderService;
import com.silanis.esl.sdk.service.ReportService;
import com.silanis.esl.sdk.service.SessionService;
import com.silanis.esl.sdk.service.SignatureImageService;
import com.silanis.esl.sdk.service.SignerVerificationService;
import com.silanis.esl.sdk.service.SigningService;
import com.silanis.esl.sdk.service.SystemService;
import com.silanis.esl.sdk.service.TemplateService;
import com.silanis.esl.sdk.service.apiclient.AccountApiClient;
import com.silanis.esl.sdk.service.apiclient.ApprovalApiClient;
import com.silanis.esl.sdk.service.apiclient.AttachmentRequirementApiClient;
import com.silanis.esl.sdk.service.apiclient.AuditApiClient;
import com.silanis.esl.sdk.service.apiclient.AuthenticationTokensApiClient;
import com.silanis.esl.sdk.service.apiclient.CustomFieldApiClient;
import com.silanis.esl.sdk.service.apiclient.EventNotificationApiClient;
import java.util.LinkedHashMap;
import java.util.List;

public class EslClient {
    private String baseURL;
    private String webpageURL;
    private PackageService packageService;
    private ReportService reportService;
    private SessionService sessionService;
    private FieldSummaryService fieldSummaryService;
    private AuditService auditService;
    private EventNotificationService eventNotificationService;
    private AuthenticationTokensService authenticationTokensService;
    private GroupService groupService;
    private CustomFieldService customFieldService;
    private AccountService accountService;
    private ApprovalService approvalService;
    private ReminderService reminderService;
    private TemplateService templateService;
    private AttachmentRequirementService attachmentRequirementService;
    private LayoutService layoutService;
    private QRCodeService qrCodeService;
    private AuthenticationService authenticationService;
    private SystemService systemService;
    private SignatureImageService signatureImageService;
    private SigningService signingService;
    private SignerVerificationService signerVerificationService;

    public EslClient(String apiKey, String baseURL) {
        Asserts.notNullOrEmpty(apiKey, "apiKey");
        Asserts.notNullOrEmpty(baseURL, "baseURL");
        this.setBaseURL(baseURL);
        this.setWebpageURL(baseURL);
        RestClient client = new RestClient(apiKey);
        this.init(client);
    }

    public EslClient(String apiKey, String baseURL, String webpageURL) {
        this(apiKey, baseURL, webpageURL, false);
    }

    public EslClient(String apiKey, String baseURL, String webpageURL, boolean allowAllSSLCertificates) {
        Asserts.notNullOrEmpty(apiKey, "apiKey");
        Asserts.notNullOrEmpty(baseURL, "baseURL");
        Asserts.notNullOrEmpty(webpageURL, "webpageURL");
        this.setBaseURL(baseURL);
        this.webpageURL = webpageURL;
        RestClient client = new RestClient(apiKey, allowAllSSLCertificates);
        this.init(client);
    }

    public EslClient(String apiKey, String baseURL, boolean allowAllSSLCertificates) {
        this(apiKey, baseURL, allowAllSSLCertificates, null);
    }

    public EslClient(String apiKey, String baseURL, ProxyConfiguration proxyConfiguration) {
        this(apiKey, baseURL, false, proxyConfiguration);
    }

    public EslClient(String apiKey, String baseURL, boolean allowAllSSLCertificates, ProxyConfiguration proxyConfiguration) {
        Asserts.notNullOrEmpty(apiKey, "apiKey");
        Asserts.notNullOrEmpty(baseURL, "baseURL");
        this.setBaseURL(baseURL);
        this.setWebpageURL(baseURL);
        RestClient client = new RestClient(apiKey, allowAllSSLCertificates, proxyConfiguration);
        this.init(client);
    }

    private void init(RestClient client) {
        this.packageService = new PackageService(client, this.baseURL);
        this.reportService = new ReportService(client, this.baseURL);
        this.systemService = new SystemService(client, this.baseURL);
        this.signingService = new SigningService(client, this.baseURL);
        this.signatureImageService = new SignatureImageService(client, this.baseURL);
        this.sessionService = new SessionService(client, this.baseURL);
        this.fieldSummaryService = new FieldSummaryService(client, this.baseURL);
        this.auditService = new AuditService(new AuditApiClient(client, this.baseURL));
        this.eventNotificationService = new EventNotificationService(new EventNotificationApiClient(client, this.baseURL));
        this.authenticationTokensService = new AuthenticationTokensService(new AuthenticationTokensApiClient(client, this.baseURL));
        this.groupService = new GroupService(client, this.baseURL);
        this.customFieldService = new CustomFieldService(new CustomFieldApiClient(client, this.baseURL));
        this.accountService = new AccountService(new AccountApiClient(client, this.baseURL));
        this.approvalService = new ApprovalService(new ApprovalApiClient(client, this.baseURL));
        this.reminderService = new ReminderService(client, this.baseURL);
        this.templateService = new TemplateService(client, this.baseURL, this.packageService);
        this.attachmentRequirementService = new AttachmentRequirementService(new AttachmentRequirementApiClient(client, this.baseURL), client, this.baseURL);
        this.layoutService = new LayoutService(client, this.baseURL);
        this.qrCodeService = new QRCodeService(client, this.baseURL);
        this.authenticationService = new AuthenticationService(this.webpageURL);
        this.signerVerificationService = new SignerVerificationService(client, this.baseURL);
    }

    String getBaseURL() {
        return this.baseURL;
    }

    private void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    private void setWebpageURL(String baseURL) {
        this.webpageURL = baseURL;
        if (this.webpageURL.endsWith("/api")) {
            this.webpageURL = this.webpageURL.replaceFirst("/api", "");
        }
    }

    public PackageService getPackageService() {
        return this.packageService;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    public FieldSummaryService getFieldSummaryService() {
        return this.fieldSummaryService;
    }

    public AuditService getAuditService() {
        return this.auditService;
    }

    public EventNotificationService getEventNotificationService() {
        return this.eventNotificationService;
    }

    public AuthenticationTokensService getAuthenticationTokensService() {
        return this.authenticationTokensService;
    }

    public CustomFieldService getCustomFieldService() {
        return this.customFieldService;
    }

    public SignatureImageService getSignatureImageService() {
        return this.signatureImageService;
    }

    public PackageId createPackage(DocumentPackage documentPackage) {
        if (!this.isSdkVersionSet(documentPackage)) {
            this.setSdkVersion(documentPackage);
        }
        this.validateSignatures(documentPackage);
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        PackageId id = this.packageService.createPackage(packageToCreate);
        for (Document document : documentPackage.getDocuments()) {
            this.uploadDocument(document, id);
        }
        return id;
    }

    public void updatePackage(PackageId packageId, DocumentPackage documentPackage) {
        if (!this.isSdkVersionSet(documentPackage)) {
            this.setSdkVersion(documentPackage);
        }
        this.validateSignatures(documentPackage);
        this.packageService.updatePackage(packageId, documentPackage);
    }

    public void changePackageStatusToDraft(PackageId packageId) {
        this.packageService.changePackageStatusToDraft(packageId);
    }

    public void configureDocumentVisibility(PackageId packageId, DocumentVisibility visibility) {
        this.packageService.configureDocumentVisibility(packageId, visibility);
    }

    public DocumentVisibility getDocumentVisibility(PackageId packageId) {
        return this.packageService.getDocumentVisibility(packageId);
    }

    public PackageId createPackageOneStep(DocumentPackage documentPackage) {
        if (!this.isSdkVersionSet(documentPackage)) {
            this.setSdkVersion(documentPackage);
        }
        this.validateSignatures(documentPackage);
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        for (Document document : documentPackage.getDocuments()) {
            com.silanis.esl.api.model.Document apiDocument = new DocumentConverter(document).toAPIDocument(packageToCreate);
            packageToCreate.addDocument(apiDocument);
        }
        List<Document> documents = documentPackage.getDocuments();
        PackageId id = this.packageService.createPackageOneStep(packageToCreate, documents);
        return id;
    }

    public void signDocument(PackageId packageId, String documentName) {
        Package aPackage = this.packageService.getApiPackage(packageId.getId());
        for (com.silanis.esl.api.model.Document document : aPackage.getDocuments()) {
            if (!document.getName().equals(documentName)) continue;
            document.getApprovals().clear();
            this.signingService.signDocument(packageId, document);
        }
    }

    public void signDocuments(PackageId packageId) {
        SignedDocuments signedDocuments = new SignedDocuments();
        Package aPackage = this.packageService.getApiPackage(packageId.getId());
        for (com.silanis.esl.api.model.Document document : aPackage.getDocuments()) {
            document.getApprovals().clear();
            signedDocuments.addDocument(document);
        }
        this.signingService.signDocuments(packageId, signedDocuments);
    }

    public void signDocuments(PackageId packageId, String signerId) {
        String bulkSigningKey = "Bulk Signing on behalf of";
        LinkedHashMap<String, String> signerSessionFields = new LinkedHashMap<String, String>();
        signerSessionFields.put(bulkSigningKey, signerId);
        String signerAuthenticationToken = this.authenticationTokensService.createSignerAuthenticationToken(packageId.getId(), signerId, signerSessionFields);
        String signerSessionId = this.authenticationService.getSessionIdForSignerAuthenticationToken(signerAuthenticationToken);
        SignerRestClient signerClient = new SignerRestClient(signerSessionId, true);
        SignedDocuments signedDocuments = new SignedDocuments();
        Package aPackage = this.packageService.getApiPackage(packageId.getId());
        for (com.silanis.esl.api.model.Document document : aPackage.getDocuments()) {
            document.getApprovals().clear();
            signedDocuments.addDocument(document);
        }
        SigningService signingForSignerService = new SigningService(signerClient, this.baseURL);
        signingForSignerService.signDocuments(packageId, signedDocuments);
    }

    private void validateSignatures(DocumentPackage documentPackage) {
        for (Document document : documentPackage.getDocuments()) {
            this.validateMixingSignatureAndAcceptance(document);
        }
    }

    private void validateMixingSignatureAndAcceptance(Document document) {
        if (this.checkAcceptanceSignatureStyle(document)) {
            for (Signature signature : document.getSignatures()) {
                if (signature.getStyle() == SignatureStyle.ACCEPTANCE) continue;
                throw new EslException("It is not allowed to use acceptance signature styles and other signature styles together in one document.");
            }
        }
    }

    private boolean checkAcceptanceSignatureStyle(Document document) {
        for (Signature signature : document.getSignatures()) {
            if (signature.getStyle() != SignatureStyle.ACCEPTANCE) continue;
            return true;
        }
        return false;
    }

    private void setSdkVersion(DocumentPackage documentPackage) {
        DocumentPackageAttributes attributes = documentPackage.getAttributes();
        if (attributes == null) {
            attributes = new DocumentPackageAttributes();
        }
        attributes.append("sdk", "Java v" + VersionUtil.getVersion());
        documentPackage.setAttributes(attributes);
    }

    private boolean isSdkVersionSet(DocumentPackage documentPackage) {
        if (null == documentPackage.getAttributes() || null == documentPackage.getAttributes().getContents()) {
            return false;
        }
        return documentPackage.getAttributes().getContents().containsKey("sdk");
    }

    public PackageId createAndSendPackage(DocumentPackage documentPackage) {
        PackageId result = this.createPackage(documentPackage);
        this.sendPackage(result);
        return result;
    }

    public PackageId createPackageFromTemplate(PackageId packageId, DocumentPackage documentPackage) {
        this.validateSignatures(documentPackage);
        Package packageToCreate = new DocumentPackageConverter(documentPackage).toAPIPackage();
        return this.packageService.createPackageFromTemplate(packageId, packageToCreate);
    }

    @Deprecated
    public PackageId createPackageFromTemplate(DocumentPackage documentPackage, PackageId packageId) {
        return this.createPackageFromTemplate(packageId, documentPackage);
    }

    public void sendPackage(PackageId id) {
        this.packageService.sendPackage(id);
    }

    public List<FieldSummary> getFieldValues(PackageId packageId) {
        return this.getFieldSummaryService().getFieldSummary(packageId);
    }

    @Deprecated
    public SessionToken createSenderSessionToken() {
        return this.sessionService.createSenderSessionToken();
    }

    @Deprecated
    public SessionToken createSignerSessionToken(PackageId packageId, String signerId) throws EslException {
        return this.sessionService.createSessionToken(packageId.getId(), signerId);
    }

    @Deprecated
    public SessionToken createSessionToken(PackageId packageId, String signerId) throws EslException {
        return this.sessionService.createSessionToken(packageId.getId(), signerId);
    }

    public DocumentPackage getPackage(PackageId packageId) {
        return this.packageService.getPackage(packageId);
    }

    public List<Document> getDocuments(PackageId packageId, String signerId) {
        return this.packageService.getDocuments(packageId, signerId);
    }

    public List<Signer> getSigners(PackageId packageId, String documentId) {
        return this.packageService.getSigners(packageId, documentId);
    }

    public byte[] downloadDocument(PackageId packageId, String documentId) {
        return this.packageService.downloadDocument(packageId, documentId);
    }

    public byte[] downloadOriginalDocument(PackageId packageId, String documentId) {
        return this.packageService.downloadOriginalDocument(packageId, documentId);
    }

    public byte[] downloadEvidenceSummary(PackageId packageId) {
        return this.packageService.downloadEvidenceSummary(packageId);
    }

    public byte[] downloadZippedDocuments(PackageId packageId) {
        return this.packageService.downloadZippedDocuments(packageId);
    }

    public SigningStatus getSigningStatus(PackageId packageId, SignerId signerId, DocumentId documentId) {
        return this.packageService.getSigningStatus(packageId, signerId, documentId);
    }

    @Deprecated
    public Document uploadDocument(String fileName, byte[] fileContent, Document document, DocumentPackage documentPackage) {
        return this.uploadDocument(fileName, fileContent, document, documentPackage.getId());
    }

    public Document uploadDocument(String fileName, byte[] fileContent, Document document, PackageId packageId) {
        return this.packageService.uploadDocument(packageId, fileName, fileContent, document);
    }

    @Deprecated
    public Document uploadDocument(Document document, DocumentPackage documentPackage) {
        return this.uploadDocument(document.getFileName(), document.getContent(), document, documentPackage.getId());
    }

    public Document uploadDocument(Document document, PackageId packageId) {
        return this.uploadDocument(document.getFileName(), document.getContent(), document, packageId);
    }

    public void uploadAttachment(PackageId packageId, String attachmentId, String filename, byte[] fileContent, String signerId) {
        String signerSessionFieldKey = "Upload Attachment on behalf of";
        LinkedHashMap<String, String> signerSessionFields = new LinkedHashMap<String, String>();
        signerSessionFields.put(signerSessionFieldKey, signerId);
        String signerAuthenticationToken = this.authenticationTokensService.createSignerAuthenticationToken(packageId.getId(), signerId, signerSessionFields);
        String signerSessionId = this.authenticationService.getSessionIdForSignerAuthenticationToken(signerAuthenticationToken);
        this.attachmentRequirementService.uploadAttachment(packageId, attachmentId, filename, fileContent, signerSessionId);
    }

    public void createSignerVerification(PackageId packageId, String roleId, SignerVerification signerVerification) {
        Verification verification = new SignerVerificationConverter().toAPISignerVerification(signerVerification);
        this.signerVerificationService.createSignerVerification(packageId.getId(), roleId, verification);
    }

    public SignerVerification getSignerVerification(PackageId packageId, String roleId) {
        Verification verification = this.signerVerificationService.getSignerVerification(packageId.getId(), roleId);
        SignerVerification signerVerification = new SignerVerificationConverter().toSDKSignerVerification(verification);
        return signerVerification;
    }

    public void updateSignerVerification(PackageId packageId, String roleId, SignerVerification signerVerification) {
        Verification verification = new SignerVerificationConverter().toAPISignerVerification(signerVerification);
        this.signerVerificationService.updateSignerVerification(packageId.getId(), roleId, verification);
    }

    public void deleteSignerVerification(PackageId packageId, String roleId) {
        this.signerVerificationService.deleteSignerVerification(packageId.getId(), roleId);
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public ApprovalService getApprovalService() {
        return this.approvalService;
    }

    public ReminderService getReminderService() {
        return this.reminderService;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public AttachmentRequirementService getAttachmentRequirementService() {
        return this.attachmentRequirementService;
    }

    public LayoutService getLayoutService() {
        return this.layoutService;
    }

    public QRCodeService getQrCodeService() {
        return this.qrCodeService;
    }

    public SystemService getSystemService() {
        return this.systemService;
    }

    public SigningService getSigningService() {
        return this.signingService;
    }
}

