/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.sdk;

import com.silanis.esl.sdk.Document;
import com.silanis.esl.sdk.DocumentPackageAttributes;
import com.silanis.esl.sdk.DocumentPackageSettings;
import com.silanis.esl.sdk.EslException;
import com.silanis.esl.sdk.Message;
import com.silanis.esl.sdk.PackageId;
import com.silanis.esl.sdk.PackageStatus;
import com.silanis.esl.sdk.SenderInfo;
import com.silanis.esl.sdk.Signer;
import com.silanis.esl.sdk.Visibility;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class DocumentPackage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Signer> signers;
    private final List<Signer> placeholders;
    private final List<Document> documents;
    private final boolean autocomplete;
    private String name;
    private String description;
    private Date expiryDate;
    private Date updatedDate;
    private Date createdDate;
    private String packageMessage;
    private Boolean notarized;
    private Boolean trashed;
    private PackageId id;
    private PackageStatus status;
    private DocumentPackageSettings settings;
    private Locale language;
    private DocumentPackageAttributes attributes;
    private SenderInfo senderInfo;
    private List<Message> messages;
    private Visibility visibility;

    public DocumentPackage(String name, List<Signer> signers, List<Signer> placeholders, List<Document> documents, boolean autocomplete) {
        this.name = name;
        this.signers = signers;
        this.placeholders = placeholders;
        this.documents = documents;
        this.autocomplete = autocomplete;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Signer getSigner(String email) {
        for (Signer signer : this.signers) {
            if (!signer.getEmail().equalsIgnoreCase(email)) continue;
            return signer;
        }
        return null;
    }

    public void addSigner(Signer signer) {
        if (this.isExistingSigner(signer)) {
            throw new EslException("Another signer with same email or another placeholder with same id already exists.");
        }
        this.signers.add(signer);
    }

    private boolean isExistingSigner(Signer signer) {
        for (Signer signerToCheck : this.signers) {
            if (!signerToCheck.getEmail().equalsIgnoreCase(signer.getEmail())) continue;
            return true;
        }
        for (Signer signerToCheck : this.placeholders) {
            if (!signerToCheck.getId().equalsIgnoreCase(signer.getId())) continue;
            return true;
        }
        return false;
    }

    public void removeSigner(Signer signer) {
        for (Signer retrievedSigner : this.signers) {
            if (!retrievedSigner.getEmail().equalsIgnoreCase(signer.getEmail())) continue;
            this.signers.remove(retrievedSigner);
            return;
        }
        throw new EslException("Signer does not exist.");
    }

    public List<Signer> getSigners() {
        return this.signers;
    }

    public void removePlaceholder(Signer signer) {
        for (Signer placeholder : this.placeholders) {
            if (!placeholder.getId().equalsIgnoreCase(signer.getId())) continue;
            this.placeholders.remove(placeholder);
            return;
        }
        throw new EslException("Placeholder does not exist.");
    }

    public List<Signer> getPlaceholders() {
        return this.placeholders;
    }

    public Signer getPlaceholder(String id) {
        for (Signer signer : this.placeholders) {
            if (!signer.getId().equals(id)) continue;
            return signer;
        }
        return null;
    }

    public Document getDocument(String name) {
        for (Document document : this.documents) {
            if (!document.getName().equals(name)) continue;
            return document;
        }
        return null;
    }

    public boolean getAutocomplete() {
        return this.autocomplete;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public void setPackageMessage(String packageMessage) {
        this.packageMessage = packageMessage;
    }

    public String getPackageMessage() {
        return this.packageMessage;
    }

    public void setId(PackageId id) {
        this.id = id;
    }

    public PackageId getId() {
        return this.id;
    }

    public void setStatus(PackageStatus status) {
        this.status = status;
    }

    public PackageStatus getStatus() {
        return this.status;
    }

    public DocumentPackageSettings getSettings() {
        return this.settings;
    }

    public void setSettings(DocumentPackageSettings settings) {
        this.settings = settings;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setSenderInfo(SenderInfo senderInfo) {
        this.senderInfo = senderInfo;
    }

    public SenderInfo getSenderInfo() {
        return this.senderInfo;
    }

    public DocumentPackageAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(DocumentPackageAttributes attributes) {
        this.attributes = attributes;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public Boolean getNotarized() {
        return this.notarized;
    }

    public void setNotarized(Boolean notarized) {
        this.notarized = notarized;
    }

    public Boolean getTrashed() {
        return this.trashed;
    }

    public void setTrashed(Boolean trashed) {
        this.trashed = trashed;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }
}

