/*
 * Decompiled with CFR 0.152.
 */
package com.silanis.esl.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Sets;
import com.silanis.esl.api.model.Approval;
import com.silanis.esl.api.model.Entity;
import com.silanis.esl.api.model.External;
import com.silanis.esl.api.model.Field;
import com.silanis.esl.api.model.Page;
import com.silanis.esl.api.util.SchemaSanitizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Document
extends Entity
implements Serializable {
    @JsonIgnore
    public static final String FIELD_APPROVALS = "approvals";
    @JsonIgnore
    public static final String FIELD_DATA = "data";
    @JsonIgnore
    public static final String FIELD_DESCRIPTION = "description";
    @JsonIgnore
    public static final String FIELD_EXTERNAL = "external";
    @JsonIgnore
    public static final String FIELD_EXTRACT = "extract";
    @JsonIgnore
    public static final String FIELD_EXTRACTION_TYPES = "extractionTypes";
    @JsonIgnore
    public static final String FIELD_FIELDS = "fields";
    @JsonIgnore
    public static final String FIELD_ID = "id";
    @JsonIgnore
    public static final String FIELD_INDEX = "index";
    @JsonIgnore
    public static final String FIELD_NAME = "name";
    @JsonIgnore
    public static final String FIELD_PAGES = "pages";
    @JsonIgnore
    public static final String FIELD_SIZE = "size";
    protected List<Approval> _approvals = new ArrayList<Approval>();
    protected String _description = "";
    protected External _external = null;
    protected Boolean _extract = false;
    protected Set<String> _extractionTypes = Sets.newHashSet();
    protected List<Field> _fields = new ArrayList<Field>();
    protected Integer _index = 0;
    protected List<Page> _pages = new ArrayList<Page>();
    protected Integer _size = 0;

    public Document setApprovals(List<Approval> value) {
        SchemaSanitizer.throwOnNull(FIELD_APPROVALS, value);
        this._approvals = value;
        this.setDirty(FIELD_APPROVALS);
        return this;
    }

    @JsonIgnore
    public Document safeSetApprovals(List<Approval> value) {
        if (value != null) {
            this.setApprovals(value);
        }
        return this;
    }

    public List<Approval> getApprovals() {
        return this._approvals;
    }

    public Document addApproval(Approval value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this._approvals.add(value);
        this.setDirty(FIELD_APPROVALS);
        return this;
    }

    @Override
    public Document setData(Map<String, Object> value) {
        super.setData(value);
        return this;
    }

    @Override
    @JsonIgnore
    public Document safeSetData(Map<String, Object> value) {
        if (value != null) {
            this.setData((Map)value);
        }
        return this;
    }

    public Document setDescription(String value) {
        SchemaSanitizer.throwOnNull(FIELD_DESCRIPTION, value);
        value = SchemaSanitizer.sanitize(value);
        this._description = value = SchemaSanitizer.trim(value);
        this.setDirty(FIELD_DESCRIPTION);
        return this;
    }

    @JsonIgnore
    public Document safeSetDescription(String value) {
        if (value != null) {
            this.setDescription(value);
        }
        return this;
    }

    public String getDescription() {
        return this._description;
    }

    public Document setExternal(External value) {
        this._external = value;
        this.setDirty(FIELD_EXTERNAL);
        return this;
    }

    @JsonIgnore
    public Document safeSetExternal(External value) {
        if (value != null) {
            this.setExternal(value);
        }
        return this;
    }

    public External getExternal() {
        return this._external;
    }

    public Document setExtract(Boolean value) {
        SchemaSanitizer.throwOnNull(FIELD_EXTRACT, value);
        this._extract = value;
        this.setDirty(FIELD_EXTRACT);
        return this;
    }

    @JsonIgnore
    public Document safeSetExtract(Boolean value) {
        if (value != null) {
            this.setExtract(value);
        }
        return this;
    }

    public Boolean getExtract() {
        return this._extract;
    }

    @JsonIgnore
    public boolean evalExtract() {
        return this._extract == null ? false : this._extract;
    }

    public Document setExtractionTypes(Set<String> value) {
        SchemaSanitizer.throwOnNull(FIELD_EXTRACTION_TYPES, value);
        this._extractionTypes = value;
        this.setDirty(FIELD_EXTRACTION_TYPES);
        return this;
    }

    @JsonIgnore
    public Document safeSetExtractionTypes(Set<String> value) {
        if (value != null) {
            this.setExtractionTypes(value);
        }
        return this;
    }

    public Set<String> getExtractionTypes() {
        return this._extractionTypes;
    }

    public Document setFields(List<Field> value) {
        SchemaSanitizer.throwOnNull(FIELD_FIELDS, value);
        this._fields = value;
        this.setDirty(FIELD_FIELDS);
        return this;
    }

    @JsonIgnore
    public Document safeSetFields(List<Field> value) {
        if (value != null) {
            this.setFields(value);
        }
        return this;
    }

    public List<Field> getFields() {
        return this._fields;
    }

    public Document addField(Field value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this._fields.add(value);
        this.setDirty(FIELD_FIELDS);
        return this;
    }

    @Override
    public Document setId(String value) {
        super.setId(value);
        return this;
    }

    @Override
    @JsonIgnore
    public Document safeSetId(String value) {
        if (value != null) {
            this.setId(value);
        }
        return this;
    }

    public Document setIndex(Integer value) {
        SchemaSanitizer.throwOnNull(FIELD_INDEX, value);
        this._index = value;
        this.setDirty(FIELD_INDEX);
        return this;
    }

    @JsonIgnore
    public Document safeSetIndex(Integer value) {
        if (value != null) {
            this.setIndex(value);
        }
        return this;
    }

    public Integer getIndex() {
        return this._index;
    }

    @Override
    public Document setName(String value) {
        super.setName(value);
        return this;
    }

    @Override
    @JsonIgnore
    public Document safeSetName(String value) {
        if (value != null) {
            this.setName(value);
        }
        return this;
    }

    public Document setPages(List<Page> value) {
        SchemaSanitizer.throwOnNull(FIELD_PAGES, value);
        this._pages = value;
        this.setDirty(FIELD_PAGES);
        return this;
    }

    @JsonIgnore
    public Document safeSetPages(List<Page> value) {
        if (value != null) {
            this.setPages(value);
        }
        return this;
    }

    public List<Page> getPages() {
        return this._pages;
    }

    public Document addPage(Page value) {
        if (value == null) {
            throw new IllegalArgumentException("Argument cannot be null");
        }
        this._pages.add(value);
        this.setDirty(FIELD_PAGES);
        return this;
    }

    public Document setSize(Integer value) {
        SchemaSanitizer.throwOnNull(FIELD_SIZE, value);
        this._size = value;
        this.setDirty(FIELD_SIZE);
        return this;
    }

    @JsonIgnore
    public Document safeSetSize(Integer value) {
        if (value != null) {
            this.setSize(value);
        }
        return this;
    }

    public Integer getSize() {
        return this._size;
    }
}

