/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.opencv.core.Core;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.HotkeyEvent;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.basics.Settings;
import org.sikuli.natives.WinUtil;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Mouse;
import org.sikuli.script.OCR;
import org.sikuli.script.Options;
import org.sikuli.script.Screen;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.Sikulix;
import org.sikuli.script.runnerSupport.JythonSupport;
import org.sikuli.script.runners.ProcessRunner;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.ExtensionManager;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.Observing;
import org.sikuli.script.support.RobotDesktop;
import org.sikuli.script.support.Runner;
import org.sikuli.script.support.SikulixAPI;
import org.sikuli.script.support.SikulixEvaluate;
import org.sikuli.util.CommandArgs;
import org.sikuli.util.CommandArgsEnum;
import org.sikuli.util.Highlight;
import org.sikuli.vnc.VNCScreen;

public class RunTime {
    private static RunTime runTime;
    private static final String osNameShort;
    private static boolean startAsIDE;
    private static boolean allowMultiple;
    private static boolean asServer;
    private static String[] serverOptions;
    private static String serverGroups;
    private static String serverExtra;
    private static boolean asPythonServer;
    private static String[] userArgs;
    private static String[] sxArgs;
    private static long elapsedStart;
    private static String logFile;
    private static String userLogFile;
    private static String[] loadScripts;
    private static boolean shouldRunScript;
    private static String[] runScripts;
    private int lvl;
    private int minLvl;
    private static String preLogMessages;
    private static boolean verbose;
    private static boolean quiet;
    public RunType runningAs;
    private static Options sxOptions;
    private static boolean isTerminating;
    private static boolean hasDoneCleanUpTerminating;
    public static String appDataMsg;
    public static boolean testing;
    public static boolean testingWinApp;
    public Type runType;
    public String jreVersion;
    private Class clsRef;
    private List<URL> classPathActual;
    private List<String> classPathList;
    public static File fTempPath;
    public File fBaseTempPath;
    public String fpBaseTempPath;
    public File fLibsFolder;
    public String fpJarLibs;
    public String fpSysLibs;
    boolean areLibsExported;
    private Map<String, Boolean> libsLoaded;
    private int lastScriptRunReturnCode;
    public File fAppPath;
    public File fSikulixAppPath;
    public File fSikulixExtensions;
    public String[] standardExtensions;
    public File fSikulixLib;
    public File fSikulixStore;
    public File fSikulixDownloadsGeneric;
    public File fSikulixDownloadsBuild;
    public File fSikulixSetup;
    public File fSxBase;
    public File fSxBaseJar;
    public File fSxProject;
    public File fSxProjectTestScriptsJS;
    public File fSxProjectTestScripts;
    public String fpContent;
    public boolean runningJar;
    public boolean runningInProject;
    public boolean runningWindows;
    public boolean runningMac;
    public boolean runningLinux;
    private final String osNameSysProp;
    private final String osVersionSysProp;
    public String javaShow;
    public int javaArch;
    public String osArch;
    public int javaVersion;
    public File javahome;
    public String osName;
    public String sysName;
    public String osVersion;
    private String appType;
    public String linuxDistro;
    public String SXVersion;
    public String SXVersionLong;
    public String SXVersionShort;
    public String SXSystemVersion;
    public String SXJavaVersion;
    public String[] ServerList;
    public static final String libOpenCV;
    public static final String runCmdError = "*****error*****";
    public static String NL;
    public File fLibsProvided;
    public File fLibsLocal;
    public boolean useLibsProvided;
    private String lastResult;
    public boolean isJythonReady;
    static final long started;
    static final long obsolete;
    static boolean optTesting;
    File isRunning;
    FileOutputStream isRunningFile;
    String isRunningFilename;
    private boolean didExport;
    public static boolean isRunningIDE;
    Class<?> cIDE;
    Method mHide;
    Method mShow;
    private static RobotDesktop cleanupRobot;
    private static boolean isLibExported;
    List<String> sxClasspath;

    public static boolean isIDE() {
        return startAsIDE;
    }

    public static boolean shouldRunServer() {
        return asServer;
    }

    public static String[] getServerOptions() {
        return serverOptions;
    }

    public static String getServerGroups() {
        return serverGroups;
    }

    public static String getServerExtra() {
        return serverExtra;
    }

    public static void startAPI(String appPath) {
        File path = Commons.setAppDataPath(appPath);
        fTempPath = new File(path, "Temp");
        RunTime.startAPI();
    }

    public static boolean shouldRunPythonServer() {
        return asPythonServer;
    }

    public static void startAPI() {
        RunTime.get(Type.API);
    }

    public static void start(Type type, String[] args) {
        if (Type.API.equals((Object)type)) {
            startAsIDE = false;
            if (args.length == 1 && "buildDate".equals(args[0])) {
                System.out.println(Commons.getSxBuildStamp());
                System.exit(0);
            }
            if (args.length == 1 && "test".equals(args[0])) {
                SikulixEvaluate.test();
                System.exit(0);
            }
        }
        List<String> finalArgs = RunTime.evalArgsStart(args);
        if (RunTime.shouldRunPythonServer()) {
            SikulixAPI.runPy4jServer();
        }
        File runningJar = RunTime.getRunningJar(type);
        RunTime.startLog(1, "Running: %s", runningJar);
        File fAppData = Commons.getAppDataPath();
        RunTime.startLog(1, "AppData: %s", fAppData);
        String classPath = ExtensionManager.makeClassPath(runningJar);
        if (!runningJar.getName().endsWith(".jar")) {
            return;
        }
        FileManager.writeStringToFile(runningJar.getAbsolutePath(), new File(Commons.getAppDataPath(), "SikulixStore/lastUsedJar.txt"));
        ArrayList<String> cmd = new ArrayList<String>();
        System.getProperty("java.home");
        if (RunTime.get().runningWindows) {
            cmd.add(System.getProperty("java.home") + "\\bin\\java.exe");
        } else {
            cmd.add(System.getProperty("java.home") + "/bin/java");
        }
        if (RunTime.get().isJava9(new String[0])) {
            cmd.add("--add-opens");
            cmd.add("java.desktop/javax.swing.plaf.basic=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/sun.nio.ch=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.io=ALL-UNNAMED");
        }
        cmd.add("-Dfile.encoding=UTF-8");
        if (startAsIDE) {
            cmd.add("-Dsikuli.IDE_should_run");
        } else {
            cmd.add("-Dsikuli.API_should_run");
        }
        if (!classPath.isEmpty()) {
            cmd.add("-cp");
            cmd.add(classPath);
        }
        if (startAsIDE) {
            cmd.add("org.sikuli.ide.SikulixIDE");
        } else {
            cmd.add("org.sikuli.script.support.SikulixAPI");
        }
        cmd.addAll(finalArgs);
        RunTime.startLog(3, "*********************** leaving start", new Object[0]);
        int exitCode = ProcessRunner.runBlocking(cmd);
        System.exit(exitCode);
    }

    private static File getRunningJar(Type type) {
        File jarFile = null;
        String jarName = "notKnown";
        CodeSource codeSrc = RunTime.class.getProtectionDomain().getCodeSource();
        if (Type.IDE.equals((Object)type)) {
            try {
                Class<?> cIDE = Class.forName("org.sikuli.ide.SikulixIDE");
                codeSrc = cIDE.getProtectionDomain().getCodeSource();
            }
            catch (ClassNotFoundException e) {
                RunTime.startLog(-1, "IDE startup: not possible for: %s", e.getMessage());
                System.exit(1);
            }
        }
        if (codeSrc != null && codeSrc.getLocation() != null) {
            try {
                jarName = codeSrc.getLocation().getPath();
                jarName = URLDecoder.decode(jarName, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                RunTime.startLog(-1, "URLDecoder: not possible: %s", jarName);
                System.exit(1);
            }
            jarFile = new File(jarName);
        }
        return jarFile;
    }

    public static void afterStart(Type type, String[] args) {
        String startType = "IDE";
        if (Type.IDE.equals((Object)type)) {
            if (null == System.getProperty("sikuli.IDE_should_run")) {
                System.out.println("[ERROR] org.sikuli.ide.SikulixIDE: unauthorized use. Use: org.sikuli.ide.Sikulix");
                System.exit(1);
            }
        } else {
            if (null == System.getProperty("sikuli.API_should_run")) {
                System.out.println("[ERROR] org.sikuli.script.SikulixAPI: unauthorized use. Use: org.sikuli.script.Sikulix");
                System.exit(1);
            }
            startType = "API";
        }
        RunTime.evalArgsStart(args);
        Debug.log(3, "Sikulix: starting " + startType, new Object[0]);
        RunTime.evalArgs(args);
        ExtensionManager.readExtensions(true);
        if (RunTime.isQuiet()) {
            Debug.quietOn();
        } else if (RunTime.isVerbose()) {
            Debug.setWithTimeElapsed(RunTime.getElapsedStart());
            Debug.setGlobalDebug(3);
            Debug.globalTraceOn();
            Debug.setStartWithTrace();
        }
        if (!RunTime.getLogFile().isEmpty()) {
            Debug.setLogFile(RunTime.getLogFile());
        }
        if (!RunTime.getUserLogFile().isEmpty()) {
            Debug.setUserLogFile(RunTime.getUserLogFile());
        }
        if (RunTime.runningScripts()) {
            HotkeyManager.getInstance().addHotkey("Abort", new HotkeyListener(){

                @Override
                public void hotkeyPressed(HotkeyEvent e) {
                    RunTime.get();
                    if (RunTime.runningScripts()) {
                        Runner.abortAll();
                        RunTime.terminate(254, "AbortKey was pressed: aborting all running scripts", new Object[0]);
                    }
                }
            });
            int exitCode = Runner.runScripts(RunTime.getRunScripts(), userArgs, new IScriptRunner.Options());
            if (exitCode > 255) {
                exitCode = 254;
            }
            RunTime.terminate(exitCode, "", new Object[0]);
        }
        if (RunTime.shouldRunServer()) {
            Class<?> cServer = null;
            try {
                cServer = Class.forName("org.sikuli.script.runners.ServerRunner");
                cServer.getMethod("run", new Class[0]).invoke(null, new Object[0]);
                RunTime.terminate();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                cServer = Class.forName("org.sikuli.script.support.SikulixServer");
                if (!((Boolean)cServer.getMethod("run", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    RunTime.terminate(1, "SikulixServer: terminated with errors", new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            RunTime.terminate();
        }
    }

    public static File asFolder(String option) {
        if (null == option) {
            return null;
        }
        File folder = new File(option);
        if (!folder.isAbsolute()) {
            folder = new File(Commons.getWorkDir(), option);
        }
        if (folder.isDirectory() && folder.exists()) {
            return folder;
        }
        return null;
    }

    public static File asFile(String option) {
        if (null == option) {
            return null;
        }
        if (null == RunTime.asFolder(option)) {
            File file = new File(option);
            if (!file.isAbsolute()) {
                file = new File(Commons.getWorkDir(), option);
            }
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static void evalArgs(String[] args) {
        String cmdValue;
        CommandArgs cmdArgs = new CommandArgs();
        CommandLine cmdLine = cmdArgs.getCommandLine(args);
        boolean cmdLineValid = true;
        if (cmdLine == null) {
            RunTime.startLog(-1, "Did not find any valid option on command line!", new Object[0]);
            cmdLineValid = false;
        } else {
            RunTime.setArgs(cmdArgs.getUserArgs(), cmdArgs.getSXArgs());
        }
        if (cmdLineValid && cmdLine.hasOption("h")) {
            cmdArgs.printHelp();
            System.exit(0);
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.DEBUG.shortname()) && (cmdValue = cmdLine.getOptionValue(CommandArgsEnum.DEBUG.longname())) != null) {
            Debug.setDebugLevel(cmdValue);
        }
        if (cmdLineValid && cmdLine.hasOption("g")) {
            if (cmdLine.hasOption("s")) {
                serverGroups = cmdLine.getOptionValue("g");
                RunTime.startLog(3, "groups (-g): %s", serverGroups);
            } else {
                RunTime.startLog(-1, "groups (-g): currently only accepted with -s", new Object[0]);
            }
        }
        if (cmdLineValid && cmdLine.hasOption("x")) {
            if (cmdLine.hasOption("s")) {
                serverExtra = cmdLine.getOptionValue("x");
                RunTime.startLog(3, "extra (-x): %s", serverExtra);
            } else {
                RunTime.startLog(-1, "extra (-x): currently only accepted with -s", new Object[0]);
            }
        }
        if (cmdLineValid && cmdLine.hasOption("s")) {
            serverOptions = cmdLine.getOptionValues("s");
        }
        if (cmdLineValid && cmdLine.hasOption("m")) {
            RunTime.setAllowMultiple();
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.LOGFILE.shortname())) {
            logFile = cmdLine.getOptionValue(CommandArgsEnum.LOGFILE.longname());
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.USERLOGFILE.shortname())) {
            userLogFile = cmdLine.getOptionValue(CommandArgsEnum.USERLOGFILE.longname());
        }
        if (cmdLineValid && cmdLine.hasOption("c")) {
            System.setProperty("sikuli.console", "false");
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.LOAD.shortname())) {
            loadScripts = cmdLine.getOptionValues(CommandArgsEnum.LOAD.longname());
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.RUN.shortname())) {
            String[] scripts = cmdLine.getOptionValues(CommandArgsEnum.RUN.longname());
            runScripts = RunTime.resolveRelativeFiles(scripts);
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.PYTHONSERVER.shortname())) {
            asPythonServer = true;
        }
    }

    public static void setAllowMultiple() {
        allowMultiple = true;
    }

    public static boolean isAllowMultiple() {
        return allowMultiple;
    }

    public static String[] resolveRelativeFiles(String[] givenScripts) {
        String[] runScripts = new String[givenScripts.length];
        String baseDir = Commons.getWorkDir().getPath();
        for (int i = 0; i < runScripts.length; ++i) {
            String givenScript = givenScripts[i];
            String file = RunTime.resolveRelativeFile(givenScript, baseDir);
            if (file == null) {
                file = RunTime.resolveRelativeFile(givenScript + ".sikuli", baseDir);
            }
            if (file == null) {
                file = RunTime.resolveRelativeFile(givenScript + ".py", baseDir);
            }
            if (file == null) {
                file = RunTime.resolveRelativeFile(givenScript + ".rb", baseDir);
            }
            if (file == null) {
                runScripts[i] = "?" + givenScript;
                continue;
            }
            try {
                file = new File(file).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            IScriptRunner.EffectiveRunner runnerAndFile = Runner.getEffectiveRunner(file);
            IScriptRunner runner = runnerAndFile.getRunner();
            String fileToRun = runnerAndFile.getScript();
            File possibleDir = null;
            if (null == fileToRun) {
                for (String ending : new String[]{"", ".sikuli"}) {
                    possibleDir = new File(file + ending);
                    if (possibleDir.exists()) break;
                    possibleDir = null;
                }
                if (null == possibleDir) {
                    runScripts[i] = "?" + givenScript;
                    continue;
                }
                baseDir = possibleDir.getAbsolutePath();
                runnerAndFile = Runner.getEffectiveRunner(baseDir);
                fileToRun = runnerAndFile.getScript();
                fileToRun = fileToRun == null ? "!" + baseDir : baseDir;
            }
            runScripts[i] = fileToRun;
            if (i != 0 || fileToRun.startsWith("!")) continue;
            baseDir = new File(fileToRun).getParent();
        }
        return runScripts;
    }

    public static String resolveRelativeFile(String scriptName, String baseDir) {
        if (RunTime.get().runningWindows && (scriptName.startsWith("\\") || scriptName.startsWith("/"))) {
            scriptName = new File(scriptName).getAbsolutePath();
            return scriptName;
        }
        File file = new File(scriptName);
        if (!file.isAbsolute()) {
            File inBaseDir = new File(baseDir, scriptName);
            if (inBaseDir.exists()) {
                file = inBaseDir;
            } else {
                File inWorkDir = new File(Commons.getWorkDir(), scriptName);
                if (inWorkDir.exists()) {
                    file = inWorkDir;
                } else {
                    File inUserHome = new File(Commons.getUserHome(), scriptName);
                    if (inUserHome.exists()) {
                        file = inUserHome;
                    } else {
                        return null;
                    }
                }
            }
        }
        return file.getAbsolutePath();
    }

    private static List<String> evalArgsStart(String[] args) {
        ArrayList<String> finalArgs = new ArrayList<String>();
        for (String arg : args) {
            if ("-v".equals(arg)) {
                RunTime.setVerbose();
            } else if ("-q".equals(arg)) {
                RunTime.setQuiet();
            } else if ("-r".equals(arg)) {
                shouldRunScript = true;
            } else if ("-s".equals(arg)) {
                asServer = true;
            } else if ("-p".equals(arg)) {
                asPythonServer = true;
            }
            finalArgs.add(arg);
        }
        return finalArgs;
    }

    private static void setArgs(String[] args, String[] sargs) {
        userArgs = args;
        sxArgs = sargs;
    }

    public static String[] getSXArgs() {
        return sxArgs;
    }

    public static void setUserArgs(String[] args) {
        userArgs = new String[args.length];
        int n = 0;
        String[] stringArray = args;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String arg;
            RunTime.userArgs[n] = arg = stringArray[i];
            ++n;
        }
    }

    public static String[] getUserArgs() {
        return userArgs;
    }

    public static void printArgs() {
        int i;
        String[] xargs = RunTime.getSXArgs();
        if (xargs.length > 0) {
            RunTime.startLog(1, "--- Sikuli parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                RunTime.startLog(1, "%d: %s", i + 1, xargs[i]);
            }
        }
        if ((xargs = RunTime.getUserArgs()).length > 0) {
            RunTime.startLog(1, "--- User parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                RunTime.startLog(1, "%d: %s", i + 1, xargs[i]);
            }
        }
    }

    public static long getElapsedStart() {
        return elapsedStart;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static String getUserLogFile() {
        return userLogFile;
    }

    public static String[] getLoadScripts() {
        return loadScripts;
    }

    public static String[] getRunScripts() {
        return runScripts;
    }

    public static boolean runningScripts() {
        return shouldRunScript;
    }

    public static boolean isVerbose() {
        return verbose || Debug.getDebugLevel() > 2;
    }

    public static void setVerbose() {
        verbose = true;
        Debug.setDebugLevel(3);
        Debug.setWithTimeElapsed(RunTime.getElapsedStart());
        Debug.setGlobalDebug(3);
        Debug.globalTraceOn();
        Debug.setStartWithTrace();
    }

    public static boolean isQuiet() {
        return quiet;
    }

    public static void setQuiet() {
        quiet = true;
    }

    public static void startLog(int level, String msg, Object ... args) {
        String typ = startAsIDE ? "IDE" : "API";
        String msgShow = String.format("startUp: %s: ", typ);
        if (!RunTime.isVerbose()) {
            return;
        }
        if (level < 0) {
            msgShow = "[ERROR]" + msgShow + msg;
            System.out.println(String.format(msgShow, args));
            return;
        }
        if (RunTime.isQuiet()) {
            return;
        }
        if (RunTime.isVerbose()) {
            msgShow = level > 0 ? "[DEBUG]" + msgShow + msg : "[INFO]" + msgShow + msg;
            System.out.println(String.format(msgShow, args));
        }
    }

    public static String arrayToQuotedString(String[] args) {
        String ret = "";
        for (String s : args) {
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            ret = ret + s + " ";
        }
        return ret;
    }

    private void log(int level, String message, Object ... args) {
        Debug.logx(level, "RunTime:" + message, args);
    }

    private void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    private void logp(int level, String message, Object ... args) {
        if (level <= Debug.getDebugLevel()) {
            this.logp(message, args);
        }
    }

    public boolean runningIDE() {
        return Type.IDE.equals((Object)this.runType);
    }

    public int getLastScriptRunReturnCode() {
        return this.lastScriptRunReturnCode;
    }

    public void setLastScriptRunReturnCode(int lastScriptRunReturnCode) {
        this.lastScriptRunReturnCode = lastScriptRunReturnCode;
    }

    private RunTime() {
        this.minLvl = this.lvl = 3;
        this.runningAs = RunType.OTHER;
        this.runType = Type.INIT;
        this.jreVersion = System.getProperty("java.runtime.version");
        this.clsRef = RunTime.class;
        this.classPathActual = new ArrayList<URL>();
        this.classPathList = new ArrayList<String>();
        this.fBaseTempPath = null;
        this.fpBaseTempPath = "";
        this.fLibsFolder = null;
        this.fpJarLibs = "/sikulixlibs/";
        this.fpSysLibs = null;
        this.areLibsExported = false;
        this.libsLoaded = new HashMap<String, Boolean>();
        this.lastScriptRunReturnCode = 0;
        this.fAppPath = null;
        this.fSikulixAppPath = null;
        this.fSikulixExtensions = null;
        this.standardExtensions = new String[]{"selenium4sikulix"};
        this.fSikulixLib = null;
        this.fSikulixDownloadsGeneric = null;
        this.fSikulixDownloadsBuild = null;
        this.fSxBase = null;
        this.fSxBaseJar = null;
        this.fSxProject = null;
        this.fSxProjectTestScriptsJS = null;
        this.fSxProjectTestScripts = null;
        this.fpContent = "sikulixcontent";
        this.runningJar = true;
        this.runningInProject = false;
        this.runningWindows = false;
        this.runningMac = false;
        this.runningLinux = false;
        this.osNameSysProp = System.getProperty("os.name");
        this.osVersionSysProp = System.getProperty("os.version");
        this.javaShow = "not-set";
        this.javaArch = 64;
        this.osArch = "64";
        this.javaVersion = 0;
        this.javahome = new File(System.getProperty("java.home"));
        this.osName = "NotKnown";
        this.sysName = "NotKnown";
        this.osVersion = "";
        this.appType = null;
        this.linuxDistro = "???LINUX???";
        this.SXVersion = "";
        this.ServerList = new String[0];
        this.useLibsProvided = false;
        this.lastResult = "";
        this.isJythonReady = false;
        this.isRunning = null;
        this.isRunningFile = null;
        this.isRunningFilename = "s_i_k_u_l_i-ide-isrunning";
        this.didExport = false;
        this.cIDE = null;
        this.mHide = null;
        this.mShow = null;
        this.sxClasspath = new ArrayList<String>();
    }

    public static synchronized RunTime get() {
        if (runTime == null) {
            return RunTime.get(Type.API);
        }
        return runTime;
    }

    static boolean isObsolete(long refTime) {
        if (refTime == 0L) {
            return false;
        }
        return refTime < obsolete;
    }

    public boolean isTesting() {
        return optTesting;
    }

    public static synchronized RunTime get(Type typ) {
        int optDebugLevel;
        if (runTime != null) {
            return runTime;
        }
        runTime = new RunTime();
        RunTime.runTime.osVersion = RunTime.runTime.osVersionSysProp;
        String os = RunTime.runTime.osNameSysProp.toLowerCase();
        if (os.startsWith("windows")) {
            RunTime.runTime.sysName = "windows";
            RunTime.runTime.osName = "Windows";
            RunTime.runTime.runningWindows = true;
            NL = "\r\n";
        } else if (os.startsWith("mac")) {
            RunTime.runTime.sysName = "mac";
            RunTime.runTime.osName = "Mac OSX";
            RunTime.runTime.runningMac = true;
        } else if (os.startsWith("linux")) {
            RunTime.runTime.sysName = "linux";
            RunTime.runTime.osName = "Linux";
            RunTime.runTime.runningLinux = true;
        } else {
            RunTime.runTime.sysName = os;
            RunTime.runTime.osName = RunTime.runTime.osNameSysProp;
            RunTime.runTime.runningLinux = true;
            RunTime.runTime.linuxDistro = RunTime.runTime.osNameSysProp;
        }
        RunTime.runTime.fpJarLibs = RunTime.runTime.fpJarLibs + RunTime.runTime.sysName + "/libs" + RunTime.runTime.javaArch;
        RunTime.runTime.fpSysLibs = RunTime.runTime.fpJarLibs.substring(1);
        RunTime.runTime.fSikulixAppPath = Commons.getAppDataPath();
        RunTime.runTime.fSikulixStore = Commons.getAppDataStore();
        sxOptions = Options.init(runTime);
        optTesting = sxOptions.isOption("testing", false);
        if (optTesting) {
            Debug.info("Options: testing = on", new Object[0]);
        }
        int n = optDebugLevel = optTesting ? Debug.getDebugLevel() : sxOptions.getOptionInteger("Debug.level", -1);
        if (optDebugLevel > Debug.getDebugLevel()) {
            Debug.info("Options: Debug.level = %d", optDebugLevel);
            Debug.on(optDebugLevel);
        }
        Settings.init(runTime);
        hasDoneCleanUpTerminating = false;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RunTime.runShutdownHook();
            }
        });
        runTime.init(typ);
        if (Type.IDE.equals((Object)typ)) {
            runTime.initIDEbefore();
            runTime.initAPI();
            runTime.initIDEafter();
        } else {
            runTime.initAPI();
        }
        return runTime;
    }

    public Rectangle getMonitor(int n) {
        if (Screen.isHeadless()) {
            return new Rectangle();
        }
        return Screen.getMonitor(n);
    }

    public Rectangle hasPoint(Point aPoint) {
        return Screen.hasPoint(aPoint);
    }

    private void init(Type typ) {
        if ("winapp".equals(sxOptions.getOption("testing"))) {
            this.log(this.lvl, "***** for testing: simulating WinApp", new Object[0]);
            testingWinApp = true;
        }
        for (String line : preLogMessages.split(";")) {
            if (line.isEmpty()) continue;
            this.log(this.lvl, line, new Object[0]);
        }
        this.log(4, "global init: entering as: %s", new Object[]{typ});
        if (fTempPath == null) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir != null && !tmpdir.isEmpty()) {
                fTempPath = new File(tmpdir);
            } else {
                throw new SikuliXception("init: java.io.tmpdir not valid (null or empty");
            }
        }
        this.fBaseTempPath = new File(fTempPath, String.format("Sikulix_%d", FileManager.getRandomInt()));
        this.fpBaseTempPath = this.fBaseTempPath.getAbsolutePath();
        this.fBaseTempPath.mkdirs();
        try {
            File tempTest = new File(this.fBaseTempPath, "tempTest.txt");
            FileManager.writeStringToFile("temp test", tempTest);
            boolean success = true;
            if (tempTest.exists()) {
                tempTest.delete();
                if (tempTest.exists()) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (!success) {
                throw new SikuliXception(String.format("init: temp folder not useable: %s", fTempPath));
            }
        }
        catch (Exception e) {
            throw new SikuliXception(String.format("init: temp folder not useable: %s", fTempPath));
        }
        this.log(3, "temp folder ok: %s", this.fpBaseTempPath);
        if (Type.IDE.equals((Object)typ) && !RunTime.runningScripts() && !RunTime.isAllowMultiple()) {
            this.isRunning = new File(fTempPath, this.isRunningFilename);
            boolean shouldTerminate = false;
            try {
                this.isRunning.createNewFile();
                this.isRunningFile = new FileOutputStream(this.isRunning);
                if (null == this.isRunningFile.getChannel().tryLock()) {
                    Class<?> classIDE = Class.forName("org.sikuli.ide.SikulixIDE");
                    Method stopSplash = classIDE.getMethod("stopSplash", new Class[0]);
                    stopSplash.invoke(null, new Object[0]);
                    Sikulix.popError("Terminating: IDE already running");
                    shouldTerminate = true;
                }
            }
            catch (Exception ex) {
                Sikulix.popError("Terminating on FatalError: cannot access IDE lock for/n" + this.isRunning);
                shouldTerminate = true;
            }
            if (shouldTerminate) {
                System.exit(1);
            }
        }
        for (String aFile : fTempPath.list()) {
            if ((!aFile.startsWith("Sikulix") || !new File(aFile).isFile()) && (!aFile.startsWith("jffi") || !aFile.endsWith(".tmp"))) continue;
            FileManager.deleteFileOrFolder(new File(fTempPath, aFile));
        }
        try {
            if (!this.fSikulixAppPath.exists()) {
                this.fSikulixAppPath.mkdirs();
            }
            if (!this.fSikulixAppPath.exists()) {
                throw new SikuliXception(String.format(appDataMsg, this.fSikulixAppPath));
            }
            this.fSikulixExtensions = new File(this.fSikulixAppPath, "Extensions");
            if (!this.fSikulixExtensions.exists()) {
                this.fSikulixExtensions.mkdir();
            }
            this.fSikulixDownloadsGeneric = new File(this.fSikulixAppPath, "SikulixDownloads");
            if (!this.fSikulixDownloadsGeneric.exists()) {
                this.fSikulixDownloadsGeneric.mkdir();
            }
            this.fSikulixLib = new File(this.fSikulixAppPath, "Lib");
            this.fSikulixSetup = new File(this.fSikulixAppPath, "SikulixSetup");
            this.fLibsProvided = new File(this.fSikulixAppPath, this.fpSysLibs);
            this.fLibsLocal = this.fLibsProvided.getParentFile().getParentFile();
        }
        catch (Exception ex) {
            throw new SikuliXception(String.format(appDataMsg + ex.toString(), this.fSikulixAppPath));
        }
        this.clsRef = RunTime.class;
        CodeSource codeSrc = this.clsRef.getProtectionDomain().getCodeSource();
        this.fSxBaseJar = null;
        URL urlCodeSrc = null;
        String urlCodeSrcProto = "not-set";
        if (codeSrc != null) {
            urlCodeSrc = codeSrc.getLocation();
            urlCodeSrcProto = urlCodeSrc.getProtocol();
            if (null != codeSrc) {
                this.fSxBaseJar = new File(codeSrc.getLocation().getPath());
                if (urlCodeSrcProto == "file") {
                    this.runningAs = RunType.CLASSES;
                    if (urlCodeSrc.getPath().endsWith(".jar")) {
                        this.runningAs = RunType.JAR;
                    }
                } else {
                    this.runningAs = RunType.OTHER;
                }
            }
        }
        this.appType = "from a jar";
        if (this.fSxBaseJar != null) {
            String baseJarName = this.fSxBaseJar.getName();
            this.fSxBase = this.fSxBaseJar.getParentFile();
            this.log(4, "runningAs: %s (%s) in: %s", new Object[]{this.runningAs, baseJarName, this.fSxBase.getAbsolutePath()});
            Debug.setWithTimeElapsed();
            if (baseJarName.contains("classes")) {
                this.runningJar = false;
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(4, "not jar - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from classes";
                this.runningInProject = true;
            } else if ("target".equals(this.fSxBase.getName())) {
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(4, "folder target detected - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from some jar";
                this.runningInProject = true;
            }
        } else {
            this.dumpClassPath();
            throw new SikuliXception(String.format("no valid Java context (%s)", this.clsRef));
        }
        if (this.runningInProject) {
            this.fSxProjectTestScriptsJS = new File(this.fSxProject, "StuffContainer/testScripts/testJavaScript");
            this.fSxProjectTestScripts = new File(this.fSxProject, "StuffContainer/testScripts");
        }
        this.runType = typ;
        if (Debug.getDebugLevel() == this.minLvl) {
            this.show();
        }
        this.log(4, "global init: leaving", new Object[0]);
    }

    public static void terminate() {
        RunTime.terminate(0, "", new Object[0]);
    }

    public static void terminate(int retval, String message, Object ... args) {
        String outMsg = String.format(message, args);
        if (!outMsg.isEmpty()) {
            System.out.println("TERMINATING: " + outMsg);
        }
        if (retval < 999) {
            isTerminating = true;
            RunTime.cleanUp();
            System.exit(retval);
        }
        throw new SikuliXception(String.format("fatal: " + outMsg, new Object[0]));
    }

    public static void cleanUp() {
        if (hasDoneCleanUpTerminating) {
            return;
        }
        if (!isTerminating) {
            runTime.log(3, "***** running cleanUp *****", new Object[0]);
            Highlight.closeAll();
            Settings.DefaultHighlightColor = "RED";
            Settings.DefaultHighlightTime = 2.0f;
            Settings.Highlight = false;
            Settings.setShowActions(false);
            FindFailed.reset();
            OCR.reset();
            Settings.OcrLanguage = "eng";
            Settings.OcrDataPath = null;
        }
        try {
            VNCScreen.stopAll();
            ADBScreen.stop();
        }
        catch (Exception e) {
            Debug.info("Error while stopping VNCScreen: %s", e.getMessage());
        }
        Observing.cleanUp();
        HotkeyManager.reset(isTerminating);
        if (null != cleanupRobot) {
            cleanupRobot.keyUp();
        }
        Mouse.reset();
        if (isTerminating) {
            hasDoneCleanUpTerminating = true;
        }
    }

    private static void runShutdownHook() {
        isTerminating = true;
        if (Debug.isStartWithTrace()) {
            Debug.on(3);
            Debug.globalTraceOn();
        }
        runTime.log(RunTime.runTime.lvl, "***** final cleanup at System.exit() *****", new Object[0]);
        RunTime.cleanUp();
        if (RunTime.runTime.isRunning != null) {
            try {
                RunTime.runTime.isRunningFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RunTime.runTime.isRunning.delete();
        }
        for (File f : fTempPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.toLowerCase().contains("sikuli")) {
                    if (name.contains("Sikulix_")) {
                        if (RunTime.isObsolete(new File(dir, name).lastModified()) || name.equals(runTime.fBaseTempPath.getName())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                return false;
            }
        })) {
            runTime.log(4, "cleanTemp: " + f.getName(), new Object[0]);
            FileManager.deleteFileOrFolder(f.getAbsolutePath());
        }
    }

    public String getOption(String oName) {
        return sxOptions.getOption(oName);
    }

    public Options options() {
        return sxOptions;
    }

    private boolean libsLoad(String libName) {
        this.log(this.lvl, "loadlib: trying %s", libName);
        String msg = "loadLib: %s";
        if (!this.areLibsExported) {
            this.libsExport();
        }
        if (!this.areLibsExported) {
            throw new SikuliXception("loadLib: deferred exporting of libs did not work");
        }
        File fLibsFolderUsed = this.fLibsFolder;
        if (this.runningWindows) {
            libName = libName + ".dll";
        } else if (this.runningMac) {
            libName = "lib" + libName + ".dylib";
        } else if (this.runningLinux) {
            libName = "lib" + libName + ".so";
        }
        File fLib = new File(this.fLibsFolder, libName);
        int level = this.lvl;
        if (!this.runningLinux) {
            Boolean vLib = this.libsLoaded.get(libName);
            if (vLib == null || !fLib.exists()) {
                if (!fLib.exists()) {
                    throw new SikuliXception(String.format("loadlib: %s not in any libs folder", libName));
                }
                vLib = false;
            }
            if (vLib.booleanValue()) {
                msg = msg + " already loaded";
                this.log(++level, msg, libName);
                return true;
            }
        }
        try {
            if (!this.runningLinux || libName.startsWith("libopen")) {
                // empty if block
            }
            System.load(fLib.getAbsolutePath());
        }
        catch (Exception e) {
            this.log(-1, "not usable: %s", e.getMessage());
            RunTime.terminate(999, "problem with native library: " + libName, new Object[0]);
        }
        catch (UnsatisfiedLinkError e) {
            this.log(-1, msg + " (failed) probably dependent libs missing:\n%s", libName, e.getMessage());
            String helpURL = "https://github.com/RaiMan/SikuliX1/wiki/macOS-Linux:-Support-Libraries-for-OpenCV-4";
            if (RunTime.isIDE()) {
                Debug.error("Save your work, correct the problem and restart the IDE!", new Object[0]);
                try {
                    Desktop.getDesktop().browse(new URI(helpURL));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Debug.error("see: " + helpURL, new Object[0]);
            RunTime.terminate(999, "problem with native library: " + libName, new Object[0]);
        }
        this.libsLoaded.put(libName, true);
        this.log(level, msg + " (success)", libName);
        return true;
    }

    public boolean shouldExport() {
        return this.didExport;
    }

    private void libsExport() {
        String[] fpList = fTempPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs");
            }
        });
        if (fpList.length > 0) {
            this.log(this.lvl, "libsExport: deleting obsolete libs folders in Temp", new Object[0]);
            for (String entry : fpList) {
                if (entry.endsWith(Commons.getSxBuildStamp())) continue;
                FileManager.deleteFileOrFolder(new File(fTempPath, entry));
            }
        }
        if ((fpList = this.fSikulixAppPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs_");
            }
        })).length > 0) {
            this.log(this.lvl, "libsExport: deleting obsolete libs folders in AppPath", new Object[0]);
            for (String entry : fpList) {
                FileManager.deleteFileOrFolder(new File(this.fSikulixAppPath, entry));
            }
        }
        this.fLibsFolder = new File(this.fSikulixAppPath, "SikulixLibs");
        String libMsg = "folder exists:";
        if (this.fLibsFolder.exists() && !Commons.hasVersionFile(this.fLibsFolder)) {
            FileManager.deleteFileOrFolder(this.fLibsFolder);
            this.log(this.lvl, "libsExport: folder has wrong content: %s", this.fLibsFolder);
        }
        if (!this.fLibsFolder.exists()) {
            this.fLibsFolder.mkdirs();
            if (!this.fLibsFolder.exists()) {
                throw new SikuliXception("libsExport: folder not available: " + this.fLibsFolder.toString());
            }
            Commons.makeVersionFile(this.fLibsFolder);
            libMsg = "folder created:";
            List<String> nativesList = this.getResourceList(this.fpJarLibs);
            for (String aFile : nativesList) {
                String inFile;
                String copyMsg = "";
                Class<?> classRef = this.clsRef;
                if (aFile.startsWith("/")) {
                    String[] parts = aFile.split("@");
                    if (parts.length > 1) {
                        inFile = parts[0];
                        try {
                            classRef = Class.forName(parts[1]);
                        }
                        catch (ClassNotFoundException e) {
                            copyMsg = String.format("libExport: %s: ", aFile);
                        }
                    } else {
                        inFile = aFile;
                    }
                    aFile = new File(inFile).getName();
                } else {
                    inFile = new File(this.fpJarLibs, aFile).getPath();
                }
                if (this.runningWindows) {
                    inFile = inFile.replace("\\", "/");
                }
                try (FileOutputStream outFile = new FileOutputStream(new File(this.fLibsFolder, aFile));
                     InputStream inStream = classRef.getResourceAsStream(inFile);){
                    RunTime.copy(inStream, outFile);
                    this.libsLoaded.put(aFile, false);
                }
                catch (Exception ex) {
                    copyMsg = copyMsg + String.format("failed: %s", ex.getMessage());
                }
                copyMsg = String.format("libsExport: %s: %s", aFile, copyMsg);
                if (copyMsg.contains("failed")) {
                    FileManager.deleteFileOrFolder(this.fLibsFolder);
                    this.log(-1, copyMsg, new Object[0]);
                    break;
                }
                this.log(this.lvl + 1, copyMsg, new Object[0]);
                this.didExport = true;
            }
        }
        if (this.runningWindows) {
            this.addToWindowsSystemPath(this.fLibsFolder);
        }
        this.log(this.lvl, "libsExport: " + libMsg + " %s (%s - %s)", this.fLibsFolder, this.getVersionShort(), Commons.getSxBuildStamp());
        this.areLibsExported = true;
    }

    public static boolean loadLibrary(String libname) {
        if (isTerminating) {
            return false;
        }
        return RunTime.get().libsLoad(libname);
    }

    public static boolean loadLibrary(String libname, boolean useLibsProvided) {
        RunTime runTime = RunTime.get();
        runTime.useLibsProvided = useLibsProvided;
        return RunTime.loadLibrary(libname);
    }

    private void addToWindowsSystemPath(File fLibsFolder) {
        for (File bridjFile : fTempPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("BridJExtractedLibraries");
            }
        })) {
            runTime.log(4, "cleanTemp: " + bridjFile.getName(), new Object[0]);
            FileManager.deleteFileOrFolder(bridjFile);
        }
        String syspath = WinUtil.getEnv("PATH");
        if (syspath == null) {
            throw new SikuliXception("addToWindowsSystemPath: cannot access system path");
        }
        String libsPath = fLibsFolder.getAbsolutePath();
        if (!syspath.toUpperCase().contains(libsPath.toUpperCase())) {
            syspath = WinUtil.setEnv("PATH", libsPath + ";" + syspath);
            if (null != syspath && !syspath.toUpperCase().contains(libsPath.toUpperCase())) {
                this.log(-1, "addToWindowsSystemPath: adding to system path did not work:\n%s", syspath);
                throw new SikuliXception("addToWindowsSystemPath: did not work - see error");
            }
            this.log(this.lvl, "addToWindowsSystemPath: added to systempath:\n%s", libsPath);
        }
    }

    private boolean checkJavaUsrPath(File fLibsFolder) {
        if (this.isJava9(new String[0])) {
            return true;
        }
        String fpLibsFolder = fLibsFolder.getAbsolutePath();
        Field usrPathsField = null;
        boolean contained = false;
        try {
            usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        }
        catch (NoSuchFieldException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        catch (SecurityException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        if (usrPathsField != null) {
            usrPathsField.setAccessible(true);
            try {
                String[] javapaths;
                for (String p : javapaths = (String[])usrPathsField.get(null)) {
                    if (!new File(p).equals(fLibsFolder)) continue;
                    contained = true;
                    break;
                }
                if (!contained) {
                    String[] newPaths = Arrays.copyOf(javapaths, javapaths.length + 1);
                    newPaths[newPaths.length - 1] = fpLibsFolder;
                    usrPathsField.set(null, newPaths);
                    this.log(this.lvl, "checkJavaUsrPath: added to ClassLoader.usrPaths", new Object[0]);
                    contained = true;
                }
            }
            catch (IllegalAccessException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            catch (IllegalArgumentException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            return contained;
        }
        return false;
    }

    private void initIDEbefore() {
        this.log(4, "initIDEbefore: entering", new Object[0]);
        isRunningIDE = true;
        this.log(4, "initIDEbefore: leaving", new Object[0]);
    }

    private void initIDEafter() {
        this.log(4, "initIDEafter: entering", new Object[0]);
        try {
            this.cIDE = Class.forName("org.sikuli.ide.SikulixIDE");
            this.mHide = this.cIDE.getMethod("hideIDE", new Class[0]);
            this.mShow = this.cIDE.getMethod("showIDE", new Class[0]);
        }
        catch (Exception ex) {
            this.log(-1, "SikulixIDE: reflection: %s", ex.getMessage());
        }
        this.log(4, "initIDEafter: leaving", new Object[0]);
    }

    public void hideIDE() {
        if (null != this.cIDE) {
            try {
                this.mHide.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void showIDE() {
        if (null != this.cIDE) {
            try {
                this.mShow.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void initAPI() {
        this.log(4, "initAPI: entering", new Object[0]);
        try {
            cleanupRobot = new RobotDesktop();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.log(4, "initAPI: leaving", new Object[0]);
    }

    public void exportLib() {
        if (isLibExported) {
            return;
        }
        if (this.fSikulixLib.exists() && !Commons.hasVersionFile(this.fSikulixLib)) {
            FileManager.deleteFileOrFolder(this.fSikulixLib, new FileManager.FileFilter(){

                @Override
                public boolean accept(File entry) {
                    return !entry.getPath().contains("site-packages");
                }
            });
            this.extractResourcesToFolder("Lib", this.fSikulixLib, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !dir.getPath().contains("site-packages");
                }
            });
            Commons.makeVersionFile(this.fSikulixLib);
        }
        if (!this.fSikulixLib.exists()) {
            this.fSikulixLib.mkdir();
            if (!this.fSikulixLib.exists()) {
                throw new SikuliXception("LibExport: folder not available: " + this.fSikulixLib.toString());
            }
            this.extractResourcesToFolder("Lib", this.fSikulixLib, null);
            Commons.makeVersionFile(this.fSikulixLib);
        }
        isLibExported = true;
    }

    public void crash() {
        int x = 1 / 0;
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause(float time) {
        try {
            Thread.sleep((int)(time * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRunningFromJar() {
        return this.runningJar;
    }

    public boolean isJava9(String ... args) {
        if (Commons.getJavaVersion() > 8) {
            if (args.length > 0) {
                this.log(-1, "*** Java 9+: %s", args[0]);
            }
            return true;
        }
        return false;
    }

    public boolean needsRobotFake() {
        return this.runningMac && Settings.ClickTypeHack;
    }

    public void show() {
        if (sxOptions.hasOptions()) {
            sxOptions.dumpOptions();
        }
        this.logp("***** show environment for %s %s", new Object[]{Commons.getSXVersion(), this.runType});
        this.logp("user.home: %s", Commons.getUserHome());
        this.logp("work dir: %s", Commons.getWorkDir());
        this.logp("running on %s %s", Commons.getOSInfo(), this.appType);
        this.logp("running Java %s", Commons.getJavaInfo());
        this.logp("java.io.tmpdir: %s", fTempPath);
        this.logp("app data folder: %s", Commons.getAppDataPath());
        if (this.runningJar) {
            this.logp("executing jar: %s", this.fSxBaseJar);
        }
        if (Debug.getDebugLevel() > this.minLvl - 1 || this.isJythonReady) {
            this.dumpClassPath("sikulix");
            if (this.isJythonReady) {
                int saveLvl = Debug.getDebugLevel();
                Debug.setDebugLevel(this.lvl);
                JythonSupport.get().showSysPath();
                Screen.showMonitors();
                Debug.setDebugLevel(saveLvl);
            }
        }
        this.logp("***** show environment end", new Object[0]);
    }

    public boolean testSwitch() {
        return 0L == new Date().getTime() / 10000L % 2L;
    }

    public String getVersionShort() {
        return Commons.getSXVersionShort();
    }

    public String getSystemInfo() {
        return String.format("%s/%s/%s", this.SXVersionLong, this.SXSystemVersion, this.SXJavaVersion);
    }

    public boolean isVersionRelease() {
        return !this.SXVersion.endsWith("-SNAPSHOT");
    }

    public String getVersion() {
        return this.SXVersion;
    }

    public void getStatus() {
        System.out.println("***** System Information Dump *****");
        System.out.println(String.format("*** SystemInfo\n%s", this.getSystemInfo()));
        System.getProperties().list(System.out);
        System.out.println("*** System Environment");
        for (String key : System.getenv().keySet()) {
            System.out.println(String.format("%s = %s", key, System.getenv(key)));
        }
        System.out.println("*** Java Class Path");
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println(String.format("%d: %s", i, urls[i]));
        }
        System.out.println("***** System Information Dump ***** end *****");
    }

    public List<String> getResourceList(String res) {
        return this.getResourceList(res, this.clsRef);
    }

    public List<String> getResourceList(String res, Class classReference) {
        ArrayList<String> resList = new ArrayList<String>();
        CodeSource codeSource = classReference.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return resList;
        }
        InputStream aIS = null;
        String content = null;
        res = new File(res, "sikulixcontent").getPath();
        if (this.runningWindows) {
            res = res.replace("\\", "/");
        }
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        try {
            aIS = classReference.getResourceAsStream(res);
            if (aIS != null) {
                content = new String(this.copy(aIS));
                aIS.close();
            }
            this.log(this.lvl + 1, "getResourceList: %s (%s)", res, content);
            aIS = null;
        }
        catch (Exception ex) {
            this.log(-1, "getResourceList: %s (%s)", res, ex);
        }
        try {
            if (aIS != null) {
                aIS.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (null != content) {
            String[] names;
            for (String name : names = content.split("\n")) {
                if (name.equals("sikulixcontent")) continue;
                resList.add(name.trim());
            }
        }
        return resList;
    }

    public List<String> extractResourcesToFolder(String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = this.resourceList(fpRessources, filter);
        if (content == null) {
            return null;
        }
        if (fFolder == null) {
            return content;
        }
        return this.doExtractToFolderWithList(fpRessources, fFolder, content);
    }

    public List<String> doExtractToFolderWithList(String fpRessources, File fFolder, List<String> content) {
        int count = 0;
        int ecount = 0;
        String subFolder = "";
        if (content != null && content.size() > 0) {
            for (String eFile : content) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                if (this.extractResourceToFile(fpRessources, eFile, fFolder)) {
                    this.log(this.lvl + 1, "extractResourceToFile done: %s", eFile);
                    ++count;
                    continue;
                }
                ++ecount;
            }
        }
        if (ecount > 0) {
            this.log(this.lvl, "files exported: %d - skipped: %d from %s to:\n %s", count, ecount, fpRessources, fFolder);
        } else {
            this.log(this.lvl, "files exported: %d from: %s to:\n %s", count, fpRessources, fFolder);
        }
        return content;
    }

    public List<String> extractResourcesToFolderFromJar(String aJar, String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = new ArrayList<String>();
        File faJar = new File(aJar);
        URL uaJar = null;
        fpRessources = FileManager.slashify(fpRessources, false);
        if (faJar.isAbsolute()) {
            if (!faJar.exists()) {
                this.log(-1, "extractResourcesToFolderFromJar: does not exist:\n%s", faJar);
                return null;
            }
            try {
                uaJar = new URL("jar", null, "file:" + aJar);
            }
            catch (MalformedURLException ex) {
                this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", faJar);
                return null;
            }
        }
        uaJar = this.fromClasspath(aJar);
        if (uaJar == null) {
            this.log(-1, "extractResourcesToFolderFromJar: not on classpath: %s", aJar);
            return null;
        }
        try {
            String sJar = "file:" + uaJar.getPath() + "!/";
            uaJar = new URL("jar", null, sJar);
        }
        catch (MalformedURLException ex) {
            this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", uaJar);
            return null;
        }
        content = this.doResourceListJar(uaJar, fpRessources, content, filter);
        if (fFolder == null) {
            return content;
        }
        this.copyFromJarToFolderWithList(uaJar, fpRessources, content, fFolder);
        return content;
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir) {
        return this.extractResourceToFile(inPrefix, inFile, outDir, "");
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir, String outFile) {
        String content = inPrefix + "/" + inFile;
        try {
            File out;
            InputStream aIS;
            String string = content = this.runningWindows ? content.replace("\\", "/") : content;
            if (!content.startsWith("/")) {
                content = "/" + content;
            }
            if ((aIS = this.clsRef.getResourceAsStream(content)) == null) {
                File fInFile = new File(content);
                if (!fInFile.exists()) {
                    throw new IOException(String.format("resource not accessible: %s", content));
                }
                aIS = new FileInputStream(fInFile);
            }
            File file = out = outFile.isEmpty() ? new File(outDir, inFile) : new File(outDir, outFile);
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            FileOutputStream aFileOS = new FileOutputStream(out);
            RunTime.copy(aIS, aFileOS);
            aIS.close();
            aFileOS.close();
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToFile: %s\n%s", content, ex);
            return false;
        }
        return true;
    }

    public String extractResourceToString(String inPrefix, String inFile, String encoding) {
        InputStream aIS = null;
        String out = null;
        String content = inPrefix + "/" + inFile;
        if (!content.startsWith("/")) {
            content = "/" + content;
        }
        try {
            content = this.runningWindows ? content.replace("\\", "/") : content;
            aIS = this.clsRef.getResourceAsStream(content);
            if (aIS == null) {
                throw new IOException("resource not accessible");
            }
            if (encoding == null) {
                encoding = "UTF-8";
                out = new String(this.copy(aIS));
            } else {
                out = encoding.isEmpty() ? new String(this.copy(aIS), "UTF-8") : new String(this.copy(aIS), encoding);
            }
            aIS.close();
            aIS = null;
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToString as %s from:\n%s\n%s", encoding, content, ex);
        }
        try {
            if (aIS != null) {
                aIS.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public URL resourceLocation(String folderOrFile) {
        this.log(this.lvl, "resourceLocation: (%s) %s", this.clsRef, folderOrFile);
        if (!folderOrFile.startsWith("/")) {
            folderOrFile = "/" + folderOrFile;
        }
        return this.clsRef.getResource(folderOrFile);
    }

    private List<String> resourceList(String folder, FilenameFilter filter) {
        List<String> files = new ArrayList<String>();
        if (!folder.startsWith("/")) {
            folder = "/" + folder;
        }
        URL uFolder = this.resourceLocation(folder);
        File fFolder = null;
        if (uFolder == null) {
            fFolder = new File(folder);
            if (fFolder.exists()) {
                files = this.doResourceListFolder(fFolder, files, filter);
            } else {
                this.log(this.lvl, "resourceList: not found: %s", folder);
            }
            return files;
        }
        try {
            uFolder = new URL(uFolder.toExternalForm().replaceAll(" ", "%20"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL uContentList = this.clsRef.getResource(folder + "/" + this.fpContent);
        if (uContentList != null) {
            return this.doResourceListWithList(folder, files, filter);
        }
        try {
            fFolder = new File(uFolder.toURI());
            this.log(this.lvl, "resourceList: having folder: %s", fFolder);
            files.add(fFolder.getPath());
            files = this.doResourceListFolder(fFolder, files, filter);
            files.remove(0);
            return files;
        }
        catch (Exception ex) {
            if (!"jar".equals(uFolder.getProtocol())) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: URL neither folder nor jar:\n%s", ex);
                return null;
            }
            String[] parts = uFolder.getPath().split("!");
            if (parts.length < 2 || !parts[0].startsWith("file:")) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: not a valid jar URL: " + uFolder.getPath(), new Object[0]);
                return null;
            }
            String fpFolder = parts[1];
            this.log(this.lvl, "resourceList: having jar: %s", uFolder);
            return this.doResourceListJar(uFolder, fpFolder, files, filter);
        }
    }

    public String[] resourceListAsFile(String folder, File target, FilenameFilter filter) {
        String content = this.resourceListAsString(folder, filter);
        if (content == null) {
            this.log(-1, "resourceListAsFile: did not work: %s", folder);
            return null;
        }
        if (target != null) {
            try {
                FileManager.deleteFileOrFolder(target.getAbsolutePath());
                target.getParentFile().mkdirs();
                PrintWriter aPW = new PrintWriter(target);
                aPW.write(content);
                aPW.close();
            }
            catch (Exception ex) {
                this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
            }
        }
        return content.split(System.getProperty("line.separator"));
    }

    public String[] resourceListAsSikulixContent(String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.resourceList(folder, filter);
        if (contentList == null) {
            this.log(-1, "resourceListAsSikulixContent: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String[] resourceListAsSikulixContentFromJar(String aJar, String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.extractResourcesToFolderFromJar(aJar, folder, null, filter);
        if (contentList == null || contentList.size() == 0) {
            this.log(-1, "resourceListAsSikulixContentFromJar: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String resourceListAsString(String folder, FilenameFilter filter) {
        return this.resourceListAsString(folder, filter, null);
    }

    public String resourceListAsString(String folder, FilenameFilter filter, String separator) {
        List<String> aList = this.resourceList(folder, filter);
        if (aList == null) {
            return null;
        }
        if (separator == null) {
            separator = System.getProperty("line.separator");
        }
        String out = "";
        String subFolder = "";
        if (aList != null && aList.size() > 0) {
            for (String eFile : aList) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                out = out + eFile.replace("\\", "/") + separator;
            }
        }
        return out;
    }

    private List<String> doResourceListFolder(File fFolder, List<String> files, FilenameFilter filter) {
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String subFolder = "";
        if (fFolder.isDirectory()) {
            String[] subList;
            if (files.size() > 0 && !FileManager.pathEquals(fFolder.getPath(), files.get(0))) {
                subFolder = fFolder.getPath().substring(files.get(0).length() + 1).replace("\\", "/") + "/";
                if (filter != null && !filter.accept(new File(files.get(0), subFolder), "")) {
                    return files;
                }
            } else {
                this.logp(localLevel, "scanning folder:\n%s", fFolder);
                subFolder = "/";
                files.add(subFolder);
            }
            for (String entry : subList = fFolder.list()) {
                File fEntry = new File(fFolder, entry);
                if (fEntry.isDirectory()) {
                    files.add(fEntry.getAbsolutePath().substring(1 + files.get(0).length()).replace("\\", "/") + "/");
                    this.doResourceListFolder(fEntry, files, filter);
                    files.add(subFolder);
                    continue;
                }
                if (filter != null && !filter.accept(fFolder, entry)) continue;
                this.logp(localLevel, "from %s adding: %s", subFolder.isEmpty() ? "." : subFolder, entry);
                files.add(fEntry.getAbsolutePath().substring(1 + fFolder.getPath().length()));
            }
        }
        return files;
    }

    public List<String> doResourceListWithList(String folder, List<String> files, FilenameFilter filter) {
        String content;
        String[] contentList = content.split((content = this.extractResourceToString(folder, this.fpContent, "")).indexOf("\r") != -1 ? "\r\n" : "\n");
        if (filter == null) {
            files.addAll(Arrays.asList(contentList));
        } else {
            for (String fpFile : contentList) {
                if (!filter.accept(new File(fpFile), "")) continue;
                files.add(fpFile);
            }
        }
        return files;
    }

    private List<String> doResourceListJar(URL uJar, String fpResource, List<String> files, FilenameFilter filter) {
        String fpJar = uJar.getPath().split("!")[0];
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String fileSep = "/";
        if (!fpJar.endsWith(".jar")) {
            return files;
        }
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpResource = (fpResource.startsWith("/") ? fpResource.substring(1) : fpResource) + "/";
        File fFolder = new File(fpResource);
        File fSubFolder = null;
        String subFolder = "";
        boolean skip = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zePath;
                if (zEntry.getName().endsWith("/") || !(zePath = zEntry.getName()).startsWith(fpResource)) continue;
                String zeName = zePath.substring(fpResource.length());
                int nSep = zeName.lastIndexOf(fileSep);
                String zefName = zeName.substring(nSep + 1, zeName.length());
                String zeSub = "";
                if (nSep > -1) {
                    zeSub = zeName.substring(0, nSep + 1);
                    if (!subFolder.equals(zeSub)) {
                        subFolder = zeSub;
                        fSubFolder = new File(fFolder, subFolder);
                        skip = false;
                        if (filter != null && !filter.accept(fSubFolder, "")) {
                            skip = true;
                            continue;
                        }
                        files.add(zeSub);
                    }
                    if (skip) {
                        continue;
                    }
                } else if (!subFolder.isEmpty()) {
                    subFolder = "";
                    fSubFolder = fFolder;
                    files.add("/");
                }
                if (filter != null && !filter.accept(fSubFolder, zefName)) continue;
                files.add(zefName);
                this.logp(localLevel, "from %s adding: %s", zeSub.isEmpty() ? "." : zeSub, zefName);
            }
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return files;
        }
        return files;
    }

    public List<String> listFilesInJar(URL uJar) {
        String fpJar = uJar.getPath().split("!")[0];
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String fileSep = "/";
        if (!fpJar.endsWith(".jar")) {
            return null;
        }
        this.logp(localLevel, "listFilesInJar: scanning jar:\n%s", uJar);
        ArrayList<String> files = new ArrayList<String>();
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                if (zEntry.getName().endsWith("/")) continue;
                String zePath = zEntry.getName();
                files.add(zePath);
                this.logp(localLevel, "listFilesInJar: adding: %s", zePath);
            }
        }
        catch (Exception ex) {
            this.log(-1, "listFilesInJar: %s", ex);
            return files;
        }
        return files;
    }

    private boolean copyFromJarToFolderWithList(URL uJar, String fpRessource, List<String> files, File fFolder) {
        if (files == null || files.isEmpty()) {
            this.log(this.lvl, "copyFromJarToFolderWithList: list of files is empty", new Object[0]);
            return false;
        }
        String fpJar = uJar.getPath().split("!")[0];
        if (!fpJar.endsWith(".jar")) {
            return false;
        }
        int localLevel = testing ? this.lvl : this.lvl + 1;
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpRessource = fpRessource.startsWith("/") ? fpRessource.substring(1) : fpRessource;
        String subFolder = "";
        int maxFiles = files.size() - 1;
        int nFiles = 0;
        int prefix = fpRessource.length();
        fpRessource = fpRessource + (!fpRessource.isEmpty() ? "/" : "");
        String current = "/";
        boolean shouldStop = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zPath = zEntry.getName();
                if (zPath.endsWith("/")) continue;
                while (current.endsWith("/")) {
                    if (nFiles > maxFiles) {
                        shouldStop = true;
                        break;
                    }
                    String string = subFolder = current.length() == 1 ? "" : current;
                    if ((current = files.get(nFiles++)).endsWith("/")) continue;
                    current = fpRessource + subFolder + current;
                    break;
                }
                if (shouldStop) break;
                if (!zPath.startsWith(current)) continue;
                if (zPath.length() == fpRessource.length() - 1) {
                    this.log(-1, "extractResourcesToFolderFromJar: only ressource folders allowed - use filter", new Object[0]);
                    return false;
                }
                this.logp(localLevel, "copying: %s", zPath);
                File out = new File(fFolder, zPath.substring(prefix));
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileOutputStream aFileOS = new FileOutputStream(out);
                RunTime.copy(zJar, aFileOS);
                aFileOS.close();
                if (nFiles > maxFiles) break;
                if ((current = files.get(nFiles++)).endsWith("/")) continue;
                current = fpRessource + subFolder + current;
            }
            zJar.close();
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return false;
        }
        return true;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] tmp = new byte[8192];
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
        out.flush();
    }

    private byte[] copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    private void storeClassPath() {
        if (this.isJava9(new String[0])) {
            String separator = File.pathSeparator;
            String cp = System.getProperty("java.class.path");
            this.classPathList = Arrays.asList(cp.split(separator));
        } else {
            this.classPathActual.clear();
            URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            this.classPathActual = Arrays.asList(sysLoader.getURLs());
            this.classPathList.clear();
            for (URL urlPath : this.classPathActual) {
                this.classPathList.add(urlPath.toExternalForm());
            }
        }
    }

    public void dumpClassPath() {
        this.dumpClassPath(null);
    }

    public void dumpClassPath(String filter) {
        filter = filter == null ? "" : filter;
        this.logp("*** classpath dump %s", filter);
        this.storeClassPath();
        filter = filter.toUpperCase();
        int n = 0;
        for (String sEntry : this.classPathList) {
            if (!filter.isEmpty() && !sEntry.toUpperCase().contains(filter)) {
                ++n;
                continue;
            }
            this.logp("%3d: %s", n, sEntry);
            ++n;
        }
        this.logp("*** classpath dump end", new Object[0]);
    }

    private String isOnClasspath(String artefact, boolean isJar) {
        artefact = FileManager.slashify(artefact, false);
        String cpe = null;
        if (this.classPathList.isEmpty()) {
            this.storeClassPath();
        }
        for (String entry : this.classPathList) {
            String sEntry = FileManager.slashify(new File(entry).getPath(), false);
            if (!sEntry.contains(artefact) || isJar && (!sEntry.endsWith(".jar") || !new File(sEntry).getName().contains(artefact) || new File(sEntry).getName().contains("4" + artefact))) continue;
            cpe = new File(entry).getPath();
            break;
        }
        return cpe;
    }

    public String isJarOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, true);
    }

    public String isOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, false);
    }

    public URL fromClasspath(String artefact) {
        artefact = FileManager.slashify(artefact, false).toUpperCase();
        URL cpe = null;
        String scpe = null;
        if (this.classPathActual.isEmpty()) {
            this.storeClassPath();
        }
        for (String entry : this.classPathList) {
            String sEntry = FileManager.slashify(new File(entry).getPath(), false);
            if (!sEntry.toUpperCase().contains(artefact)) continue;
            scpe = entry;
            break;
        }
        if (null != scpe) {
            try {
                cpe = new URL(scpe);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return cpe;
    }

    public boolean isOnClasspath(URL path) {
        if (this.classPathActual.isEmpty()) {
            this.storeClassPath();
        }
        for (String string : this.classPathList) {
        }
        return false;
    }

    public boolean addToClasspath(String jarOrFolder) {
        return this.addToClasspath(jarOrFolder, "");
    }

    public boolean addToClasspath(String jarOrFolder, String caller) {
        if (null != this.isOnClasspath(jarOrFolder)) {
            return true;
        }
        if (this.isJava9("skipped: addToClasspath() - caller: " + caller)) {
            this.sxClasspath.add(jarOrFolder);
            return false;
        }
        if (!new File(jarOrFolder).exists()) {
            this.log(-1, "addToClasspath: does not exist - not added:\n%s", jarOrFolder);
            return false;
        }
        return false;
    }

    public File asExtension(String fpJar) {
        File fJarFound = new File(FileManager.normalizeAbsolute(fpJar));
        if (!fJarFound.exists()) {
            String fpCPEntry = runTime.isOnClasspath(fJarFound.getName());
            if (fpCPEntry == null) {
                fJarFound = new File(RunTime.runTime.fSikulixExtensions, fpJar);
                if (!fJarFound.exists() && !(fJarFound = new File(RunTime.runTime.fSikulixLib, fpJar)).exists()) {
                    fJarFound = null;
                }
            } else {
                fJarFound = new File(fpCPEntry, fJarFound.getName());
            }
        } else {
            return null;
        }
        return fJarFound;
    }

    public String runcmd(String cmd) {
        return this.runcmd(new String[]{cmd});
    }

    public String runcmd(String[] args) {
        int retVal;
        if (args.length == 0) {
            return "";
        }
        boolean silent = false;
        if (args.length == 1) {
            String separator = "\"";
            ArrayList<String> argsx = new ArrayList<String>();
            String cmd = args[0];
            if (Settings.isWindows()) {
                cmd = cmd.replaceAll("\\\\ ", "%20;");
            }
            StringTokenizer toks = new StringTokenizer(cmd);
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken(" ");
                if (tok.length() == 0 || separator.equals(tok)) continue;
                if (tok.startsWith(separator)) {
                    if (tok.endsWith(separator)) {
                        tok = tok.substring(1, tok.length() - 1);
                    } else {
                        tok = tok.substring(1);
                        tok = tok + toks.nextToken(separator);
                    }
                }
                argsx.add(tok.replaceAll("%20;", " "));
            }
            args = argsx.toArray(new String[0]);
        }
        if (args[0].startsWith("!")) {
            silent = true;
            args[0] = args[0].substring(1);
        }
        if (args[0].startsWith("#")) {
            String pgm = args[0].substring(1);
            args[0] = new File(pgm).getAbsolutePath();
            this.runcmd(new String[]{"chmod", "ugo+x", args[0]});
        }
        String result = "";
        String error = runCmdError + NL;
        String errorOut = "";
        boolean hasError = false;
        try {
            String s;
            if (!silent) {
                if (this.lvl <= Debug.getDebugLevel()) {
                    this.log(this.lvl, RunTime.arrayToQuotedString(args), new Object[0]);
                } else {
                    Debug.info("runcmd: " + RunTime.arrayToQuotedString(args), new Object[0]);
                }
            }
            Process process = Runtime.getRuntime().exec(args);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.isEmpty()) continue;
                result = result + s + NL;
            }
            while ((s = stdError.readLine()) != null) {
                if (s.isEmpty()) continue;
                errorOut = errorOut + s + NL;
            }
            if (!errorOut.isEmpty()) {
                error = error + errorOut;
                hasError = true;
            }
            process.waitFor();
            retVal = process.exitValue();
            process.destroy();
        }
        catch (Exception e) {
            this.log(-1, "fatal error: " + e, new Object[0]);
            result = String.format(error + "%s", e);
            retVal = 9999;
            hasError = true;
        }
        if (hasError) {
            result = result + error;
        }
        this.lastResult = result;
        return String.format("%d%s%s", retVal, NL, result);
    }

    public String getLastCommandResult() {
        return this.lastResult;
    }

    static {
        Commons.init();
        runTime = null;
        osNameShort = System.getProperty("os.name").substring(0, 1).toLowerCase();
        startAsIDE = true;
        allowMultiple = false;
        asServer = false;
        serverOptions = null;
        serverGroups = null;
        serverExtra = null;
        asPythonServer = false;
        userArgs = new String[0];
        sxArgs = new String[0];
        elapsedStart = new Date().getTime();
        logFile = "";
        userLogFile = "";
        loadScripts = new String[0];
        shouldRunScript = false;
        runScripts = new String[0];
        preLogMessages = "";
        verbose = false;
        quiet = false;
        sxOptions = null;
        isTerminating = false;
        hasDoneCleanUpTerminating = false;
        appDataMsg = "";
        testing = false;
        testingWinApp = false;
        fTempPath = null;
        libOpenCV = Core.NATIVE_LIBRARY_NAME;
        NL = "\n";
        started = new Date().getTime();
        obsolete = started - 172800000L;
        optTesting = false;
        isRunningIDE = false;
        cleanupRobot = null;
        isLibExported = false;
    }

    public class oneFileFilter
    implements FilenameFilter {
        String aFile;

        public oneFileFilter(String aFileGiven) {
            this.aFile = aFileGiven;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.aFile);
        }
    }

    public static enum RunType {
        JAR,
        CLASSES,
        OTHER;

    }

    private static enum theSystem {
        WIN,
        MAC,
        LUX,
        FOO;

    }

    public static enum Type {
        IDE,
        API,
        INIT;

    }
}

