/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.script.runners.ZipRunner;

public class JarRunner
extends ZipRunner {
    public static final String NAME = "SikulixJar";
    public static final String TYPE = "text/jar";
    public static final String[] EXTENSIONS = new String[]{"jar"};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected ZipFile openZipFile(String identifier) throws IOException {
        return new JarFile(identifier);
    }

    @Override
    protected String getScriptEntryName(ZipFile file) {
        return FilenameUtils.getBaseName((String)file.getName()).replace("_sikuli", "") + "$py";
    }
}

