/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import java.io.IOException;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.script.runners.ZipRunner;
import org.sikuli.script.support.IScriptRunner;

public class JarExeRunner
extends ZipRunner {
    public static final String NAME = "SikulixExecutableJar";
    public static final String TYPE = "text/jar";
    public static final String[] EXTENSIONS = new String[]{"executablejar"};

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String[] getExtensions() {
        return (String[])EXTENSIONS.clone();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public IScriptRunner.EffectiveRunner getEffectiveRunner(String zipFile) {
        return super.getEffectiveRunner(zipFile.replace(".executablejar", ".jar"));
    }

    @Override
    protected ZipFile openZipFile(String identifier) throws IOException {
        return new JarFile(identifier.replace(".executablejar", ".jar"));
    }

    @Override
    protected String getScriptEntryName(ZipFile file) {
        return FilenameUtils.getBaseName((String)file.getName()).replace("_sikuli", "") + "$py";
    }
}

