/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.support.Commons;
import org.sikuli.script.support.RunTime;

public class ImagePath {
    private static final String me = "ImagePath: ";
    private static final int lvl = 3;
    private static final List<PathEntry> imagePaths = Collections.synchronizedList(new ArrayList());

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static List<PathEntry> getPaths() {
        return imagePaths;
    }

    private static int getCount() {
        int count = imagePaths.size();
        for (PathEntry path : imagePaths) {
            if (path != null) continue;
            --count;
        }
        return count;
    }

    private static URL remove(int entry) {
        if (entry > 0 && entry < imagePaths.size()) {
            PathEntry pathEntry = imagePaths.remove(entry);
            Image.purge(pathEntry);
            return pathEntry.pathURL;
        }
        return null;
    }

    public static String[] get() {
        int i = 0;
        String[] paths = new String[ImagePath.getPaths().size()];
        i = 0;
        for (PathEntry p : imagePaths) {
            paths[i++] = p.getPath();
        }
        return paths;
    }

    public static void dump(int lvl) {
        ImagePath.log(lvl, "ImagePath has %d entries (valid %d)", imagePaths.size(), ImagePath.getCount());
        int i = 0;
        for (PathEntry p : imagePaths) {
            if (i == 0) {
                ImagePath.log(lvl, "BundlePath: %s", p == null ? "--- not set ---" : p.getPath());
            } else {
                ImagePath.log(lvl, "Path %d: %s", i, p.getPath());
            }
            ++i;
        }
    }

    public static void reset() {
        ImagePath.log(3, "reset", new Object[0]);
        if (imagePaths.isEmpty()) {
            return;
        }
        for (PathEntry pathEntry : imagePaths) {
            if (pathEntry == null) continue;
            Image.purge(pathEntry);
        }
        PathEntry bundlePath = ImagePath.getBundle();
        imagePaths.clear();
        imagePaths.add(bundlePath);
    }

    public static boolean reset(String path) {
        ImagePath.reset();
        if (ImagePath.bundleEquals(path)) {
            return true;
        }
        return ImagePath.setBundlePath(path);
    }

    public static void clear() {
        ImagePath.reset();
        ImagePath.log(3, "clear", new Object[0]);
        Image.purge();
        imagePaths.set(0, null);
    }

    private static boolean hasPathEntry(PathEntry pathEntry) {
        PathEntry bundle = ImagePath.getBundle();
        if (imagePaths.size() == 1 && bundle == null) {
            return false;
        }
        if (ImagePath.isBundle(pathEntry)) {
            return true;
        }
        return ImagePath.isPathEntry(pathEntry) != 0;
    }

    private static int isPathEntry(PathEntry pathEntry) {
        if (null != pathEntry) {
            int i = 1;
            for (PathEntry entry : imagePaths.subList(1, imagePaths.size())) {
                if (entry != null && entry.equals(pathEntry)) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PathEntry getPathEntry(Object path, String folder) {
        PathEntry pathEntry = null;
        if (null == path) return pathEntry;
        if (path instanceof String) {
            return ImagePath.createPathEntry((String)path, folder);
        }
        if (path instanceof File) {
            return ImagePath.createPathEntry(((File)path).getAbsolutePath(), folder);
        }
        if (path instanceof URL) {
            if (folder == null) {
                return new PathEntry("__PATH_URL__", null, (URL)path);
            }
            ImagePath.log(-1, "getPathEntry: url + folder not implmented", new Object[0]);
            return null;
        }
        ImagePath.log(-1, "getPathEntry: invalid path: %s (String, File or URL", new Object[0]);
        return null;
    }

    private static int getPathEntryIndex(URL url) {
        PathEntry whereEntry = ImagePath.getPathEntry(url, null);
        return ImagePath.isPathEntry(whereEntry);
    }

    private static PathEntry createPathEntry(String mainPath, String altPathOrFolder) {
        if (mainPath == null || mainPath.isEmpty()) {
            return null;
        }
        if (mainPath.toLowerCase().endsWith(".jar")) {
            return ImagePath.createPathEntryJar(mainPath, altPathOrFolder);
        }
        if (mainPath.toLowerCase().startsWith("http://") || mainPath.toLowerCase().startsWith("https://")) {
            return ImagePath.createPathEntryHttp(mainPath, altPathOrFolder);
        }
        if (mainPath.indexOf(":") > 4) {
            String[] parts = mainPath.split(":");
            mainPath = "http://" + parts[0];
            if (parts.length > 1) {
                return ImagePath.createPathEntryHttp(mainPath + "/" + parts[1], altPathOrFolder);
            }
            return ImagePath.createPathEntryHttp(mainPath, altPathOrFolder);
        }
        URL pathURL = Commons.makeURL(mainPath, altPathOrFolder);
        if (pathURL == null) {
            return ImagePath.createPathEntryClass(mainPath, altPathOrFolder);
        }
        return new PathEntry(mainPath, altPathOrFolder, pathURL);
    }

    private static PathEntry createPathEntryJar(String jar, String folder) {
        if (".".equals(jar)) {
            jar = RunTime.get().fSxBaseJar.getAbsolutePath();
        }
        URL url = Commons.makeURL(jar, folder);
        PathEntry pathEntry = new PathEntry(jar, folder, url);
        return pathEntry;
    }

    private static PathEntry createPathEntryClass(String possibleClass, String altPath) {
        String klassName;
        URL pathURL = null;
        Class<?> cls = null;
        String fpSubPath = "";
        String subPath = null;
        int n = possibleClass.indexOf("/");
        if (n > 0) {
            klassName = possibleClass.substring(0, n);
            if (n + 1 < possibleClass.length()) {
                fpSubPath = possibleClass.substring(n + 1);
            }
        } else {
            klassName = possibleClass;
        }
        try {
            cls = Class.forName(klassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (cls != null) {
            CodeSource codeSrc = cls.getProtectionDomain().getCodeSource();
            if (codeSrc != null && codeSrc.getLocation() != null) {
                URL classURL = codeSrc.getLocation();
                pathURL = Commons.makeURL(classURL, fpSubPath);
            } else {
                cls = null;
            }
            if (cls == null) {
                ImagePath.log(3, "createPathEntryClass: class not found (%s) from path (%s)", klassName, possibleClass);
                pathURL = Commons.makeURL(altPath, fpSubPath);
                possibleClass = altPath;
                subPath = fpSubPath;
            }
        }
        return new PathEntry(possibleClass, subPath, pathURL);
    }

    private static PathEntry createPathEntryHttp(String netURL, String folder) {
        URL url = Commons.makeURL(netURL, folder);
        return new PathEntry(netURL, folder, url);
    }

    public static boolean add(String mainPath) {
        return ImagePath.add(mainPath, null);
    }

    public static boolean add(String mainPath, String altPathOrFolder) {
        return null != ImagePath.append((Object)mainPath, altPathOrFolder);
    }

    public static boolean remove(String path) {
        return ImagePath.remove(path, null);
    }

    public static boolean remove(String mainPath, String altPathOrFolder) {
        return null != ImagePath.remove((Object)mainPath, altPathOrFolder);
    }

    public static boolean addHTTP(String pathHTTP) {
        return null != ImagePath.append(ImagePath.makeNetURL(pathHTTP));
    }

    private static URL makeNetURL(String pathHTTP) {
        String proto = "http://";
        String protos = "https://";
        if (!pathHTTP.startsWith(proto) && !pathHTTP.startsWith(protos)) {
            pathHTTP = proto + pathHTTP;
        }
        return Commons.makeURL((Object)pathHTTP);
    }

    public static boolean removeHTTP(String pathHTTP) {
        return null != ImagePath.remove(ImagePath.makeNetURL(pathHTTP));
    }

    public static boolean addJar(String fpJar) {
        return ImagePath.addJar(fpJar, null);
    }

    public static boolean addJar(String fpJar, String fpImage) {
        if (!fpJar.endsWith(".jar") && !fpJar.contains(".jar!")) {
            fpJar = fpJar + ".jar";
        }
        return null != ImagePath.append((Object)fpJar, fpImage);
    }

    public static boolean removeJar(String fpJar) {
        return ImagePath.removeJar(fpJar, null);
    }

    public static boolean removeJar(String fpJar, String fpImage) {
        if (!fpJar.endsWith(".jar") && !fpJar.contains(".jar!")) {
            fpJar = fpJar + ".jar";
        }
        return ImagePath.remove(fpJar, null);
    }

    public static boolean add(URL pURL) {
        return null != ImagePath.append(pURL);
    }

    public static URL get(Object what) {
        return ImagePath.get(what, null);
    }

    public static URL get(Object what, String folder) {
        PathEntry whatEntry = ImagePath.getPathEntry(what, folder);
        return null != whatEntry ? whatEntry.pathURL : null;
    }

    public static boolean has(Object what) {
        return ImagePath.has(what, null);
    }

    public static boolean has(Object what, String folder) {
        return ImagePath.hasPathEntry(ImagePath.getPathEntry(what, folder));
    }

    public static URL insert(Object what) {
        return ImagePath.insert(what, null, null);
    }

    public static URL insert(Object what, String folder) {
        return ImagePath.insert(what, folder, null);
    }

    public static URL insert(Object what, URL where) {
        return ImagePath.insert(what, null, where);
    }

    public static URL insert(Object what, String folder, URL where) {
        URL url = null;
        PathEntry whatEntry = ImagePath.getPathEntry(what, folder);
        if (null != whatEntry && whatEntry.isValid()) {
            ImagePath.remove(ImagePath.isPathEntry(whatEntry));
            int pathEntryIndex = ImagePath.getPathEntryIndex(where);
            if (0 == pathEntryIndex) {
                pathEntryIndex = 1;
            }
            imagePaths.add(pathEntryIndex, whatEntry);
            url = whatEntry.pathURL;
        }
        return url;
    }

    public static URL append(Object what) {
        return ImagePath.append(what, null, null);
    }

    public static URL append(Object what, String folder) {
        return ImagePath.append(what, folder, null);
    }

    public static URL append(Object what, URL where) {
        return ImagePath.append(what, null, where);
    }

    public static URL append(Object what, String folder, URL where) {
        URL url = null;
        PathEntry whatEntry = ImagePath.getPathEntry(what, folder);
        if (null != whatEntry && whatEntry.isValid()) {
            ImagePath.remove(ImagePath.isPathEntry(whatEntry));
            int pathEntryIndex = ImagePath.getPathEntryIndex(where) + 1;
            if (1 == pathEntryIndex) {
                pathEntryIndex = imagePaths.size();
            }
            ImagePath.getPaths().add(pathEntryIndex, whatEntry);
            url = whatEntry.pathURL;
        }
        return url;
    }

    public static URL replace(Object what, URL where) {
        return ImagePath.replace(what, null, where);
    }

    public static URL replace(Object what, String folder, URL where) {
        int pathEntryIndex;
        URL url = null;
        PathEntry whatEntry = ImagePath.getPathEntry(what, folder);
        if (null != whatEntry && whatEntry.isValid() && 0 < (pathEntryIndex = ImagePath.getPathEntryIndex(where))) {
            Image.purge(ImagePath.getPaths().get(pathEntryIndex));
            ImagePath.getPaths().set(pathEntryIndex, whatEntry);
            url = whatEntry.pathURL;
        }
        return url;
    }

    public static URL remove(Object what) {
        return ImagePath.remove(ImagePath.isPathEntry(ImagePath.getPathEntry(what, null)));
    }

    public static URL remove(Object what, String folder) {
        return ImagePath.remove(ImagePath.isPathEntry(ImagePath.getPathEntry(what, folder)));
    }

    public static boolean hasBundlePath() {
        return ImagePath.getBundle() != null;
    }

    public static boolean setBundlePath(String newBundlePath) {
        if (newBundlePath == null && (newBundlePath = Settings.BundlePath) == null) {
            return false;
        }
        PathEntry entry = ImagePath.getPathEntry(newBundlePath, null);
        if (entry != null && entry.isValid()) {
            ImagePath.remove(ImagePath.isPathEntry(entry));
            ImagePath.setBundle(entry);
            Commons.bundlePathValid(entry);
            return true;
        }
        return false;
    }

    public static String getBundlePath() {
        if (!ImagePath.hasBundlePath() && !ImagePath.setBundlePath()) {
            return null;
        }
        return ImagePath.getBundle().getPath();
    }

    public static File setBundleFolder(File folder) {
        PathEntry entry = ImagePath.getPathEntry(folder, null);
        if (entry != null && entry.isValid()) {
            PathEntry oldBundle = ImagePath.getBundle();
            if (entry.equals(oldBundle)) {
                return folder;
            }
            Image.purge(oldBundle);
            ImagePath.setBundle(entry);
            ImagePath.log(3, "new BundlePath: %s", entry);
        }
        return null;
    }

    protected static PathEntry getBundle() {
        return imagePaths.get(0);
    }

    private static boolean isBundle(PathEntry pathEntry) {
        return ImagePath.getBundle() != null && ImagePath.getBundle().equals(pathEntry);
    }

    private static boolean bundleEquals(Object path) {
        if (ImagePath.hasBundlePath()) {
            return ImagePath.getBundle().equals(path);
        }
        return false;
    }

    private static boolean setBundlePath() {
        return ImagePath.setBundlePath(null);
    }

    private static void setBundle(PathEntry pathEntry) {
        imagePaths.set(0, pathEntry);
    }

    public static URL check(String name) {
        return ImagePath.find(Image.getValidImageFilename(name));
    }

    public static URL find(String imageFileName) {
        URL fURL = null;
        String proto = "";
        File imageFile = new File(imageFileName);
        if (imageFile.isAbsolute()) {
            if (imageFile.exists()) {
                fURL = Commons.makeURL(imageFile);
            } else {
                ImagePath.log(-1, "find: File does not exist: %s", imageFileName);
            }
            return fURL;
        }
        for (PathEntry entry : ImagePath.getPaths()) {
            URL url;
            if (entry == null || !entry.isValid()) continue;
            proto = entry.pathURL.getProtocol();
            if ("file".equals(proto)) {
                if (!new File(entry.getPath(), imageFileName).exists()) continue;
                return Commons.makeURL(entry.getPath(), imageFileName);
            }
            if (!"jar".equals(proto) && !proto.startsWith("http") || (url = Commons.makeURL(entry.getPath(), imageFileName)) == null) continue;
            int check = -1;
            if (proto.startsWith("http")) {
                check = FileManager.isUrlUseabel(url);
            } else {
                try {
                    InputStream inputStream = url.openStream();
                    check = inputStream.available();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (check <= 0) continue;
            return url;
        }
        ImagePath.log(-1, "find: not there: %s", imageFileName);
        ImagePath.dump(3);
        return fURL;
    }

    public static BufferedReader open(String fname) {
        ImagePath.log(3, "open: " + fname, new Object[0]);
        URL furl = ImagePath.find(fname);
        if (furl != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(furl.openStream()));
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                return null;
            }
            try {
                br.mark(10);
                if (br.read() < 0) {
                    br.close();
                    return null;
                }
                br.reset();
                return br;
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                try {
                    br.close();
                }
                catch (IOException ex1) {
                    ImagePath.log(-1, "open: %s", ex1.getMessage());
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isImageBundled(URL fURL) {
        if ("file".equals(fURL.getProtocol())) {
            return ImagePath.bundleEquals(new File(fURL.getPath()).getParent());
        }
        return false;
    }

    static {
        imagePaths.add(null);
    }

    public static class PathEntry {
        private URL pathURL = null;
        private String path = null;

        private PathEntry(String main, String sub, URL eqivalentURL) {
            if (main == null) {
                main = "";
            }
            if (sub == null) {
                sub = "";
            }
            this.path = main + (sub.isEmpty() ? sub : "+" + sub);
            this.pathURL = eqivalentURL;
            ImagePath.log(4, "ImagePathEntry: %s (%s)", new Object[]{this.pathURL, this.path});
        }

        public boolean equals(Object other) {
            if (this.pathURL == null) {
                return false;
            }
            if (other instanceof PathEntry) {
                return this.pathURL.toExternalForm().equals(((PathEntry)other).pathURL.toExternalForm());
            }
            if (other instanceof URL) {
                return this.pathURL.toExternalForm().equals(((URL)other).toExternalForm());
            }
            if (other instanceof String || other instanceof File) {
                if (this.isFile() || this.isJar()) {
                    return this.pathURL.toExternalForm().equals(ImagePath.getPathEntry((Object)other, null).pathURL.toExternalForm());
                }
                return false;
            }
            return false;
        }

        public String toString() {
            return this.getPath();
        }

        public boolean isValid() {
            return this.pathURL != null;
        }

        public boolean isFile() {
            if (this.pathURL == null) {
                return false;
            }
            return "file".equals(this.pathURL.getProtocol());
        }

        public boolean isJar() {
            if (this.pathURL == null) {
                return false;
            }
            return "jar".equals(this.pathURL.getProtocol());
        }

        public boolean isHTTP() {
            if (this.pathURL == null) {
                return false;
            }
            return this.pathURL.getProtocol().startsWith("http");
        }

        public String getPath() {
            String path = "--invalid--";
            if (this.isValid()) {
                if (this.isHTTP()) {
                    return this.pathURL.toExternalForm();
                }
                File file = this.getFile();
                if (file != null) {
                    return file.getPath();
                }
            }
            return path;
        }

        public File getFile() {
            if (this.isValid()) {
                return Commons.urlToFile(this.pathURL);
            }
            return null;
        }

        public URL getURL() {
            return this.pathURL;
        }
    }
}

