/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Element;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.Match;
import org.sikuli.script.OCR;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.SX;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.IScreen;
import org.sikuli.script.support.RunTime;

public class Finder
implements Iterator<Match> {
    private Region _region = null;
    private Pattern _pattern = null;
    private Image _image = null;
    private FindInput2 _findInput = new FindInput2();
    private FindResult2 _results = null;
    private Region where = null;
    private int currentMatchIndex;
    private boolean repeating = false;
    private boolean valid = true;
    private boolean screenFinder = true;
    private static String me = "Finder: ";
    private static int lvl = 3;
    static final int PIXEL_DIFF_THRESHOLD_DEFAULT = 3;
    static final int IMAGE_DIFF_THRESHOLD_DEFAULT = 5;
    static int PIXEL_DIFF_THRESHOLD = 3;
    static int IMAGE_DIFF_THRESHOLD = 5;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    protected Finder() {
        this.resetFindChanges();
    }

    public <RIBS> Finder(RIBS inWhat) {
        if (inWhat instanceof Region) {
            this.where = (Region)inWhat;
        } else if (inWhat instanceof Image) {
            this._findInput.setSource(Finder2.makeMat(((Image)inWhat).get()));
        } else if (inWhat instanceof String) {
            this._findInput.setSource(Finder2.makeMat(Image.create((String)inWhat).get()));
        } else if (inWhat instanceof BufferedImage) {
            this._findInput.setSource(Finder2.makeMat((BufferedImage)inWhat));
        } else if (inWhat instanceof ScreenImage) {
            this.initScreenFinder((ScreenImage)inWhat, null);
        } else {
            throw new IllegalArgumentException(String.format("Finder: not possible with: %s", inWhat));
        }
        this.resetFindChanges();
    }

    public Finder(ScreenImage simg, Region region) {
        this.initScreenFinder(simg, region);
    }

    private void initScreenFinder(ScreenImage simg, Region region) {
        this.setScreenImage(simg);
        this._region = region;
        this.resetFindChanges();
    }

    protected void setScreenImage(ScreenImage simg) {
        this._findInput.setSource(Finder2.makeMat(simg.getImage()));
    }

    protected void setRepeating() {
        this.repeating = true;
    }

    protected void findRepeat() {
        this._results = Finder2.find(this._findInput);
        this.currentMatchIndex = 0;
    }

    protected void findAllRepeat() {
        Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
        this._results = Finder2.find(this._findInput);
        this.currentMatchIndex = 0;
        timing.end();
    }

    public String find(String imageOrText) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        Image img = Image.create(imageOrText);
        if (img.isText()) {
            return this.findText(imageOrText);
        }
        if (img.isValid()) {
            return this.find(img);
        }
        return null;
    }

    private Mat possibleImageResizeOrCallback(Image img) {
        return this.possibleImageResizeOrCallback(img, 0.0f);
    }

    private Mat possibleImageResizeOrCallback(Image img, float oneTimeResize) {
        float factor = oneTimeResize;
        if (factor == 0.0f && Settings.AlwaysResize > 0.0f && Settings.AlwaysResize != 1.0f) {
            factor = Settings.AlwaysResize;
        }
        Mat mat = Finder2.makeMat(img.get(), false);
        if (factor > 0.0f && factor != 1.0f) {
            Debug.log(3, "Finder::possibleImageResizeOrCallback: resize", new Object[0]);
            if (!mat.empty()) {
                Image.resize(mat, factor);
            }
        } else if (Settings.ImageCallback != null) {
            Debug.log(3, "Finder::possibleImageResizeOrCallback: callback", new Object[0]);
            BufferedImage newBimg = Settings.ImageCallback.callback(img);
            mat = Finder2.makeMat(newBimg, false);
        }
        if (mat.empty()) {
            Finder.log(-1, "%s: conversion error --- find will fail", img);
        }
        return mat;
    }

    public String find(Pattern aPtn) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (aPtn.isValid()) {
            this._pattern = aPtn;
            if (this._pattern.hasMask()) {
                this._findInput.setMask(this._pattern.getMask());
            }
            this._image = aPtn.getImage();
            this._findInput.setTarget(this.possibleImageResizeOrCallback(this._image, aPtn.getResize()));
            this._findInput.setSimilarity(aPtn.getSimilar());
            this._findInput.setIsPattern();
            this._results = Finder2.find(this._findInput);
            this.currentMatchIndex = 0;
            return aPtn.getFilename();
        }
        return null;
    }

    public String find(Image img) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (img.isValid()) {
            this._image = img;
            this._findInput.setTarget(this.possibleImageResizeOrCallback(img));
            this._findInput.setSimilarity(Settings.MinSimilarity);
            this._results = Finder2.find(this._findInput);
            this.currentMatchIndex = 0;
            return img.getFilename();
        }
        if (img.isUseable()) {
            return this.find(new Pattern(img));
        }
        return null;
    }

    public String find(BufferedImage img) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        return this.find(new Image(img));
    }

    public List<Region> findChanges(Object changedImage) {
        if (SX.isNull(changedImage)) {
            return null;
        }
        if (changedImage instanceof String) {
            Image img = Image.create((String)changedImage);
            this._findInput.setTarget(this.possibleImageResizeOrCallback(img));
        } else if (changedImage instanceof ScreenImage) {
            Image img = new Image((ScreenImage)changedImage);
            this._findInput.setTarget(this.possibleImageResizeOrCallback(img));
        }
        return Finder2.findChanges(this._findInput);
    }

    public String findAll(String imageOrText) {
        Image img;
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._image = img = Image.create(imageOrText);
        if (img.isText()) {
            return this.findAllText(imageOrText);
        }
        if (img.isValid()) {
            return this.findAll(img);
        }
        return null;
    }

    public String findAll(Pattern aPtn) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (aPtn.isValid()) {
            this._pattern = aPtn;
            this._image = aPtn.getImage();
            this._findInput.setTarget(this.possibleImageResizeOrCallback(this._image, aPtn.getResize()));
            this._findInput.setSimilarity(aPtn.getSimilar());
            this._findInput.setIsPattern();
            this._findInput.setFindAll();
            if (this._pattern.hasMask()) {
                this._findInput.setMask(this._pattern.getMask());
            }
            Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
            this._results = Finder2.find(this._findInput);
            this.currentMatchIndex = 0;
            timing.end();
            return aPtn.getFilename();
        }
        return null;
    }

    public String findAll(Image img) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        if (img.isValid()) {
            this._image = img;
            this._findInput.setTarget(this.possibleImageResizeOrCallback(img));
            this._findInput.setSimilarity(Settings.MinSimilarity);
            this._findInput.setFindAll();
            Debug timing = Debug.startTimer("Finder.findAll", new Object[0]);
            this._results = Finder2.find(this._findInput);
            this.currentMatchIndex = 0;
            timing.end();
            return img.getFilename();
        }
        return null;
    }

    public String findText(String text) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._findInput.setTargetText(text);
        this._findInput.setWhere(this.where);
        this._results = Finder2.find(this._findInput);
        this.currentMatchIndex = 0;
        return text;
    }

    public boolean findWord(String text) {
        this._findInput.setTextLevel(3);
        this.findText(text);
        return this.hasNext();
    }

    public boolean findWords(String text) {
        this._findInput.setTextLevel(3);
        this._findInput.setFindAll();
        this.findText(text);
        return this.hasNext();
    }

    public boolean findWords() {
        this._findInput.setTextLevel(3);
        this._findInput.setFindAll();
        this.findText("");
        return this.hasNext();
    }

    public boolean findLine(String text) {
        this._findInput.setTextLevel(2);
        this.findText(text);
        return this.hasNext();
    }

    public boolean findLines(String text) {
        this._findInput.setTextLevel(2);
        this._findInput.setFindAll();
        this.findText(text);
        return this.hasNext();
    }

    public boolean findLines() {
        this._findInput.setTextLevel(2);
        this._findInput.setFindAll();
        this.findText("");
        return this.hasNext();
    }

    public String findAllText(String text) {
        if (!this.valid) {
            Finder.log(-1, "not valid", new Object[0]);
            return null;
        }
        this._findInput.setFindAll();
        return this.findText(text);
    }

    public List<Match> getList() {
        ArrayList<Match> matches = new ArrayList<Match>();
        while (this.hasNext()) {
            matches.add(this.next());
        }
        return matches;
    }

    public <RI> List<Match> getListFor(RI what) {
        ArrayList<Match> matches = new ArrayList<Match>();
        if (what instanceof Element) {
            while (this.hasNext()) {
                matches.add(((Element)what).relocate(this.next()));
            }
        }
        return matches;
    }

    @Override
    public boolean hasNext() {
        return this._results != null && this._results.hasNext();
    }

    @Override
    public Match next() {
        Match match = null;
        if (this.hasNext()) {
            match = this._results.next();
            if (!this._findInput.isText() && this._region != null) {
                match.x += this._region.x;
                match.y += this._region.y;
            }
            IScreen parentScreen = null;
            if (this.screenFinder && this._region != null) {
                parentScreen = this._region.getScreen();
                match = Match.create(match, parentScreen);
            }
            if (this._pattern != null) {
                Location offset = this._pattern.getTargetOffset();
                match.setTargetOffset(offset);
            }
            match.setOnScreen(this.screenFinder);
            match.setImage(this._image);
        }
        return match;
    }

    @Override
    public void remove() {
        this.destroy();
    }

    public void destroy() {
        this._findInput = null;
        this._results = null;
        this._pattern = null;
    }

    public void resetFindChanges() {
        PIXEL_DIFF_THRESHOLD = 3;
        IMAGE_DIFF_THRESHOLD = 5;
    }

    public void setFindChangesPixelDiff(int value) {
        PIXEL_DIFF_THRESHOLD = value;
    }

    public void setFindChangesImageDiff(int value) {
        IMAGE_DIFF_THRESHOLD = value;
    }

    private static class FindResult2
    implements Iterator<Match> {
        private FindInput2 findInput = null;
        private int offX = 0;
        private int offY = 0;
        private Mat result = null;
        private List<Match> matches = new ArrayList<Match>();
        private Core.MinMaxLocResult resultMinMax = null;
        private double currentScore = -1.0;
        double targetScore = -1.0;
        double lastScore = -1.0;
        double scoreMeanDiff = -1.0;
        double scoreMaxDiff = 0.005;
        int matchCount = 0;
        private int currentX = -1;
        private int currentY = -1;
        private int baseW = -1;
        private int baseH = -1;
        private int targetW = -1;
        private int targetH = -1;
        private int marginX = -1;
        private int marginY = -1;
        double bestScore = 0.0;
        double meanScore = 0.0;
        double stdDevScore = 0.0;

        private FindResult2() {
        }

        public FindResult2(List<Match> matches, FindInput2 findInput) {
            this.matches = matches;
            this.findInput = findInput;
        }

        public FindResult2(Mat result, FindInput2 findInput) {
            this.result = result;
            this.findInput = findInput;
        }

        public FindResult2(Mat result, FindInput2 target, int[] off) {
            this(result, target);
            this.offX = off[0];
            this.offY = off[1];
        }

        @Override
        public boolean hasNext() {
            if (this.findInput.isText()) {
                return this.matches.size() > 0;
            }
            this.resultMinMax = Core.minMaxLoc((Mat)this.result);
            this.currentScore = this.resultMinMax.maxVal;
            this.currentX = (int)this.resultMinMax.maxLoc.x;
            this.currentY = (int)this.resultMinMax.maxLoc.y;
            if (this.lastScore < 0.0) {
                this.lastScore = this.currentScore;
                this.targetScore = this.findInput.getScore();
                this.baseW = this.result.width();
                this.baseH = this.result.height();
                this.targetW = this.findInput.getTarget().width();
                this.targetH = this.findInput.getTarget().height();
                this.marginX = (int)((double)this.targetW * 0.8);
                this.marginY = (int)((double)this.targetH * 0.8);
                this.matchCount = 0;
            }
            boolean isMatch = false;
            if (this.currentScore > this.targetScore) {
                if (this.matchCount == 0) {
                    isMatch = true;
                } else if (this.matchCount == 1) {
                    this.scoreMeanDiff = this.lastScore - this.currentScore;
                    isMatch = true;
                } else {
                    double scoreDiff = this.lastScore - this.currentScore;
                    if (this.findInput.isPattern || scoreDiff <= this.scoreMeanDiff + 0.01) {
                        this.scoreMeanDiff = (this.scoreMeanDiff * (double)this.matchCount + scoreDiff) / (double)(this.matchCount + 1);
                        isMatch = true;
                    }
                }
                if (!isMatch) {
                    Debug.log(3, "findAll: (%d) stop: %.4f (%.4f) %s", this.matchCount, this.currentScore, this.scoreMeanDiff, this.findInput);
                }
            }
            return isMatch;
        }

        @Override
        public Match next() {
            Match match = null;
            if (this.hasNext()) {
                if (this.findInput.isText()) {
                    return this.matches.remove(0);
                }
                match = new Match(this.currentX + this.offX, this.currentY + this.offY, this.targetW, this.targetH, this.currentScore, null);
                ++this.matchCount;
                this.lastScore = this.currentScore;
                Range rangeX = new Range(Math.max(this.currentX - this.marginX, 0), Math.min(this.currentX + this.marginX, this.result.width()));
                Range rangeY = new Range(Math.max(this.currentY - this.marginY, 0), Math.min(this.currentY + this.marginY, this.result.height()));
                this.result.colRange(rangeX).rowRange(rangeY).setTo(new Scalar(0.0));
            }
            return match;
        }

        private int getPurgeMargin() {
            if (this.currentScore < 0.95) {
                return 4;
            }
            if (this.currentScore < 0.85) {
                return 8;
            }
            if (this.currentScore < 0.71) {
                return 16;
            }
            return 2;
        }

        public List<Match> getMatches() {
            if (this.hasNext()) {
                Match match;
                ArrayList<Match> matches = new ArrayList<Match>();
                ArrayList<Double> scores = new ArrayList<Double>();
                while (!SX.isNull(match = this.next())) {
                    this.meanScore = (this.meanScore * (double)matches.size() + match.getScore()) / (double)(matches.size() + 1);
                    this.bestScore = Math.max(this.bestScore, match.getScore());
                    matches.add(match);
                    scores.add(match.getScore());
                }
                this.stdDevScore = this.calcStdDev(scores, this.meanScore);
                return matches;
            }
            return null;
        }

        public double[] getScores() {
            return new double[]{this.bestScore, this.meanScore, this.stdDevScore};
        }

        private double calcStdDev(List<Double> doubles, double mean) {
            double stdDev = 0.0;
            for (double doubleVal : doubles) {
                stdDev += (doubleVal - mean) * (doubleVal - mean);
            }
            return Math.sqrt(stdDev / (double)doubles.size());
        }

        @Override
        public void remove() {
        }
    }

    private static class FindInput2 {
        private Mat mask = new Mat();
        private Mat targetBGR = new Mat();
        private Region where = null;
        private Image image = null;
        private double similarity = 0.7;
        private boolean findAll = false;
        private Mat target = null;
        private String targetText = "";
        private boolean targetTypeText = false;
        private int textLevel = -1;
        private boolean textRegex = false;
        private Mat source = null;
        boolean isPattern = false;
        private double scoreMaxDiff = 0.05;
        protected boolean plainColor = false;
        protected boolean blackColor = false;
        protected boolean whiteColor = false;
        protected boolean grayColor = false;
        protected double resizeFactor;
        private final int resizeMinDownSample = 12;
        private int[] meanColor = null;
        private double minThreshhold = 1.0E-5;
        double targetStdDev = -1.0;
        double targetMean = -1.0;

        private FindInput2() {
        }

        protected boolean hasMask() {
            return !this.mask.empty();
        }

        protected Mat getMask() {
            return this.mask;
        }

        protected void setMask(Mat mask) {
            this.mask = mask;
        }

        public void setWhere(Region where) {
            this.where = where;
        }

        public Region getWhere() {
            return this.where;
        }

        public BufferedImage getImage() {
            if (this.where != null) {
                return this.where.getScreen().capture(this.where).getImage();
            }
            if (this.source != null) {
                return Finder2.getBufferedImage(this.source);
            }
            if (this.image != null) {
                return this.image.get();
            }
            return null;
        }

        public void setTarget(Mat target) {
            this.target = target;
        }

        public Mat getTarget() {
            if (this.targetBGR.empty()) {
                return this.target;
            }
            return this.targetBGR;
        }

        public void setTargetText(String text) {
            this.targetText = text;
            this.targetTypeText = true;
        }

        public String getTargetText() {
            return this.targetText;
        }

        public boolean isValid() {
            if (SX.isNull(this.source) && SX.isNull(this.where)) {
                return false;
            }
            if (SX.isNotNull(this.target) && !this.targetTypeText) {
                if (this.target.empty()) {
                    throw new SikuliXception("Finder::isValid: image to search is empty");
                }
                if (this.source.width() < this.target.width() || this.source.height() < this.target.height()) {
                    throw new SikuliXception(String.format("image to search (%d, %d) is larger than image to search in (%d, %d)", this.target.width(), this.target.height(), this.source.width(), this.source.height()));
                }
                return true;
            }
            return this.targetTypeText && !this.targetText.isEmpty();
        }

        public int getTextLevel() {
            return this.textLevel;
        }

        public void setTextLevel(int textLevel) {
            this.textLevel = textLevel;
        }

        public boolean isText() {
            return this.targetTypeText;
        }

        public void textAsRegEx() {
            this.textRegex = true;
        }

        public boolean isTextRegEx() {
            return this.textRegex;
        }

        public java.util.regex.Pattern getRegEx() {
            return java.util.regex.Pattern.compile(this.targetText);
        }

        public boolean isFindAll() {
            return this.findAll;
        }

        public void setSource(Mat source) {
            this.source = source;
        }

        public Mat getBase() {
            return this.source;
        }

        public void setIsPattern() {
            this.isPattern = true;
        }

        public boolean isPattern() {
            return this.isPattern;
        }

        public void setPattern(boolean pattern) {
            this.isPattern = pattern;
        }

        public void setSimilarity(double similarity) {
            this.similarity = similarity;
        }

        public boolean isExact() {
            return this.similarity >= 0.99;
        }

        public boolean shouldSearchDownsized(float resizeMinFactor) {
            return !this.hasMask() && !this.isExact() && !this.isFindAll() && this.getResizeFactor() > (double)resizeMinFactor;
        }

        protected double getScoreMaxDiff() {
            return this.scoreMaxDiff;
        }

        protected double getScore() {
            return this.similarity;
        }

        public void setFindAll() {
            this.findAll = true;
        }

        public boolean isPlainColor() {
            return this.isValid() && this.plainColor;
        }

        public boolean isBlack() {
            return this.isValid() && this.blackColor;
        }

        public boolean isGray() {
            return this.isValid() && this.grayColor;
        }

        public boolean isWhite() {
            return this.isValid() && this.blackColor;
        }

        public double getResizeFactor() {
            return this.isValid() ? this.resizeFactor : 1.0;
        }

        public Color getMeanColor() {
            return new Color(this.meanColor[2], this.meanColor[1], this.meanColor[0]);
        }

        public boolean isMeanColorEqual(Color otherMeanColor) {
            int b;
            int g;
            Color col = this.getMeanColor();
            int r = (col.getRed() - otherMeanColor.getRed()) * (col.getRed() - otherMeanColor.getRed());
            return Math.sqrt(r + (g = (col.getGreen() - otherMeanColor.getGreen()) * (col.getGreen() - otherMeanColor.getGreen())) + (b = (col.getBlue() - otherMeanColor.getBlue()) * (col.getBlue() - otherMeanColor.getBlue()))) < this.minThreshhold;
        }

        public void setAttributes() {
            int i;
            if (this.targetTypeText) {
                return;
            }
            List<Mat> mats = Finder2.extractMask(this.target, true);
            this.targetBGR = mats.get(0);
            if (this.mask.empty()) {
                this.mask = mats.get(1);
            }
            if (this.targetBGR.channels() == 1) {
                this.grayColor = true;
            }
            this.plainColor = false;
            this.blackColor = false;
            this.resizeFactor = Math.min((double)this.targetBGR.width() / 12.0, (double)this.targetBGR.height() / 12.0);
            this.resizeFactor = Math.max(1.0, this.resizeFactor);
            MatOfDouble pMean = new MatOfDouble();
            MatOfDouble pStdDev = new MatOfDouble();
            if (this.mask.empty()) {
                Core.meanStdDev((Mat)this.targetBGR, (MatOfDouble)pMean, (MatOfDouble)pStdDev);
            } else {
                ArrayList maskMats = new ArrayList();
                Core.split((Mat)this.mask, maskMats);
                Core.meanStdDev((Mat)this.targetBGR, (MatOfDouble)pMean, (MatOfDouble)pStdDev, (Mat)((Mat)maskMats.get(0)));
            }
            double sum = 0.0;
            double[] arr = pStdDev.toArray();
            for (i = 0; i < arr.length; ++i) {
                sum += arr[i];
            }
            this.targetStdDev = sum;
            if (sum < this.minThreshhold) {
                this.plainColor = true;
            }
            sum = 0.0;
            arr = pMean.toArray();
            this.meanColor = new int[arr.length];
            for (i = 0; i < arr.length; ++i) {
                this.meanColor[i] = (int)arr[i];
                sum += arr[i];
            }
            this.targetMean = sum;
            if (sum < this.minThreshhold && this.plainColor) {
                this.blackColor = true;
            }
            if (this.meanColor.length > 1) {
                this.whiteColor = this.isMeanColorEqual(Color.WHITE);
            }
        }

        public String toString() {
            return String.format("(stdDev: %.4f mean: %4f)", this.targetStdDev, this.targetMean);
        }

        static {
            Finder2.init();
        }
    }

    protected static class Finder2 {
        private static Log log;
        private Mat mBase = Finder2.getNewMat();
        private Mat mResult = Finder2.getNewMat();
        private FindInput2 fInput = null;
        private final float resizeMinFactor = 1.5f;
        private final float[] resizeLevels = new float[]{1.0f, 0.4f};
        private boolean isCheckLastSeen = false;
        private static final double downSimDiff = 0.15;
        private static int toGray;
        private static int toColor;
        private static int gray;
        private static int colored;
        private static int transparent;
        protected static final String PNG = "png";
        protected static final String dotPNG = ".png";

        protected static void init() {
        }

        private Finder2() {
        }

        public boolean isValid() {
            return !this.mBase.empty();
        }

        protected static FindResult2 find(FindInput2 findInput) {
            findInput.setAttributes();
            Finder2 finder2 = new Finder2();
            finder2.fInput = findInput;
            FindResult2 results = finder2.doFind();
            return results;
        }

        private boolean isWord() {
            return this.fInput.getTextLevel() == 3;
        }

        private boolean isLine() {
            return this.fInput.getTextLevel() == 2;
        }

        private boolean isTextMatching(String base, String probe, java.util.regex.Pattern pattern) {
            if (SX.isNull(pattern)) {
                return base.equals(probe);
            }
            Matcher matcher = pattern.matcher(base.trim());
            return matcher.find();
        }

        private boolean isTextContained(String base, String probe, java.util.regex.Pattern pattern) {
            if (SX.isNull(pattern)) {
                return base.contains(probe);
            }
            Matcher matcher = pattern.matcher(base);
            return matcher.find();
        }

        private FindResult2 doFind() {
            if (!this.fInput.isValid()) {
                return null;
            }
            if (this.fInput.isText()) {
                return this.doFindText();
            }
            return this.doFindImage();
        }

        private FindResult2 doFindImage() {
            FindResult2 findResult = null;
            FindInput2 findInput = this.fInput;
            Log.trace("doFindImage: start %s", findInput);
            this.mBase = findInput.getBase();
            boolean success = false;
            long begin_lap = 0L;
            long begin_find = new Date().getTime();
            Core.MinMaxLocResult mMinMax = null;
            double rfactor = 0.0;
            boolean downSizeFound = false;
            double downSizeScore = -1.0;
            double downSizeWantedScore = 0.0;
            Mat findWhere = Finder2.getNewMat();
            Mat findWhat = Finder2.getNewMat();
            boolean trueOrFalse = findInput.shouldSearchDownsized(1.5f);
            trueOrFalse = false;
            if (trueOrFalse) {
                begin_lap = new Date().getTime();
                double imgFactor = findInput.getResizeFactor();
                this.mResult = null;
                float[] fArray = this.resizeLevels;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    double factor = fArray[i];
                    rfactor = factor * imgFactor;
                    Size sizeBase = new Size((double)this.mBase.cols() / rfactor, (double)this.mBase.rows() / rfactor);
                    Size sizePattern = new Size((double)findInput.getTarget().cols() / rfactor, (double)findInput.getTarget().rows() / rfactor);
                    Imgproc.resize((Mat)this.mBase, (Mat)findWhere, (Size)sizeBase, (double)0.0, (double)0.0, (int)3);
                    Imgproc.resize((Mat)findInput.getTarget(), (Mat)findWhat, (Size)sizePattern, (double)0.0, (double)0.0, (int)3);
                    this.mResult = this.doFindMatch(findWhat, findWhere, findInput);
                    mMinMax = Core.minMaxLoc((Mat)this.mResult);
                    downSizeWantedScore = (double)((int)((findInput.getScore() - 0.15) * 100.0)) / 100.0;
                    downSizeScore = mMinMax.maxVal;
                    if (!(downSizeScore > downSizeWantedScore)) continue;
                    downSizeFound = true;
                    break;
                }
                Log.trace("downSizeFound: %s", downSizeFound);
                Log.trace("doFindImage: down: %%%.2f %d msec", 100.0 * mMinMax.maxVal, new Date().getTime() - begin_lap);
            }
            findWhere = this.mBase;
            boolean bl = trueOrFalse = !findInput.isFindAll() && downSizeFound;
            if (trueOrFalse) {
                if (findWhere.size().equals((Object)findInput.getTarget().size())) {
                    return new FindResult2(this.mResult, findInput);
                }
                int maxLocX = (int)(mMinMax.maxLoc.x * rfactor);
                int maxLocY = (int)(mMinMax.maxLoc.y * rfactor);
                begin_lap = new Date().getTime();
                int margin = (int)findInput.getResizeFactor() + 1;
                Rectangle rSub = new Rectangle(Math.max(0, maxLocX - margin), Math.max(0, maxLocY - margin), Math.min(findInput.getTarget().width() + 2 * margin, findWhere.width()), Math.min(findInput.getTarget().height() + 2 * margin, findWhere.height()));
                Rectangle rWhere = new Rectangle(0, 0, findWhere.cols(), findWhere.rows());
                Rectangle rSubNew = rWhere.intersection(rSub);
                Rect rectSub = new Rect(rSubNew.x, rSubNew.y, rSubNew.width, rSubNew.height);
                this.mResult = this.doFindMatch(findInput.getTarget(), findWhere.submat(rectSub), findInput);
                mMinMax = Core.minMaxLoc((Mat)this.mResult);
                double maxVal = mMinMax.maxVal;
                double wantedScore = findInput.getScore();
                if (maxVal > wantedScore) {
                    findResult = new FindResult2(this.mResult, findInput, new int[]{rectSub.x, rectSub.y});
                }
                if (SX.isNotNull(findResult)) {
                    Log.trace("doFindImage after down: %%%.2f(?%%%.2f) %d msec", maxVal * 100.0, wantedScore * 100.0, new Date().getTime() - begin_lap);
                }
            }
            if (downSizeScore < 0.0) {
                begin_lap = new Date().getTime();
                this.mResult = this.doFindMatch(findInput.getTarget(), findWhere, findInput);
                mMinMax = Core.minMaxLoc((Mat)this.mResult);
                if (!this.isCheckLastSeen) {
                    Log.trace("doFindImage: in original: %%%.4f (?%.0f) %d msec %s", mMinMax.maxVal * 100.0, findInput.getScore() * 100.0, new Date().getTime() - begin_lap, findInput.hasMask() ? " **withMask" : "");
                }
                if (mMinMax.maxVal > findInput.getScore()) {
                    findResult = new FindResult2(this.mResult, findInput);
                }
            }
            Log.trace("doFindImage: end %d msec", new Date().getTime() - begin_find);
            return findResult;
        }

        private Mat doFindMatch(Mat what, Mat where, FindInput2 findInput) {
            Mat mResult = Finder2.getNewMat();
            if (what.empty()) {
                Log.error("doFindMatch: image conversion to cvMat did not work", new Object[0]);
            } else {
                Mat mWhere = where;
                if (findInput.isGray()) {
                    Imgproc.cvtColor((Mat)where, (Mat)mWhere, (int)6);
                }
                if (!findInput.isPlainColor()) {
                    if (findInput.hasMask()) {
                        Mat mask = findInput.getMask();
                        Imgproc.matchTemplate((Mat)mWhere, (Mat)what, (Mat)mResult, (int)3, (Mat)mask);
                    } else {
                        Imgproc.matchTemplate((Mat)mWhere, (Mat)what, (Mat)mResult, (int)5);
                    }
                } else {
                    Mat wherePlain = mWhere;
                    Mat whatPlain = what;
                    if (findInput.isBlack()) {
                        Core.bitwise_not((Mat)mWhere, (Mat)wherePlain);
                        Core.bitwise_not((Mat)what, (Mat)whatPlain);
                    }
                    if (findInput.hasMask()) {
                        Imgproc.matchTemplate((Mat)wherePlain, (Mat)what, (Mat)mResult, (int)1, (Mat)findInput.getMask());
                    } else {
                        Imgproc.matchTemplate((Mat)wherePlain, (Mat)whatPlain, (Mat)mResult, (int)1);
                    }
                    Core.subtract((Mat)Mat.ones((Size)mResult.size(), (int)5), (Mat)mResult, (Mat)mResult);
                }
            }
            return mResult;
        }

        private FindResult2 doFindText() {
            List<Match> wordsFound;
            FindResult2 findResult = null;
            Region where = this.fInput.getWhere();
            String text = this.fInput.getTargetText();
            boolean globalSearch = false;
            boolean singleWord = true;
            String[] textSplit = new String[]{};
            java.util.regex.Pattern pattern = null;
            int textLevel = this.fInput.getTextLevel();
            long timer = new Date().getTime();
            BufferedImage bimg = this.fInput.getImage();
            if (this.fInput.isTextRegEx()) {
                pattern = this.fInput.getRegEx();
            } else {
                text = text.trim();
            }
            if (textLevel == 2) {
                wordsFound = OCR.readLines(bimg);
            } else if (textLevel == 3) {
                wordsFound = OCR.readWords(bimg);
            } else {
                globalSearch = true;
                textSplit = text.split("\\s");
                if (textSplit.length > 1) {
                    singleWord = false;
                    if (textSplit.length == 3 && textSplit[1].contains("+")) {
                        pattern = java.util.regex.Pattern.compile(textSplit[0] + ".*?" + textSplit[2]);
                    }
                }
                wordsFound = OCR.readLines(bimg);
            }
            timer = new Date().getTime() - timer;
            ArrayList<Match> wordsMatch = new ArrayList<Match>();
            if (!text.isEmpty()) {
                for (Match match : wordsFound) {
                    if (this.isWord() ? !this.isTextMatching(match.getText(), text, pattern) : (this.isLine() ? !this.isTextContained(match.getText(), text, pattern) : !globalSearch || !this.isTextContained(match.getText().toLowerCase(), text.toLowerCase(), pattern))) continue;
                    Rectangle wordOrLine = match.getRect();
                    if (globalSearch) {
                        BufferedImage bLine = Image.createSubimage(bimg, wordOrLine);
                        List<Match> wordsInLine = OCR.readWords(bLine);
                        if (singleWord) {
                            for (Match wordInLine : wordsInLine) {
                                if (!this.isTextContained(wordInLine.getText().toLowerCase(), text.toLowerCase(), null)) continue;
                                Rectangle rword = new Rectangle(wordInLine.getRect());
                                rword.x += wordOrLine.x;
                                rword.y += wordOrLine.y;
                                wordsMatch.add(new Match(rword, wordInLine.getScore(), wordInLine.getText(), where));
                            }
                            continue;
                        }
                        int startText = -1;
                        int endText = -1;
                        int ix = 0;
                        String firstWord = textSplit[0].toLowerCase();
                        String lastWord = textSplit[textSplit.length - 1].toLowerCase();
                        for (Match wordInLine : wordsInLine) {
                            if (startText < 0) {
                                if (this.isTextContained(wordInLine.getText().toLowerCase(), firstWord, null)) {
                                    startText = ix;
                                }
                            } else {
                                if (endText >= 0) break;
                                if (this.isTextContained(wordInLine.getText().toLowerCase(), lastWord, null)) {
                                    endText = ix;
                                }
                            }
                            ++ix;
                        }
                        if (startText <= -1 || endText <= -1) continue;
                        Rectangle rword = new Rectangle(wordsInLine.get(startText).getRect()).union(new Rectangle(wordsInLine.get(endText).getRect()));
                        rword.x += wordOrLine.x;
                        rword.y += wordOrLine.y;
                        double score = (wordsInLine.get(startText).getScore() + wordsInLine.get(startText).getScore()) / 2.0;
                        String foundText = wordsInLine.get(startText).getText() + " ... " + wordsInLine.get(endText);
                        wordsMatch.add(new Match(rword, score, foundText, where));
                        continue;
                    }
                    wordsMatch.add(new Match(match.getRect(), match.getScore(), match.getText(), where));
                }
                if (wordsMatch.size() > 0) {
                    Log.trace("doFindText: %s found: %d times (%d msec) ", text, wordsMatch.size(), timer);
                    findResult = new FindResult2(wordsMatch, this.fInput);
                } else {
                    Log.trace("doFindText: %s (%d msec): not found", text, timer);
                }
            } else {
                if (this.isWord()) {
                    Log.trace("doFindText: listWords: %d words (%d msec) ", wordsFound.size(), timer);
                } else {
                    Log.trace("doFindText: listLines: %d lines (%d msec) ", wordsFound.size(), timer);
                }
                for (Match match : wordsFound) {
                    Rectangle wordOrLine = match.getRect();
                    wordsMatch.add(new Match(match.getRect(), match.getScore(), match.getText(), where));
                }
                findResult = new FindResult2(wordsMatch, this.fInput);
            }
            return findResult;
        }

        private static boolean isGray(Mat mat) {
            return mat.type() == gray;
        }

        private static boolean isColored(Mat mat) {
            return mat.type() == colored || mat.type() == transparent;
        }

        public static List<Region> findChanges(FindInput2 findInput) {
            findInput.setAttributes();
            Mat previousGray = Finder2.getNewMat();
            Mat nextGray = Finder2.getNewMat();
            Mat mDiffAbs = Finder2.getNewMat();
            Mat mDiffTresh = Finder2.getNewMat();
            Imgproc.cvtColor((Mat)findInput.getBase(), (Mat)previousGray, (int)toGray);
            Imgproc.cvtColor((Mat)findInput.getTarget(), (Mat)nextGray, (int)toGray);
            Core.absdiff((Mat)previousGray, (Mat)nextGray, (Mat)mDiffAbs);
            Imgproc.threshold((Mat)mDiffAbs, (Mat)mDiffTresh, (double)PIXEL_DIFF_THRESHOLD, (double)0.0, (int)3);
            List<Region> rectangles = new ArrayList<Region>();
            if (Core.countNonZero((Mat)mDiffTresh) > IMAGE_DIFF_THRESHOLD) {
                Imgproc.threshold((Mat)mDiffAbs, (Mat)mDiffAbs, (double)PIXEL_DIFF_THRESHOLD, (double)255.0, (int)0);
                Imgproc.dilate((Mat)mDiffAbs, (Mat)mDiffAbs, (Mat)Finder2.getNewMat());
                Mat se = Imgproc.getStructuringElement((int)2, (Size)new Size(5.0, 5.0));
                Imgproc.morphologyEx((Mat)mDiffAbs, (Mat)mDiffAbs, (int)3, (Mat)se);
                ArrayList<MatOfPoint> contours = new ArrayList<MatOfPoint>();
                Mat mHierarchy = Finder2.getNewMat();
                Imgproc.findContours((Mat)mDiffAbs, contours, (Mat)mHierarchy, (int)1, (int)2);
                rectangles = Finder2.contoursToRectangle(contours);
            }
            return rectangles;
        }

        public static List<Region> contoursToRectangle(List<MatOfPoint> contours) {
            ArrayList<Region> rects = new ArrayList<Region>();
            for (MatOfPoint contour : contours) {
                int x1 = 99999;
                int y1 = 99999;
                int x2 = 0;
                int y2 = 0;
                List points = contour.toList();
                for (Point point : points) {
                    int x = (int)point.x;
                    int y = (int)point.y;
                    if (x < x1) {
                        x1 = x;
                    }
                    if (x > x2) {
                        x2 = x;
                    }
                    if (y < y1) {
                        y1 = y;
                    }
                    if (y <= y2) continue;
                    y2 = y;
                }
                Region rect = new Region(x1, y1, x2 - x1, y2 - y1);
                rects.add(rect);
            }
            return rects;
        }

        public static boolean isOpaque(BufferedImage bImg) {
            if (bImg.getType() == 6) {
                List<Mat> mats = Finder2.getMatList(bImg);
                Mat transMat = mats.get(0);
                int allPixel = (int)transMat.size().area();
                int nonZeroPixel = Core.countNonZero((Mat)transMat);
                if (nonZeroPixel != allPixel) {
                    return false;
                }
            }
            return true;
        }

        private static List<Mat> getMatList(BufferedImage bImg) {
            byte[] data = ((DataBufferByte)bImg.getRaster().getDataBuffer()).getData();
            Mat aMat = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC4);
            aMat.put(0, 0, data);
            ArrayList<Mat> mats = new ArrayList<Mat>();
            Core.split((Mat)aMat, mats);
            return mats;
        }

        public static Mat makeMat(BufferedImage bImg) {
            return Finder2.makeMat(bImg, true);
        }

        public static Mat makeMat(BufferedImage bImg, boolean asBGR) {
            if (bImg.getType() == 1) {
                Log.trace("makeMat: INT_RGB (%dx%d)", bImg.getWidth(), bImg.getHeight());
                int[] data = ((DataBufferInt)bImg.getRaster().getDataBuffer()).getData();
                ByteBuffer byteBuffer = ByteBuffer.allocate(data.length * 4);
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                intBuffer.put(data);
                Mat aMat = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC4);
                aMat.put(0, 0, byteBuffer.array());
                Mat oMatBGR = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC3);
                Mat oMatA = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC1);
                ArrayList<Mat> mixIn = new ArrayList<Mat>(Arrays.asList(aMat));
                ArrayList<Mat> mixOut = new ArrayList<Mat>(Arrays.asList(oMatA, oMatBGR));
                Core.mixChannels(mixIn, mixOut, (MatOfInt)new MatOfInt(new int[]{0, 0, 1, 3, 2, 2, 3, 1}));
                return oMatBGR;
            }
            if (bImg.getType() == 5) {
                Log.trace("makeMat: 3BYTE_BGR (%dx%d)", bImg.getWidth(), bImg.getHeight());
                byte[] data = ((DataBufferByte)bImg.getRaster().getDataBuffer()).getData();
                Mat aMatBGR = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC3);
                aMatBGR.put(0, 0, data);
                return aMatBGR;
            }
            if (bImg.getType() == 13 || bImg.getType() == 12) {
                String bImgType = "BYTE_BINARY";
                if (bImg.getType() == 13) {
                    bImgType = "BYTE_INDEXED";
                }
                Log.trace("makeMat: %s (%dx%d)", bImgType, bImg.getWidth(), bImg.getHeight());
                BufferedImage bimg3b = new BufferedImage(bImg.getWidth(), bImg.getHeight(), 5);
                Graphics graphics = bimg3b.getGraphics();
                graphics.drawImage(bImg, 0, 0, null);
                byte[] data = ((DataBufferByte)bimg3b.getRaster().getDataBuffer()).getData();
                Mat aMatBGR = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC3);
                aMatBGR.put(0, 0, data);
                return aMatBGR;
            }
            if (bImg.getType() == 6 || bImg.getType() == 0) {
                Log.trace("makeMat: TYPE_4BYTE_ABGR (%dx%d)", bImg.getWidth(), bImg.getHeight());
                List<Mat> mats = Finder2.getMatList(bImg);
                Size size = mats.get(0).size();
                if (asBGR) {
                    Mat mBGR = Finder2.getNewMat(size, 3, -1);
                    mats.remove(0);
                    Core.merge(mats, (Mat)mBGR);
                    return mBGR;
                }
                Mat mBGRA = Finder2.getNewMat(size, 4, -1);
                mats.add(mats.remove(0));
                Core.merge(mats, (Mat)mBGRA);
                return mBGRA;
            }
            if (bImg.getType() == 10) {
                Log.trace("makeMat: BYTE_GRAY (%dx%d)", bImg.getWidth(), bImg.getHeight());
                byte[] data = ((DataBufferByte)bImg.getRaster().getDataBuffer()).getData();
                Mat aMat = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC1);
                aMat.put(0, 0, data);
                return aMat;
            }
            if (bImg.getType() == 12) {
                Log.trace("makeMat: BYTE_BINARY (%dx%d)", bImg.getWidth(), bImg.getHeight());
                BufferedImage bimg3b = new BufferedImage(bImg.getWidth(), bImg.getHeight(), 5);
                Graphics graphics = bimg3b.getGraphics();
                graphics.drawImage(bImg, 0, 0, null);
                byte[] data = ((DataBufferByte)bimg3b.getRaster().getDataBuffer()).getData();
                Mat aMatBGR = new Mat(bImg.getHeight(), bImg.getWidth(), CvType.CV_8UC3);
                aMatBGR.put(0, 0, data);
                return aMatBGR;
            }
            Log.error("makeMat: BufferedImage: type not supported: %d --- please report this problem", bImg.getType());
            return Finder2.getNewMat();
        }

        public static Mat makeMat() {
            return Finder2.getNewMat();
        }

        public static Mat makeMat(Size size, int type, int fill) {
            return Finder2.getNewMat(size, type, fill);
        }

        protected static Mat getNewMat() {
            return new Mat();
        }

        protected static Mat getNewMat(Size size, int type, int fill) {
            switch (type) {
                case 1: {
                    type = CvType.CV_8UC1;
                    break;
                }
                case 3: {
                    type = CvType.CV_8UC3;
                    break;
                }
                case 4: {
                    type = CvType.CV_8UC4;
                    break;
                }
                default: {
                    type = -1;
                }
            }
            if (type < 0) {
                return new Mat();
            }
            Mat result = fill < 0 ? new Mat(size, type) : new Mat(size, type, new Scalar((double)fill));
            return result;
        }

        protected static Mat matMulti(Mat mat, int channels) {
            if (mat.type() != CvType.CV_8UC1 || mat.channels() == channels) {
                return mat;
            }
            ArrayList<Mat> listMat = new ArrayList<Mat>();
            for (int n = 0; n < channels; ++n) {
                listMat.add(mat);
            }
            Mat mResult = Finder2.getNewMat();
            Core.merge(listMat, (Mat)mResult);
            return mResult;
        }

        protected static List<Mat> extractMask(Mat target, boolean onlyChannel4) {
            Mat maskMask;
            int nonZeroPixel;
            int allPixel;
            ArrayList<Mat> extracted = new ArrayList<Mat>();
            Mat mask = new Mat();
            Mat targetBGR = new Mat();
            int nChannels = target.channels();
            if (nChannels == 4) {
                ArrayList mats = new ArrayList();
                Core.split((Mat)target, mats);
                mask = (Mat)mats.remove(3);
                Core.merge(mats, (Mat)targetBGR);
                allPixel = (int)mask.size().area();
                nonZeroPixel = Core.countNonZero((Mat)mask);
                if (nonZeroPixel != allPixel) {
                    maskMask = new Mat();
                    Imgproc.threshold((Mat)mask, (Mat)maskMask, (double)0.0, (double)1.0, (int)0);
                    mask = Finder2.matMulti(maskMask, 3);
                } else {
                    mask = new Mat();
                }
            } else {
                targetBGR = target;
            }
            if (!onlyChannel4 && (mask.empty() || nChannels == 3)) {
                Mat mGray = new Mat();
                Imgproc.cvtColor((Mat)targetBGR, (Mat)mGray, (int)toGray);
                allPixel = (int)mGray.size().area();
                nonZeroPixel = Core.countNonZero((Mat)mGray);
                if (nonZeroPixel != allPixel) {
                    maskMask = new Mat();
                    Imgproc.threshold((Mat)mGray, (Mat)maskMask, (double)0.0, (double)1.0, (int)0);
                    mask = Finder2.matMulti(maskMask, 3);
                }
            }
            extracted.add(targetBGR);
            extracted.add(mask);
            return extracted;
        }

        public static BufferedImage getBufferedImage(Mat mat) {
            return Finder2.getBufferedImage(mat, dotPNG);
        }

        public static BufferedImage getBufferedImage(Mat mat, String type) {
            BufferedImage bImg = null;
            MatOfByte bytemat = new MatOfByte();
            if (SX.isNull(mat)) {
                mat = Finder2.getNewMat();
            }
            Imgcodecs.imencode((String)type, (Mat)mat, (MatOfByte)bytemat);
            byte[] bytes = bytemat.toArray();
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                bImg = ImageIO.read(in);
            }
            catch (IOException ex) {
                Log.error("getBufferedImage: %s error(%s)", mat, ex.getMessage());
            }
            return bImg;
        }

        static {
            RunTime.loadLibrary(RunTime.libOpenCV);
            log = new Log("Finder2");
            toGray = 6;
            toColor = 8;
            gray = CvType.CV_8UC1;
            colored = CvType.CV_8UC3;
            transparent = CvType.CV_8UC4;
        }

        private static enum FindType {
            ONE,
            ALL;

        }

        static class Log {
            private static String prefix = "UnKnown";

            public Log(String prefix) {
                Log.prefix = prefix + ": ";
            }

            public static void error(String msg, Object ... args) {
                Debug.error(prefix + msg, args);
            }

            public static void trace(String msg, Object ... args) {
                Debug.log(3, prefix + msg, args);
            }
        }
    }
}

