/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.sikuli.guide.GlobalMouseMotionListener;
import org.sikuli.guide.GlobalMouseMotionTracker;
import org.sikuli.guide.Guide;
import org.sikuli.guide.Transition;
import org.sikuli.script.Region;
import org.sikuli.util.EventObserver;
import org.sikuli.util.EventSubject;
import org.sikuli.util.OverlayTransparentWindow;

public class SxBeam
extends OverlayTransparentWindow
implements Transition,
GlobalMouseMotionListener,
EventObserver {
    Guide guide;
    public Point current = null;
    public Point to = null;
    Region target;
    GlobalMouseMotionTracker mouseTracker;
    Transition.TransitionListener listener;

    public SxBeam(Guide guide, Region target) {
        super(new Color(1.0f, 0.0f, 0.0f, 0.7f), null);
        super.addObserver(this);
        this.guide = guide;
        this.target = target;
    }

    @Override
    public void update(EventSubject es) {
        Graphics2D g = ((OverlayTransparentWindow)es).getJPanelGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawRayPolygon(g, this.current, this.target.getRect());
    }

    public void drawRayPolygon(Graphics g, Point p, Rectangle rect) {
        if (p == null || rect == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle r = rect;
        Ellipse2D.Double ellipse = new Ellipse2D.Double(r.x, r.y, r.width - 1, r.height - 1);
        g2d.setColor(Color.red);
        g2d.fill(ellipse);
        g2d.translate(rect.x + rect.width / 2, rect.y + rect.height / 2);
        float a0 = r.width / 2;
        float b0 = r.height / 2;
        float a = a0 * a0;
        float b = b0 * b0;
        float m = p.x - rect.x - rect.width / 2;
        float n = p.y - rect.y - rect.height / 2;
        float t1 = 1.0f + a * n * n / (b * m * m);
        float t2 = -2.0f * a * n / (m * m);
        float t3 = b * a / (m * m) - b;
        float s = (float)Math.sqrt(t2 * t2 - 4.0f * t1 * t3);
        float y1 = (-t2 + s) / (2.0f * t1);
        float y2 = (-t2 - s) / (2.0f * t1);
        float x1 = a / m - y1 * (a * n) / (b * m);
        float x2 = a / m - y2 * (a * n) / (b * m);
        GeneralPath flagShape = new GeneralPath();
        flagShape.moveTo(m, n);
        flagShape.lineTo(x1, y1);
        flagShape.lineTo(x2, y2);
        flagShape.closePath();
        g2d.fill(flagShape);
        g2d.setComposite(AlphaComposite.getInstance(1, 1.0f));
        ellipse = new Ellipse2D.Double(-r.width / 2 + 3, -r.height / 2 + 3, r.width - 6, r.height - 6);
        g2d.fill(ellipse);
    }

    public void drawRayPolygon1(Graphics g, Point p, Rectangle rect) {
        int[] ys;
        int[] xs;
        if (p == null || rect == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Rectangle r = rect;
        int[] cxs = new int[]{r.x, r.x, r.x + r.width, r.x + r.width};
        int[] cys = new int[]{r.y, r.y + r.height, r.y + r.height, r.height};
        ArrayList<Point> corners = new ArrayList<Point>();
        corners.add(new Point(r.x, r.y));
        corners.add(new Point(r.x + r.width, r.y + r.height));
        corners.add(new Point(r.x + r.width, r.y));
        corners.add(new Point(r.x, r.y + r.height));
        Collections.sort(corners, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return (int)(SxBeam.this.current.distance((Point)arg0) - SxBeam.this.current.distance((Point)arg1));
            }
        });
        int d = 5;
        if ((double)p.x > rect.getMinX() - 5.0 && (double)p.x < rect.getMaxX() + 5.0 || (double)p.y > rect.getMinY() - 5.0 && (double)p.y < rect.getMaxY() + 5.0) {
            xs = new int[3];
            ys = new int[3];
            xs[0] = p.x;
            xs[1] = ((Point)corners.get((int)0)).x;
            xs[2] = ((Point)corners.get((int)1)).x;
            ys[0] = p.y;
            ys[1] = ((Point)corners.get((int)0)).y;
            ys[2] = ((Point)corners.get((int)1)).y;
        } else {
            xs = new int[4];
            ys = new int[4];
            xs[0] = p.x;
            xs[1] = ((Point)corners.get((int)2)).x;
            xs[2] = ((Point)corners.get((int)0)).x;
            xs[3] = ((Point)corners.get((int)1)).x;
            ys[0] = p.y;
            ys[1] = ((Point)corners.get((int)2)).y;
            ys[2] = ((Point)corners.get((int)0)).y;
            ys[3] = ((Point)corners.get((int)1)).y;
        }
        Polygon shape = new Polygon(xs, ys, xs.length);
        BasicStroke pen = new BasicStroke(3.0f);
        g2d.setStroke(pen);
        g2d.setColor(Color.black);
        g2d.setColor(Color.red);
        g2d.fillPolygon(shape);
        g2d.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    @Override
    public String waitForTransition(Transition.TransitionListener listener) {
        this.listener = listener;
        this.mouseTracker = GlobalMouseMotionTracker.getInstance();
        this.mouseTracker.addListener(this);
        this.mouseTracker.start();
        this.setBounds(this.guide.getRegion().getRect());
        this.setVisible(true);
        this.toFront();
        return "Next";
    }

    @Override
    public void globalMouseIdled(int x, int y) {
    }

    @Override
    public void globalMouseMoved(int x, int y) {
        this.current = new Point(x, y);
        this.repaint();
        if (this.target.getRect().contains(this.current)) {
            this.setVisible(false);
            this.dispose();
            this.listener.transitionOccurred(this);
        }
    }
}

