/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.sikuli.android.ADBClient;
import org.sikuli.android.ADBRobot;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.support.RunTime;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;

public class ADBDevice {
    private static int lvl = 3;
    private JadbDevice device = null;
    private int devW = -1;
    private int devH = -1;
    private ADBRobot robot = null;
    private ADBScreen screen = null;
    private boolean isMulti = false;
    private List<String> deviceProps = new ArrayList<String>();
    private int deviceVersion = -1;
    private String sDeviceVersion = "???";
    private static ADBDevice adbDevice = null;
    private String adbExec = "";
    public static int KEY_HOME = 3;
    public static int KEY_BACK = 4;
    public static int KEY_MENU = 82;
    public static int KEY_POWER = 26;
    private static final int BUFFER_SIZE = 4096;
    private String textBuffer = "";
    private boolean typing = false;
    public static float inputDelay = 0.05f;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "ADBDevice: " + message, args);
    }

    private ADBDevice() {
    }

    public static ADBDevice init() {
        return ADBDevice.init("");
    }

    public static ADBDevice init(String adbExec) {
        if (adbDevice == null) {
            adbDevice = new ADBDevice();
            ADBDevice.adbDevice.device = ADBClient.getDevice(adbExec);
            if (ADBDevice.adbDevice.device == null) {
                adbDevice = null;
            } else {
                adbDevice.initDevice(adbDevice);
                ADBDevice.adbDevice.adbExec = ADBClient.getADB();
                RunTime.loadLibrary(RunTime.libOpenCV);
            }
        }
        return adbDevice;
    }

    public static ADBDevice init(int id) {
        ADBDevice adbDevice = new ADBDevice();
        adbDevice.device = ADBClient.getDevice(id);
        if (adbDevice.device == null) {
            return null;
        }
        adbDevice.initDevice(adbDevice);
        adbDevice.adbExec = ADBClient.getADB();
        RunTime.loadLibrary(RunTime.libOpenCV);
        return adbDevice;
    }

    private void initDevice(ADBDevice device) {
        device.deviceProps = Arrays.asList(device.exec("getprop", new String[0]).split("\n"));
        Pattern pProp = Pattern.compile("\\[(.*?)\\]:.*?\\[(.*)\\]");
        Matcher mProp = null;
        String val = "";
        String key = "";
        for (String prop : device.deviceProps) {
            if (!prop.startsWith("[ro.") || !(mProp = pProp.matcher(prop)).find() || !(key = mProp.group(1)).contains("build.version.release")) continue;
            val = mProp.group(2);
            try {
                device.deviceVersion = Integer.parseInt(val.split("\\.")[0]);
                device.sDeviceVersion = val;
            }
            catch (Exception exception) {}
        }
        ADBDevice.log(lvl, "init: %s", device.toString());
    }

    public static void reset() {
        adbDevice = null;
        ADBClient.reset();
    }

    public String toString() {
        return String.format("attached device: serial(%s) display(%dx%d) version(%s)", this.getDeviceSerial(), this.getBounds().width, this.getBounds().height, this.sDeviceVersion);
    }

    public ADBRobot getRobot(ADBScreen screen) {
        if (this.robot == null) {
            this.screen = screen;
            this.robot = new ADBRobot(screen, this);
        }
        return this.robot;
    }

    public String getDeviceSerial() {
        return this.device.getSerial();
    }

    public Rectangle getBounds() {
        if (this.devW < 0) {
            Dimension dim = this.getDisplayDimension();
            this.devW = (int)dim.getWidth();
            this.devH = (int)dim.getHeight();
        }
        return new Rectangle(0, 0, this.devW, this.devH);
    }

    public ScreenImage captureScreen() {
        BufferedImage bimg = this.captureDeviceScreen();
        return new ScreenImage(this.getBounds(), bimg);
    }

    public ScreenImage captureScreen(Rectangle rect) {
        BufferedImage bimg = this.captureDeviceScreen(rect.x, rect.y, rect.width, rect.height);
        return new ScreenImage(rect, bimg);
    }

    public BufferedImage captureDeviceScreen() {
        return this.captureDeviceScreen(0, 0, -1, -1);
    }

    public BufferedImage captureDeviceScreen(int x, int y, int w, int h) {
        Mat matImage = this.captureDeviceScreenMat(x, y, w, h);
        BufferedImage bImage = null;
        if (matImage != null) {
            bImage = new BufferedImage(matImage.width(), matImage.height(), 5);
            byte[] bImageData = ((DataBufferByte)bImage.getRaster().getDataBuffer()).getData();
            matImage.get(0, 0, bImageData);
        }
        return bImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Mat captureDeviceScreenMat(int x, int y, int actW, int actH) {
        ADBDevice.log(lvl, "captureDeviceScreenMat: enter: [%d,%d %dx%d]", x, y, actW, actH);
        byte[] imagePrefix = new byte[12];
        byte[] image = new byte[]{};
        boolean isfullScreen = false;
        if (x == 0 && y == 0 && actW < 0 && actH < 0) {
            isfullScreen = true;
        }
        int channels = 4;
        Mat matImage = new Mat();
        try (InputStream deviceOut = this.device.execute("screencap", new String[0]);){
            Debug timer = Debug.startTimer();
            while (deviceOut.available() < 12) {
            }
            deviceOut.read(imagePrefix);
            if (imagePrefix[8] != 1) {
                ADBDevice.log(-1, "captureDeviceScreenMat: image type not RGBA", new Object[0]);
                Mat mat = null;
                return mat;
            }
            int currentW = this.byte2int(imagePrefix, 0, 4);
            int currentH = this.byte2int(imagePrefix, 4, 4);
            if (!(currentW == this.devW && currentH == this.devH || currentH == this.devW && currentW == this.devH)) {
                ADBDevice.log(-1, "captureDeviceScreenMat: width or height differ from device values", new Object[0]);
                Mat mat = null;
                return mat;
            }
            if (isfullScreen) {
                actW = currentW;
                actH = currentH;
            } else {
                if (x + actW > currentW) {
                    actW = currentW - x;
                }
                if (y + actH > currentH) {
                    actH = currentH - y;
                }
            }
            long duration = timer.lap("");
            int nPixels = actW * actH;
            image = new byte[nPixels * channels];
            int atImage = 0;
            boolean endOfStream = false;
            int maxR = y + actH;
            int maxC = x + actW;
            byte[] pixel = new byte[channels];
            int pixelByte = -1;
            for (int npr = 0; npr < maxR; ++npr) {
                for (int npc = 0; npc < currentW; ++npc) {
                    for (int np = 0; np < channels; ++np) {
                        pixelByte = deviceOut.read();
                        if (pixelByte > -1) {
                            pixel[np] = (byte)pixelByte;
                            continue;
                        }
                        endOfStream = true;
                    }
                    if (endOfStream) break;
                    if (pixel[3] != -1) {
                        ADBDevice.log(-1, "buffer problem: %d", nPixels);
                        Mat np = null;
                        return np;
                    }
                    if (npr < y || npc < x || npc >= maxC) continue;
                    image[atImage++] = pixel[0];
                    image[atImage++] = pixel[1];
                    image[atImage++] = pixel[2];
                    image[atImage++] = pixel[3];
                }
                if (endOfStream) break;
            }
            Mat matOrg = new Mat(actH, actW, CvType.CV_8UC4);
            matOrg.put(0, 0, image);
            ArrayList matsOrg = new ArrayList();
            Core.split((Mat)matOrg, matsOrg);
            matsOrg.remove(3);
            ArrayList<Mat> matsImage = new ArrayList<Mat>();
            matsImage.add((Mat)matsOrg.get(2));
            matsImage.add((Mat)matsOrg.get(1));
            matsImage.add((Mat)matsOrg.get(0));
            Core.merge(matsImage, (Mat)matImage);
            ADBDevice.log(lvl, "captureDeviceScreenMat: exit: [%d,%d %dx%d] %d (%d)", x, y, actW, actH, duration, timer.end());
            return matImage;
        }
        catch (Exception e) {
            ADBDevice.log(-1, "captureDeviceScreenMat: [%d,%d %dx%d] %s", x, y, actW, actH, e);
        }
        return matImage;
    }

    private int byte2int(byte[] bytes, int start, int len) {
        int val = 0;
        int fact = 1;
        for (int i = start; i < start + len; ++i) {
            int b = bytes[i] & 0xFF;
            val += b * fact;
            fact *= 256;
        }
        return val;
    }

    private InputStream execADB(String ... args) {
        if (args.length < 1) {
            return null;
        }
        ProcessBuilder app = new ProcessBuilder(new String[0]);
        ArrayList<String> cmd = new ArrayList<String>();
        Map<String, String> processEnv = app.environment();
        cmd.add(this.adbExec);
        for (String arg : args) {
            cmd.add(arg);
        }
        app.directory(null);
        app.redirectErrorStream(false);
        app.command(cmd);
        Process process = null;
        try {
            process = app.start();
            return process.getInputStream();
        }
        catch (IOException e) {
            ADBDevice.log(-1, "execADB: %s (%s)", cmd, e);
            return null;
        }
    }

    private Dimension getDisplayDimension() {
        String dump = this.dumpsys("display");
        String token = "mDefaultViewport= ... deviceWidth=1200, deviceHeight=1920}";
        Dimension dim = null;
        Pattern displayDimension = Pattern.compile("mDefaultViewport.*?=.*?deviceWidth=(\\d*).*?deviceHeight=(\\d*)");
        Matcher match = displayDimension.matcher(dump);
        if (match.find()) {
            int w = Integer.parseInt(match.group(1));
            int h = Integer.parseInt(match.group(2));
            dim = new Dimension(w, h);
        } else {
            ADBDevice.log(-1, "getDisplayDimension: dumpsys display: token not found: %s", token);
        }
        return dim;
    }

    public String exec(String command, String ... args) {
        String out = "";
        try (InputStream stdout = this.device.executeShell(command, args);){
            out = ADBDevice.inputStreamToString(stdout, "UTF-8");
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "exec: %s: %s", command, e);
            return null;
        }
        return out;
    }

    public String dumpsys(String component) {
        String out = "";
        if (component == null || component.isEmpty()) {
            component = "power";
        }
        try (InputStream stdout = component.toLowerCase().contains("all") ? this.device.executeShell("dumpsys", new String[0]) : this.device.executeShell("dumpsys", component);){
            out = ADBDevice.inputStreamToString(stdout, "UTF-8");
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "dumpsys: %s: %s", component, e);
        }
        return out;
    }

    public String printDump(String component) {
        String dump = this.dumpsys(component);
        if (!dump.isEmpty()) {
            System.out.println("***** Android device dump: " + component);
            System.out.println(dump);
        }
        return dump;
    }

    public String printDump() {
        String dump = this.dumpsys("all");
        if (!dump.isEmpty()) {
            File out = new File(RunTime.get().fSikulixStore, "android_dump_" + this.getDeviceSerial() + ".txt");
            System.out.println("***** Android device dump all services");
            System.out.println("written to file: " + out.getAbsolutePath());
            FileManager.writeStringToFile(dump, out);
        }
        return dump;
    }

    private static String inputStreamToString(InputStream inputStream, String charsetName) {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int length;
            reader = new InputStreamReader(inputStream, charsetName);
            char[] buffer = new char[4096];
            while ((length = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, length);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void wakeUp(int seconds) {
        int times = seconds * 4;
        try {
            if (null == this.isDisplayOn()) {
                ADBDevice.log(-1, "wakeUp: not possible - see log", new Object[0]);
                return;
            }
            this.inputKeyEvent(224);
            while (0 < times--) {
                if (this.isDisplayOn().booleanValue()) {
                    return;
                }
                RunTime.pause(0.25f);
            }
        }
        catch (Exception e) {
            ADBDevice.log(-1, "wakeUp: did not work: %s", e);
        }
        ADBDevice.log(-1, "wakeUp: timeout: %d seconds", seconds);
    }

    public Boolean isDisplayOn() {
        Matcher match;
        String dump = this.dumpsys("power");
        Pattern displayOn = Pattern.compile("mScreenOn=(..)");
        String isOn = "tr";
        if (this.deviceVersion > 4) {
            displayOn = Pattern.compile("Display Power: state=(..)");
            isOn = "ON";
        }
        if ((match = displayOn.matcher(dump)).find()) {
            if (match.group(1).contains(isOn)) {
                return true;
            }
            return false;
        }
        ADBDevice.log(-1, "isDisplayOn: (Android version %d) dumpsys power: pattern not found: %s", this.deviceVersion, displayOn);
        return null;
    }

    public void inputKeyEvent(int key) {
        try {
            this.device.executeShell("input", "keyevent", Integer.toString(key));
        }
        catch (Exception e) {
            ADBDevice.log(-1, "inputKeyEvent: %d did not work: %s", e.getMessage());
        }
    }

    public void tap(int x, int y) {
        try {
            this.device.executeShell("input tap", Integer.toString(x), Integer.toString(y));
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "tap: %s", e);
        }
    }

    public void swipe(int x1, int y1, int x2, int y2) {
        try {
            this.device.executeShell("input swipe", Integer.toString(x1), Integer.toString(y1), Integer.toString(x2), Integer.toString(y2));
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "swipe: %s", e);
        }
    }

    public synchronized boolean typeStarts() {
        if (!this.typing) {
            this.textBuffer = "";
            this.typing = true;
            return true;
        }
        return false;
    }

    public synchronized void typeEnds() {
        if (this.typing) {
            this.input(this.textBuffer);
            this.typing = false;
        }
    }

    public void typeChar(char character) {
        if (this.typing) {
            this.textBuffer = this.textBuffer + character;
        }
    }

    public void input(String text) {
        try {
            this.device.executeShell("input text ", text);
            RunTime.pause((float)text.length() * inputDelay);
        }
        catch (Exception e) {
            ADBDevice.log(-1, "input: %s", e);
        }
    }
}

