/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFileRecord;

public class SyncTransport {
    private final DataOutput output;
    private final DataInput input;

    public SyncTransport(OutputStream outputStream, InputStream inputStream) {
        this.output = new DataOutputStream(outputStream);
        this.input = new DataInputStream(inputStream);
    }

    public SyncTransport(DataOutput outputStream, DataInput inputStream) {
        this.output = outputStream;
        this.input = inputStream;
    }

    public void send(String syncCommand, String name) throws IOException {
        if (syncCommand.length() != 4) {
            throw new IllegalArgumentException("sync commands must have length 4");
        }
        this.output.writeBytes(syncCommand);
        this.output.writeInt(Integer.reverseBytes(name.length()));
        this.output.writeBytes(name);
    }

    public void sendStatus(String statusCode, int length) throws IOException {
        this.output.writeBytes(statusCode);
        this.output.writeInt(Integer.reverseBytes(length));
    }

    public void verifyStatus() throws IOException, JadbException {
        String status = this.readString(4);
        int length = this.readInt();
        if ("FAIL".equals(status)) {
            String error = this.readString(length);
            throw new JadbException(error);
        }
        if (!"OKAY".equals(status)) {
            throw new JadbException("Unknown error: " + status);
        }
    }

    private int readInt() throws IOException {
        return Integer.reverseBytes(this.input.readInt());
    }

    private String readString(int length) throws IOException {
        byte[] buffer = new byte[length];
        this.input.readFully(buffer);
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public RemoteFileRecord readDirectoryEntry() throws IOException {
        String id = this.readString(4);
        int mode = this.readInt();
        int size = this.readInt();
        int time = this.readInt();
        int nameLength = this.readInt();
        String name = this.readString(nameLength);
        if (!"DENT".equals(id)) {
            return RemoteFileRecord.DONE;
        }
        return new RemoteFileRecord(name, mode, size, time);
    }

    private void sendChunk(byte[] buffer, int offset, int length) throws IOException {
        this.output.writeBytes("DATA");
        this.output.writeInt(Integer.reverseBytes(length));
        this.output.write(buffer, offset, length);
    }

    private int readChunk(byte[] buffer) throws IOException, JadbException {
        String id = this.readString(4);
        int n = this.readInt();
        if ("FAIL".equals(id)) {
            throw new JadbException(this.readString(n));
        }
        if (!"DATA".equals(id)) {
            return -1;
        }
        this.input.readFully(buffer, 0, n);
        return n;
    }

    public void sendStream(InputStream in) throws IOException {
        byte[] buffer = new byte[65536];
        int n = in.read(buffer);
        while (n != -1) {
            this.sendChunk(buffer, 0, n);
            n = in.read(buffer);
        }
    }

    public void readChunksTo(OutputStream stream) throws IOException, JadbException {
        byte[] buffer = new byte[65536];
        int n = this.readChunk(buffer);
        while (n != -1) {
            stream.write(buffer, 0, n);
            n = this.readChunk(buffer);
        }
    }
}

