/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.ObserveEvent;
import org.sikuli.script.ObserverCallBack;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.support.Observing;

public class Observer {
    private static String me = "Observer: ";
    private static int lvl = 3;
    private Region observedRegion = null;
    private Map<String, State> eventStates = Collections.synchronizedMap(new HashMap());
    private Map<String, Long> eventRepeatWaitTimes = Collections.synchronizedMap(new HashMap());
    private Map<String, Match> eventMatches = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> eventNames = Collections.synchronizedMap(new HashMap());
    private Map<String, ObserveEvent.Type> eventTypes = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> eventCallBacks = Collections.synchronizedMap(new HashMap());
    private Map<String, Integer> eventCounts = Collections.synchronizedMap(new HashMap());
    private int minChanges = 0;
    private int numChangeCallBacks = 0;
    private int numChangeObservers = 0;
    private static boolean shouldStopOnFirstEvent = false;
    private ScreenImage lastImage = null;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private Observer() {
    }

    public Observer(Region region) {
        this.observedRegion = region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Observer.log(3, "resetting observe states for " + this.observedRegion.toStringShort(), new Object[0]);
        Map<String, Object> map = this.eventNames;
        synchronized (map) {
            for (String name : this.eventNames.keySet()) {
                this.eventStates.put(name, State.FIRST);
                this.eventCounts.put(name, 0);
                this.eventMatches.put(name, null);
            }
        }
        shouldStopOnFirstEvent = false;
        if (Observing.getStopOnFirstEvent()) {
            Observer.log(lvl, "requested to stop on first event", new Object[0]);
            shouldStopOnFirstEvent = true;
        }
    }

    public void setStopOnFirstEvent() {
        shouldStopOnFirstEvent = true;
    }

    public String[] getNames() {
        return this.eventNames.keySet().toArray(new String[0]);
    }

    public void setActive(String name, boolean state) {
        if (this.eventNames.containsKey(me)) {
            if (state) {
                this.eventStates.put(name, State.FIRST);
            } else {
                this.eventStates.put(name, State.INACTIVE);
            }
        }
    }

    public int getCount(String name) {
        Integer count = this.eventCounts.get(name);
        return count == null ? 1 : count;
    }

    private <PSC> double getSimiliarity(PSC ptn) {
        double similarity = -1.0;
        if (ptn instanceof Pattern) {
            similarity = ((Pattern)ptn).getSimilar();
        }
        if (similarity < 0.0) {
            similarity = Settings.MinSimilarity;
        }
        return similarity;
    }

    public <PSC> void addObserver(PSC ptn, ObserverCallBack ob, String name, ObserveEvent.Type type) {
        this.eventCallBacks.put(name, ob);
        this.eventStates.put(name, State.FIRST);
        this.eventNames.put(name, ptn);
        this.eventTypes.put(name, type);
        if (type == ObserveEvent.Type.CHANGE) {
            this.minChanges = this.getMinChanges();
            ++this.numChangeObservers;
            if (this.eventCallBacks.get(name) != null) {
                ++this.numChangeCallBacks;
            }
        }
    }

    public void removeObserver(String name) {
        Observing.remove(name);
        if (this.eventTypes.get(name) == ObserveEvent.Type.CHANGE) {
            if (this.eventCallBacks.get(name) != null) {
                --this.numChangeCallBacks;
            }
            --this.numChangeObservers;
        }
        this.eventNames.remove(name);
        this.eventCallBacks.remove(name);
        this.eventStates.remove(name);
        this.eventTypes.remove(name);
        this.eventCounts.remove(name);
        this.eventMatches.remove(name);
        this.eventRepeatWaitTimes.remove(name);
    }

    public boolean hasObservers() {
        return this.eventNames.size() > 0;
    }

    private void callEventObserver(String name, Match match, long time) {
        Object ptn = this.eventNames.get(name);
        ObserveEvent.Type obsType = this.eventTypes.get(name);
        Observer.log(lvl, "%s: %s with: %s at: %s", new Object[]{obsType, name, ptn, match});
        ObserveEvent observeEvent = new ObserveEvent(name, obsType, ptn, match, this.observedRegion, time);
        Object callBack = this.eventCallBacks.get(name);
        Observing.addEvent(observeEvent);
        if (callBack != null && callBack instanceof ObserverCallBack) {
            Observer.log(lvl, "running call back: %s", new Object[]{obsType});
            if (obsType == ObserveEvent.Type.APPEAR) {
                ((ObserverCallBack)callBack).appeared(observeEvent);
            } else if (obsType == ObserveEvent.Type.VANISH) {
                ((ObserverCallBack)callBack).vanished(observeEvent);
            } else if (obsType == ObserveEvent.Type.CHANGE) {
                ((ObserverCallBack)callBack).changed(observeEvent);
            } else if (obsType == ObserveEvent.Type.GENERIC) {
                ((ObserverCallBack)callBack).happened(observeEvent);
            }
        }
    }

    private boolean checkPatterns(ScreenImage simg) {
        Observer.log(lvl + 1, "update: checking patterns", new Object[0]);
        if (!this.observedRegion.isObserving()) {
            return false;
        }
        Finder finder = null;
        for (String name : this.eventStates.keySet()) {
            long lastSearchTime;
            Region r;
            Object ptn;
            Image img;
            if (!this.patternsToCheck()) continue;
            if (this.eventStates.get(name) == State.REPEAT) {
                if (new Date().getTime() < this.eventRepeatWaitTimes.get(name)) continue;
                this.eventStates.put(name, State.UNKNOWN);
            }
            if ((img = Image.getImageFromTarget(ptn = this.eventNames.get(name))) == null || !img.isUseable()) {
                Debug.error("EventMgr: checkPatterns: Image not valid", ptn);
                this.eventStates.put(name, State.MISSING);
                continue;
            }
            Match match = null;
            boolean hasMatch = false;
            long now = 0L;
            if (Settings.CheckLastSeen && null != img.getLastSeen() && this.observedRegion.contains(r = Region.create(img.getLastSeen()))) {
                lastSearchTime = new Date().getTime();
                Finder f = new Finder(new Screen().capture(r), r);
                f.find(new Pattern(img).similar(Settings.CheckLastSeenSimilar));
                if (f.hasNext()) {
                    Observer.log(lvl + 1, "checkLastSeen: still there", new Object[0]);
                    match = new Match(new Region(img.getLastSeen()), img.getLastSeenScore());
                    match.setTimes(0L, new Date().getTime() - lastSearchTime);
                    hasMatch = true;
                } else {
                    Observer.log(lvl + 1, "checkLastSeen: not there", new Object[0]);
                }
            }
            if (match == null) {
                if (finder == null) {
                    finder = new Finder(simg, this.observedRegion);
                }
                lastSearchTime = new Date().getTime();
                now = new Date().getTime();
                finder.find(img);
                if (finder.hasNext()) {
                    match = finder.next();
                    match.setTimes(0L, now - lastSearchTime);
                    if (match.getScore() >= this.getSimiliarity(ptn)) {
                        hasMatch = true;
                        img.setLastSeen(match.getRect(), match.getScore());
                    }
                }
            }
            if (hasMatch) {
                this.eventMatches.put(name, match);
                Observer.log(lvl + 1, "(%s): %s match: %s in:%s", new Object[]{this.eventTypes.get(name), ptn.toString(), match.toStringShort(), this.observedRegion.toStringShort()});
            } else if (this.eventStates.get(ptn) == State.FIRST) {
                Observer.log(lvl + 1, "(%s): %s match: %s in:%s", new Object[]{this.eventTypes.get(name), ptn.toString(), match.toStringShort(), this.observedRegion.toStringShort()});
                this.eventStates.put(name, State.UNKNOWN);
            }
            if (this.eventStates.get(name) != State.HAPPENED) {
                if (hasMatch && this.eventTypes.get(name) == ObserveEvent.Type.VANISH) {
                    this.eventMatches.put(name, match);
                }
                if (hasMatch && this.eventTypes.get(name) == ObserveEvent.Type.APPEAR || !hasMatch && this.eventTypes.get(name) == ObserveEvent.Type.VANISH) {
                    this.eventStates.put(name, State.HAPPENED);
                    this.eventCounts.put(name, this.eventCounts.get(name) + 1);
                    this.callEventObserver(name, this.eventMatches.get(name), now);
                    if (shouldStopOnFirstEvent) {
                        this.observedRegion.stopObserver();
                    }
                }
            }
            if (this.observedRegion.isObserving()) continue;
            return false;
        }
        return this.patternsToCheck();
    }

    private boolean patternsToCheck() {
        for (String name : this.eventNames.keySet()) {
            State s;
            if (this.eventTypes.get(name) == ObserveEvent.Type.CHANGE || (s = this.eventStates.get(name)) != State.FIRST && s != State.UNKNOWN && s != State.REPEAT) continue;
            return true;
        }
        return false;
    }

    public void repeat(String name, long secs) {
        this.eventStates.put(name, State.REPEAT);
        if (secs <= 0L) {
            secs = this.observedRegion.getRepeatWaitTime();
        }
        this.eventRepeatWaitTimes.put(name, new Date().getTime() + 1000L * secs);
        Observer.log(lvl, "repeat (%s): %s after %d seconds", new Object[]{this.eventTypes.get(name), name, secs});
    }

    private int getMinChanges() {
        int min = Integer.MAX_VALUE;
        for (String name : this.eventNames.keySet()) {
            int n;
            if (this.eventTypes.get(name) != ObserveEvent.Type.CHANGE || (n = ((Integer)this.eventNames.get(name)).intValue()) >= min) continue;
            min = n;
        }
        return min;
    }

    private boolean checkChanges(ScreenImage img) {
        if (this.numChangeObservers == 0) {
            return false;
        }
        boolean leftToDo = false;
        if (this.lastImage == null) {
            this.lastImage = img;
            return true;
        }
        for (String name : this.eventNames.keySet()) {
            if (this.eventTypes.get(name) != ObserveEvent.Type.CHANGE || this.eventStates.get(name) == State.REPEAT && new Date().getTime() < this.eventRepeatWaitTimes.get(name)) continue;
            leftToDo = true;
        }
        if (leftToDo) {
            leftToDo = false;
            Observer.log(lvl + 1, "update: checking changes", new Object[0]);
            Finder finder = new Finder(this.lastImage);
            List<Region> result = finder.findChanges(img);
            if (result.size() > 0) {
                this.callChangeObserver(result);
                if (shouldStopOnFirstEvent) {
                    this.observedRegion.stopObserver();
                }
            } else {
                leftToDo = true;
            }
            this.lastImage = img;
        }
        return leftToDo |= this.numChangeCallBacks > 0;
    }

    private void callChangeObserver(List<Region> results) {
        Observer.log(lvl, "changes: %d in: %s", results.size(), this.observedRegion);
        int offX = this.observedRegion.x;
        int offY = this.observedRegion.y;
        for (String name : this.eventNames.keySet()) {
            if (this.eventTypes.get(name) != ObserveEvent.Type.CHANGE) continue;
            int minChangedPixels = (Integer)this.eventNames.get(name);
            ArrayList<Match> changes = new ArrayList<Match>();
            for (Region rect : results) {
                if (rect.getW() * rect.getH() < minChangedPixels) continue;
                rect.x += offX;
                rect.y += offY;
                changes.add(new Match(rect, 1.0));
            }
            if (changes.size() <= 0) continue;
            long now = new Date().getTime();
            this.eventCounts.put(name, this.eventCounts.get(name) + 1);
            ObserveEvent observeEvent = new ObserveEvent(name, ObserveEvent.Type.CHANGE, null, null, this.observedRegion, now);
            observeEvent.setChanges(changes);
            observeEvent.setIndex(minChangedPixels);
            Observing.addEvent(observeEvent);
            Object callBack = this.eventCallBacks.get(name);
            if (callBack == null) continue;
            Observer.log(lvl, "running call back", new Object[0]);
            ((ObserverCallBack)callBack).changed(observeEvent);
        }
    }

    public boolean update(ScreenImage simg) {
        boolean fromPatterns = this.checkPatterns(simg);
        Observer.log(lvl, "update result: Patterns: %s", fromPatterns);
        if (!this.observedRegion.isObserving()) {
            return false;
        }
        boolean fromChanges = this.checkChanges(simg);
        Observer.log(lvl, "update result: Changes: %s", fromChanges);
        if (!this.observedRegion.isObserving()) {
            return false;
        }
        return fromPatterns || fromChanges;
    }

    public static enum State {
        FIRST,
        UNKNOWN,
        MISSING,
        REPEAT,
        HAPPENED,
        INACTIVE;

    }
}

