/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import javax.swing.JLabel;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;

public class SxFlag
extends Visual {
    public static final int DIRECTION_EAST = 1;
    public static final int DIRECTION_WEST = 2;
    public static final int DIRECTION_SOUTH = 3;
    public static final int DIRECTION_NORTH = 4;
    JLabel label;
    Rectangle textBox;
    Rectangle triangle;
    FontMetrics fm;
    String defFont = "sansserif";
    Font font;
    int defFontSize = 16;
    int direction;
    Dimension canonicalSize;
    GeneralPath flagShape;

    public SxFlag(String text) {
        this.init(text);
    }

    private void init(String text) {
        this.text = text;
        this.setForeground(this.colorText);
        this.setBackground(this.colorFront);
        this.textBox = new Rectangle();
        this.triangle = new Rectangle();
        this.font = new Font(this.defFont, 1, this.defFontSize);
    }

    @Override
    public void updateComponent() {
        this.fm = this.getFontMetrics(this.font);
        this.textBox.setSize(this.fm.stringWidth(this.text), this.fm.getHeight());
        this.textBox.grow(this.PADDING_X, this.PADDING_Y);
        this.setLocationRelativeToRegion(this.getTarget(), this.layout);
    }

    @Override
    public Visual setText(String text) {
        this.text = text;
        this.updateComponent();
        return this;
    }

    @Override
    public Visual setFont(String fontName, int fsize) {
        this.font = new Font(fontName, 1, fsize > 0 ? fsize : this.fontSize);
        this.updateComponent();
        return this;
    }

    @Override
    public Visual setLocationRelativeToRegion(Region region, Visual.Layout side) {
        if (side == Visual.Layout.TOP) {
            this.setDirection(3);
        } else if (side == Visual.Layout.BOTTOM) {
            this.setDirection(4);
        } else if (side == Visual.Layout.LEFT) {
            this.setDirection(1);
        } else if (side == Visual.Layout.RIGHT) {
            this.setDirection(2);
        }
        return super.setLocationRelativeToRegion(region, side);
    }

    public void setDirection(int direction) {
        this.direction = direction;
        if (direction == 1 || direction == 2) {
            this.triangle.setSize(10, this.textBox.height);
            this.canonicalSize = new Dimension(this.textBox.width + this.triangle.width, this.textBox.height);
        } else {
            this.triangle.setSize(20, 10);
            this.setActualSize(this.textBox.width, this.textBox.height + this.triangle.height);
            this.canonicalSize = new Dimension(this.textBox.width, this.textBox.height + this.triangle.height);
        }
        this.setActualSize(this.canonicalSize);
        if (direction == 1) {
            this.textBox.setLocation(0, 0);
        } else if (direction == 2) {
            this.textBox.setLocation(this.triangle.width, 0);
        } else if (direction == 3) {
            this.textBox.setLocation(0, 0);
        } else if (direction == 4) {
            this.textBox.setLocation(0, this.triangle.height);
        }
        this.flagShape = new GeneralPath();
        if (direction == 2 || direction == 1) {
            this.flagShape.moveTo(0.0f, 0.0f);
            this.flagShape.lineTo(this.textBox.width, 0.0f);
            this.flagShape.lineTo(this.textBox.width + this.triangle.width, this.textBox.height / 2);
            this.flagShape.lineTo(this.textBox.width, this.textBox.height);
            this.flagShape.lineTo(0.0f, this.textBox.height);
            this.flagShape.closePath();
        } else {
            this.flagShape.moveTo(0.0f, 0.0f);
            this.flagShape.lineTo(this.textBox.width, 0.0f);
            this.flagShape.lineTo(this.textBox.width, this.textBox.height);
            this.flagShape.lineTo(this.textBox.width / 2 + 8, this.textBox.height);
            this.flagShape.lineTo(this.textBox.width / 2, this.textBox.height + this.triangle.height);
            this.flagShape.lineTo(this.textBox.width / 2 - 8, this.textBox.height);
            this.flagShape.lineTo(0.0f, this.textBox.height);
            this.flagShape.closePath();
        }
        if (direction == 2) {
            AffineTransform rat = new AffineTransform();
            rat.setToTranslation(this.textBox.width + this.triangle.width, this.textBox.height);
            rat.rotate(Math.PI);
            this.flagShape.transform(rat);
        } else if (direction == 4) {
            AffineTransform rat = new AffineTransform();
            rat.setToTranslation(this.textBox.width, this.textBox.height + this.triangle.height);
            rat.rotate(Math.PI);
            this.flagShape.transform(rat);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Dimension d = new Dimension(this.textBox.width + this.triangle.width, this.textBox.height);
        Dimension originalSize = this.canonicalSize;
        Dimension actualSize = this.getActualSize();
        float scalex = 1.0f * (float)actualSize.width / (float)originalSize.width;
        float scaley = 1.0f * (float)actualSize.height / (float)originalSize.height;
        ((Graphics2D)g).scale(scalex, scaley);
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setFont(this.font);
        g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g2d.setColor(this.colorFront);
        g2d.fill(this.flagShape);
        BasicStroke pen = new BasicStroke(1.0f);
        g2d.setStroke(pen);
        g2d.setColor(this.colorFrame);
        g2d.draw(this.flagShape);
        g2d.setColor(this.colorText);
        g2d.drawString(this.text, this.textBox.x + this.PADDING_X, this.textBox.y + this.textBox.height - this.fm.getDescent() - this.PADDING_Y);
    }
}

