/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import androidx.core.app.ActivityCompat;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.siggytech.utils.communication.Conf;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class Utils {
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);
    private static final String TAG = "Utils";

    @SuppressLint(value={"NewApi"})
    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }

    public static String getDateName() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.getTimeInMillis());
    }

    public static String getStringDate() {
        String strDate = "";
        try {
            SimpleDateFormat sdf;
            switch (Conf.DATE_FORMAT) {
                case 0: {
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
                    break;
                }
                case 1: {
                    sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.US);
                    break;
                }
                default: {
                    sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm", Locale.US);
                }
            }
            Calendar cal = Calendar.getInstance();
            strDate = sdf.format(cal.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static String fileToBase64(File file) {
        String base64 = "";
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        try {
            BufferedInputStream buf = new BufferedInputStream(new FileInputStream(file));
            buf.read(bytes, 0, bytes.length);
            buf.close();
            base64 = Utils.toBase64(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return base64;
    }

    public static String toBase64(byte[] byteArray) {
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static Uri base64ToUri(String encoded, String fileName) throws Exception {
        byte[] decoded = Base64.decode((String)encoded, (int)0);
        return Utils.byteToUri(decoded, fileName);
    }

    public static Uri byteToUri(byte[] decoded, String fileName) throws Exception {
        String path = Conf.ROOT_PATH + fileName;
        try {
            File file2 = new File(path);
            FileOutputStream os = new FileOutputStream(file2, true);
            os.write(decoded);
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return Uri.parse((String)path);
    }

    public static String getFileExt(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
    }

    public static Bitmap rotateImage(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static File compressImage(Context context, Uri uri) {
        return Utils.compressImage(Utils.getRealPathFromURI(context, uri));
    }

    public static File compressImage(String filePath) {
        Bitmap scaledBitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float maxHeight = 816.0f;
        float maxWidth = 612.0f;
        float imgRatio = actualWidth / actualHeight;
        float maxRatio = maxWidth / maxHeight;
        if ((float)actualHeight > maxHeight || (float)actualWidth > maxWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = maxHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = (int)maxHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = maxWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = (int)maxWidth;
            } else {
                actualHeight = (int)maxHeight;
                actualWidth = (int)maxWidth;
            }
        }
        options.inSampleSize = Utils.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        try {
            ExifInterface exif = new ExifInterface(filePath);
            int orientation = exif.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            if (orientation == 6) {
                matrix.postRotate(90.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 3) {
                matrix.postRotate(180.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            } else if (orientation == 8) {
                matrix.postRotate(270.0f);
                Log.d((String)"EXIF", (String)("Exif: " + orientation));
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream out = null;
        String filename = Utils.getFilename();
        try {
            out = new FileOutputStream(filename);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return new File(filename);
    }

    public static String getRealPathFromURI(Context context, Uri uri) {
        Uri queryUri = MediaStore.Files.getContentUri((String)"external");
        if (uri.toString().contains("/storage/emulated/0") || uri.toString().contains("/storage/sdcard0")) {
            queryUri = MediaStore.Files.getContentUri((String)"internal");
        }
        String columnData = "_data";
        String columnSize = "_size";
        String[] projectionData = new String[]{"_data"};
        String name = null;
        String size = null;
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null && cursor.getCount() > 0) {
            int nameIndex = cursor.getColumnIndex("_display_name");
            int sizeIndex = cursor.getColumnIndex("_size");
            cursor.moveToFirst();
            name = cursor.getString(nameIndex);
            size = cursor.getString(sizeIndex);
            cursor.close();
        }
        String imagePath = "";
        if (name != null && size != null) {
            String selectionNS = columnData + " LIKE '%" + name + "' AND " + columnSize + "='" + size + "'";
            Cursor cursorLike = context.getContentResolver().query(queryUri, projectionData, selectionNS, null, null);
            if (cursorLike != null && cursorLike.getCount() > 0) {
                cursorLike.moveToFirst();
                int indexData = cursorLike.getColumnIndex(columnData);
                if (cursorLike.getString(indexData) != null) {
                    imagePath = cursorLike.getString(indexData);
                }
                cursorLike.close();
            }
        }
        return imagePath;
    }

    public static String getFilename() {
        File file = new File(Environment.getExternalStorageDirectory().getPath(), "SIGGI/");
        if (!file.exists()) {
            file.mkdirs();
        }
        String uriString = file.getAbsolutePath() + "/" + System.currentTimeMillis() + ".jpg";
        return uriString;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    public static Gson getGson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getAnnotation(Expose.class) != null;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        }});
        gsonBuilder.disableHtmlEscaping();
        return gsonBuilder.serializeNulls().create();
    }

    public static void writeToFile(String data, Context context) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(context.openFileOutput("config.txt", 0));
            outputStreamWriter.write(data);
            outputStreamWriter.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("File write failed: " + e.toString()));
        }
    }

    public static String exceptionToString(Exception e) {
        if (e != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Excepci\u00f3n: ");
            sb.append(e.getMessage());
            sb.append("\n");
            StackTraceElement[] array = e.getStackTrace();
            if (array != null) {
                for (int i = 0; i < array.length; ++i) {
                    StackTraceElement element = array[i];
                    if (element.getClassName() != null) {
                        sb.append("Class name: ");
                        sb.append(element.getClassName());
                        sb.append("\n");
                    }
                    if (element.getFileName() != null) {
                        sb.append("File name: ");
                        sb.append(element.getFileName());
                        sb.append("\n");
                    }
                    if (element.getMethodName() != null) {
                        sb.append("Method name: ");
                        sb.append(element.getMethodName());
                        sb.append("\n");
                    }
                    sb.append("Line number: ");
                    sb.append(element.getLineNumber());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        return "Exception is null";
    }

    public static String getCurrentDate() {
        String strDate = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss", Locale.US);
            Calendar cal = Calendar.getInstance();
            strDate = sdf.format(cal.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDate;
    }

    public static void traces(String text) {
        if (Conf.ENABLE_LOG_TRACE) {
            Utils.appendLog(Utils.getCurrentDate() + ": " + text, "notificatorTrace");
        }
    }

    private static void appendLog(String text, String name) {
        File logFile = new File("sdcard/" + name + ".txt");
        if (!logFile.exists()) {
            try {
                logFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            BufferedWriter buf = new BufferedWriter(new FileWriter(logFile, true));
            buf.append(text);
            buf.newLine();
            buf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isServiceRunning(Class<?> serviceClass, Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    public static String readFromFile(Context context) {
        String ret = "";
        try {
            FileInputStream inputStream = context.openFileInput("config.txt");
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";
                StringBuilder stringBuilder = new StringBuilder();
                while ((receiveString = bufferedReader.readLine()) != null) {
                    stringBuilder.append(receiveString);
                }
                ((InputStream)inputStream).close();
                ret = stringBuilder.toString();
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("File not found: " + e.toString()));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Can not read file: " + e.toString()));
        }
        return ret;
    }

    public static boolean isConnect(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting();
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getImei(Context context) {
        String imei = "";
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            if (Build.VERSION.SDK_INT >= 23) {
                if (Build.VERSION.SDK_INT >= 29) {
                    imei = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                } else if (Build.VERSION.SDK_INT >= 26) {
                    imei = telephonyManager.getImei();
                } else if (telephonyManager.getDeviceId().length() > 14) {
                    imei = telephonyManager.getDeviceId();
                } else if (telephonyManager.getDeviceId(1) != null && telephonyManager.getDeviceId(1).length() > 14) {
                    imei = telephonyManager.getDeviceId(1);
                } else if (telephonyManager.getDeviceId(2) != null && telephonyManager.getDeviceId(2).length() > 14) {
                    imei = telephonyManager.getDeviceId(2);
                }
            } else {
                imei = telephonyManager.getDeviceId();
            }
        }
        return imei;
    }

    public static class MESSAGE_TYPE {
        public static final String MESSAGE = "Message";
        public static final String AUDIO = "audio";
        public static final String PHOTO = "photo";
        public static final String VIDEO = "video";
        public static final String FILE = "file";
    }
}

