/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.MessengerReceiver;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class WebSocketPTTService
extends Service {
    public String TAG = WebSocketPTTService.class.getSimpleName();
    public static final String MESSAGE_PTT = "messagePtt";
    private OkHttpClient pttClient;
    private WebSocket webSocket;
    private String name;
    private String imei;
    private String idGroup;
    private String apiKey;

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26) {
            this.startMyOwnForeground();
        } else {
            this.startForeground(Conf.COMM_NOTIFICATION_FOREGROUND_ID, new Notification());
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        try {
            Bundle extras = intent.getExtras();
            if (extras != null) {
                this.name = extras.getString("name");
                this.idGroup = String.valueOf(extras.getInt("idGroup"));
                this.imei = extras.getString("imei");
                this.apiKey = extras.getString("apiKey");
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        WebSocketPTTService.this.pttWebSocketConnection();
                    }
                }).start();
            }
        }
        catch (Exception ex) {
            Log.d((String)"intent.getExtras", (String)("Error: " + ex.getMessage()));
        }
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        super.onDestroy();
        Utils.traces("WebSocketPTTService onDestroy");
        try {
            if (this.webSocket != null) {
                this.webSocket.close(1000, "onDestroy");
            }
        }
        catch (Exception e) {
            Utils.traces("WebSocketPTTService onDestroy Ex: " + Utils.exceptionToString(e));
        }
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        this.stopSelf();
    }

    @RequiresApi(api=26)
    private void startMyOwnForeground() {
        NotificationChannel chan = new NotificationChannel(Conf.COMM_NOTIFICATION_CHANNEL_ID, (CharSequence)Conf.COMM_NOTIFICATION_CHANNEL_NAME, 0);
        chan.setLightColor(-16776961);
        chan.setLockscreenVisibility(0);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        assert (manager != null);
        manager.createNotificationChannel(chan);
        NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder((Context)this, Conf.COMM_NOTIFICATION_CHANNEL_ID);
        Notification notification = notificationBuilder.setOngoing(true).setSmallIcon(R.drawable.ic_s_notification).setContentTitle((CharSequence)Conf.COMM_NOTIFICATION_CONTENT_TITLE).setPriority(1).setCategory("service").build();
        this.startForeground(Conf.COMM_NOTIFICATION_FOREGROUND_ID, notification);
    }

    private void pttWebSocketConnection() {
        try {
            this.pttClient = new OkHttpClient();
            String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_WS_PORT + "?imei=" + this.imei + "&groupId=" + this.idGroup + "&API_KEY=" + this.apiKey + "&clientName=" + this.name;
            Request requestCoinPrice = new Request.Builder().url(url).build();
            WebSocketListener webSocketListener = new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    Utils.traces("PttWebSocketConnection onOpen");
                }

                public void onMessage(WebSocket webSocket, String text) {
                    Log.e((String)WebSocketPTTService.this.TAG, (String)("MESSAGE String: " + text));
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    try {
                        Intent intent = new Intent((Context)WebSocketPTTService.this, MessengerReceiver.class);
                        intent.putExtra(WebSocketPTTService.MESSAGE_PTT, bytes.toByteArray());
                        WebSocketPTTService.this.sendBroadcast(intent);
                    }
                    catch (Exception ex) {
                        Utils.traces("PttWebSocketConnection onMessage: " + Utils.exceptionToString(ex));
                    }
                }

                public void onClosing(WebSocket webSocket, int code, String reason) {
                    webSocket.close(1000, null);
                    webSocket.cancel();
                    Utils.traces("PttWebSocketConnection onClosing code: " + code + " reason: " + reason);
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    Utils.traces("PttWebSocketConnection onClosed code: " + code + " reason: " + reason);
                }

                public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                    WebSocketPTTService.this.pttWebSocketConnection();
                }
            };
            this.webSocket = this.pttClient.newWebSocket(requestCoinPrice, webSocketListener);
            this.pttClient.dispatcher().executorService().shutdown();
        }
        catch (Exception e) {
            Utils.traces("PttWebSocketConnection catch: " + Utils.exceptionToString(e));
        }
    }
}

