/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.os.Handler;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPSocket {
    private int LocalPort = 80;
    private final Handler mHandler;
    private UDPThread SocketRecv;

    UDPSocket(Handler handler, int localport) {
        this.LocalPort = localport;
        this.mHandler = handler;
        if (localport <= 1024) {
            Log.e((String)"UDP", (String)"UDPSocket");
        }
    }

    public void startRecv() {
        this.SocketRecv = new UDPThread();
        this.SocketRecv.setRecv_Flag(true);
        this.SocketRecv.start();
    }

    public void Send(String message, String address, int port) {
        this.SocketRecv.setRecv_Flag(false);
        UDPThread SocketSend = new UDPThread();
        SocketSend.write(message, address, port);
        SocketSend.start();
    }

    protected void connectServerWithTCPSocket(String msg, String addrServer, int localPort) {
        try {
            Socket socket = new Socket(addrServer, localPort);
            OutputStream outputStream = socket.getOutputStream();
            byte[] buffer = msg.getBytes();
            outputStream.flush();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void ServerReceviedByTcp() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(1989);
            Socket socket = serverSocket.accept();
            InputStream inputStream = socket.getInputStream();
            byte[] buffer = new byte[4096];
            int temp = 0;
            while ((temp = inputStream.read(buffer)) != -1) {
                System.out.println(new String(buffer, 0, temp));
            }
            serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class UDPThread
    extends Thread {
        private DatagramSocket mm_socket;
        private byte[] mm_data;
        private boolean Send_Flag = false;
        private boolean Recv_Flag = false;
        private String des_Address;
        private int desPort;

        UDPThread() {
            if (this.mm_socket == null) {
                try {
                    this.mm_socket = new DatagramSocket(null);
                    this.mm_socket.setReuseAddress(true);
                    this.mm_socket.bind(new InetSocketAddress(UDPSocket.this.LocalPort));
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void run() {
            if (this.Send_Flag) {
                this.SendDataToServer();
                this.Send_Flag = false;
            }
            while (this.Recv_Flag) {
                this.ReceiveServerSocketData();
            }
        }

        private void setRecv_Flag(boolean recv_Flag) {
            this.Recv_Flag = recv_Flag;
        }

        private void write(String command, String address, int port) {
            this.des_Address = address;
            this.desPort = port;
            this.mm_data = command.getBytes();
            this.Send_Flag = true;
        }

        private void SendDataToServer() {
            try {
                InetAddress serverAddress = InetAddress.getByName(this.des_Address);
                DatagramPacket packet = new DatagramPacket(this.mm_data, this.mm_data.length, serverAddress, this.desPort);
                this.mm_socket.send(packet);
                UDPSocket.this.mHandler.obtainMessage(2, packet.getLength(), -1, (Object)packet.getData()).sendToTarget();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void ReceiveServerSocketData() {
            try {
                byte[] data = new byte[3584];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                this.mm_socket.receive(packet);
                UDPSocket.this.mHandler.obtainMessage(1, packet.getLength(), -1, (Object)packet.getData()).sendToTarget();
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

