/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.StrictMode;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.app.ActivityCompat;
import com.konovalov.vad.VadConfig;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.CustomButtonAnimation;
import com.siggytech.utils.communication.Group;
import com.siggytech.utils.communication.MessengerHelper;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.StrokeGradientDrawable;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.WebSocketPTTService;
import com.siggytech.utils.communication.vad.VoiceRecorder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;

public class PTTButton
extends AppCompatButton
implements View.OnTouchListener,
VoiceRecorder.Listener {
    public static final String TOKEN_RELEASED_ERROR = "tokenReleasedError";
    private String TAG = "PTTButton";
    private static final String TOKEN_TAKEN = "token taked";
    public static final String TOKEN_RELEASED = "token released";
    private Padding mPadding;
    private int mHeight;
    private int mWidth;
    private int mColor;
    private int mCornerRadius;
    private int mStrokeWidth;
    private int mStrokeColor;
    protected boolean mAnimationInProgress;
    private StrokeGradientDrawable mDrawableNormal;
    private StrokeGradientDrawable mDrawablePressed;
    private String buttonName;
    private String sendingText = "";
    private List<Group> groupList = new ArrayList<Group>();
    private int groupIndex = 0;
    AudioTrack at;
    public static final int MESSAGE_READ = 1;
    public static final int MESSAGE_WRITE = 2;
    private int sampleRate = 44100;
    private int channelConfig = 16;
    private int audioFormat = 2;
    int minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
    public AudioRecord recorder;
    CountDownTimer timer;
    private String API_KEY;
    private String name;
    private Context context;
    private String username;
    private VadConfig.SampleRate DEFAULT_SAMPLE_RATE = VadConfig.SampleRate.SAMPLE_RATE_16K;
    private VadConfig.FrameSize DEFAULT_FRAME_SIZE = VadConfig.FrameSize.FRAME_SIZE_160;
    private VadConfig.Mode DEFAULT_MODE = VadConfig.Mode.VERY_AGGRESSIVE;
    private int DEFAULT_SILENCE_DURATION = 500;
    private int DEFAULT_VOICE_DURATION = 500;
    private VoiceRecorder vadRecorder;
    private VadConfig config;
    private boolean isTalking = false;
    private boolean voiceDetectionActivated;
    private BroadcastReceiver mNetworkReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            PTTButton.this.releaseTokenState();
        }
    };

    public PTTButton(Context context, String API_KEY, String nameClient, String username, int quality, boolean voiceDetection) {
        super(context);
        this.context = context;
        this.API_KEY = API_KEY;
        this.name = nameClient;
        this.username = username;
        this.voiceDetectionActivated = voiceDetection;
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        switch (quality) {
            case 1: {
                this.sampleRate = 44100;
                this.channelConfig = 16;
                this.audioFormat = 2;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
                break;
            }
            case 2: {
                this.sampleRate = 8000;
                this.channelConfig = 16;
                this.audioFormat = 2;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
                break;
            }
            case 3: {
                this.sampleRate = 8000;
                this.channelConfig = 16;
                this.audioFormat = 3;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
            }
        }
        this.getGroups();
        this.initView();
        MessengerHelper.setPttButton(this);
        if (voiceDetection) {
            this.setVadRecorder();
            this.vadRecorder.start();
        }
    }

    public void startVoiceActivation() {
        this.setVadRecorder();
        this.vadRecorder.start();
    }

    public void stopVoiceActivation() {
        this.vadRecorder.stop();
    }

    public void setVadRecorder() {
        this.config = VadConfig.newBuilder().setSampleRate(this.DEFAULT_SAMPLE_RATE).setFrameSize(this.DEFAULT_FRAME_SIZE).setMode(this.DEFAULT_MODE).setSilenceDurationMillis(this.DEFAULT_SILENCE_DURATION).setVoiceDurationMillis(this.DEFAULT_VOICE_DURATION).build();
        this.vadRecorder = new VoiceRecorder(this, this.config);
    }

    public void setGroupIndex(int groupIndex) {
        this.groupIndex = groupIndex;
    }

    private void getGroups() {
        this.groupList.add(new Group(9999L, "Every Group"));
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            String url = "http://" + Conf.SERVER_IP + ":" + Conf.TOKEN_PORT + "/getgroupsfordevice?imei=" + this.getIMEINumber() + "&API_KEY=" + this.API_KEY;
            HttpPost httpPost = new HttpPost(url);
            ArrayList params = new ArrayList();
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                JSONArray jsonArray = new JSONArray(EntityUtils.toString((HttpEntity)respEntity));
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.groupList.add(new Group(jsonArray.getJSONObject(i).getInt("idgroup"), jsonArray.getJSONObject(i).getString("name")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResume() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.context.registerReceiver(this.mNetworkReceiver, filter);
    }

    public void onPause() {
        if (this.mNetworkReceiver != null) {
            this.context.unregisterReceiver(this.mNetworkReceiver);
        }
    }

    public boolean startTalking() {
        if (Utils.isConnect(this.context)) {
            this.setPressed(true);
            if (this.requestToken()) {
                this.startStreaming();
                this.buttonName = this.getText().toString();
                this.setText(this.sendingText);
                MediaPlayer mp = MediaPlayer.create((Context)this.context, (int)R.raw.out);
                mp.start();
            } else {
                MediaPlayer mp = MediaPlayer.create((Context)this.context, (int)R.raw.busy);
                mp.start();
                this.setPressed(false);
                this.releaseTokenState();
                this.isTalking = false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean stopTalking() {
        if (this.isRecording()) {
            try {
                this.isTalking = false;
                this.recorder.release();
                this.blockTouch();
                this.leaveToken();
                MediaPlayer mp = MediaPlayer.create((Context)this.context, (int)R.raw.in);
                mp.start();
                this.timer = new CountDownTimer(3000L, 100L){

                    public void onTick(long millisUntilFinished) {
                    }

                    public void onFinish() {
                        PTTButton.this.setText(PTTButton.this.buttonName);
                        PTTButton.this.unblockTouch();
                        if (PTTButton.this.isVoiceDetectionActivated()) {
                            PTTButton.this.startVoiceActivation();
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                Log.e((String)"log", (String)("stopTalking: " + e.getMessage()));
            }
            this.setPressed(false);
            return true;
        }
        return false;
    }

    public boolean isRecording() {
        return this.recorder != null && this.recorder.getState() == 1 && this.recorder.getRecordingState() == 3;
    }

    private void releaseTokenState() {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        if (preferences != null && preferences.getBoolean(TOKEN_RELEASED_ERROR, false)) {
            this.leaveToken();
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.startTalking();
                return true;
            }
            case 1: {
                this.stopTalking();
            }
        }
        return false;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mHeight == 0 && this.mWidth == 0 && w != 0 && h != 0) {
            this.mHeight = this.getHeight();
            this.mWidth = this.getWidth();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        for (int x : this.getBackground().getState()) {
            if (x == 16842919 || !this.isRecording()) continue;
            this.stopTalking();
        }
    }

    private void startStreaming() {
        byte[] totalByteBuffer = new byte[5292000];
        final float[] tempFloatBuffer = new float[3];
        if (this.isVoiceDetectionActivated()) {
            this.stopVoiceActivation();
        }
        String message = "{ \"name\": \"" + this.name + "\",\"imei\": " + this.getIMEINumber() + ", \"api_key\": \"" + this.API_KEY + "\",\"idgroup\": " + this.groupList.get((int)this.groupIndex).idGroup + " }";
        Thread streamThread = new Thread(new MyRunnable(message){

            @Override
            public void run() {
                try {
                    int noiseAux = 0;
                    DatagramSocket socket = new DatagramSocket();
                    Log.d((String)"VS", (String)"Socket Created");
                    InetAddress destination = InetAddress.getByName(Conf.SERVER_IP);
                    DatagramPacket packet = new DatagramPacket(this.message.getBytes(), this.message.getBytes().length, destination, Conf.SERVER_PORT);
                    socket.send(packet);
                    PTTButton.this.minBufSize = AudioRecord.getMinBufferSize((int)PTTButton.this.sampleRate, (int)PTTButton.this.channelConfig, (int)PTTButton.this.audioFormat);
                    byte[] buffer = new byte[PTTButton.this.minBufSize];
                    Log.d((String)"VS", (String)("Buffer created of size " + PTTButton.this.minBufSize));
                    PTTButton.this.recorder = new AudioRecord(1, PTTButton.this.sampleRate, PTTButton.this.channelConfig, PTTButton.this.audioFormat, PTTButton.this.minBufSize * 10);
                    Log.d((String)"VS", (String)"Recorder initialized");
                    PTTButton.this.recorder.startRecording();
                    while (PTTButton.this.isRecording()) {
                        int tempIndex = 0;
                        PTTButton.this.minBufSize = PTTButton.this.recorder.read(buffer, 0, buffer.length);
                        packet = new DatagramPacket(buffer, buffer.length, destination, Conf.SERVER_PORT);
                        socket.send(packet);
                        float totalAbsValue = 0.0f;
                        short sample = 0;
                        if (!PTTButton.this.isVoiceDetectionActivated()) continue;
                        for (int i = 0; i < buffer.length; i += 2) {
                            sample = (short)(buffer[i] | buffer[i + 1] << 8);
                            totalAbsValue += (float)(Math.abs(sample) / (PTTButton.this.minBufSize / 2));
                        }
                        tempFloatBuffer[tempIndex % 3] = totalAbsValue;
                        float temp = 0.0f;
                        for (int i = 0; i < 3; ++i) {
                            temp += tempFloatBuffer[i];
                        }
                        if (temp >= 0.0f && temp <= 350.0f) {
                            ++tempIndex;
                            if (++noiseAux <= 50) continue;
                            Log.i((String)"TAG", (String)"no voice detected");
                            ((Activity)PTTButton.this.context).runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    PTTButton.this.stopTalking();
                                }
                            });
                            return;
                        }
                        if (!(temp > 350.0f)) continue;
                        noiseAux = 0;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)"VS", (String)"IOException");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        streamThread.start();
    }

    public boolean isVoiceDetectionActivated() {
        return this.voiceDetectionActivated;
    }

    public void setVoiceDetectionActivated(boolean voiceDetectionActivated) {
        this.voiceDetectionActivated = voiceDetectionActivated;
    }

    public List<Group> getGroupList() {
        return this.groupList;
    }

    public StrokeGradientDrawable getDrawableNormal() {
        return this.mDrawableNormal;
    }

    public void animation(@NonNull Params params) {
        if (!this.mAnimationInProgress) {
            this.mDrawablePressed.setColor(params.colorPressed);
            this.mDrawablePressed.setCornerRadius(params.cornerRadius);
            this.mDrawablePressed.setStrokeColor(params.strokeColor);
            this.mDrawablePressed.setStrokeWidth(params.strokeWidth);
            if (params.duration == 0) {
                this.aniBtWithoutAnimation(params);
            } else {
                this.aniBtWithAnimation(params);
            }
            this.mColor = params.color;
            this.mCornerRadius = params.cornerRadius;
            this.mStrokeWidth = params.strokeWidth;
            this.mStrokeColor = params.strokeColor;
        }
    }

    private void aniBtWithAnimation(final @NonNull Params params) {
        this.mAnimationInProgress = true;
        this.setText(null);
        this.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.setPadding(this.mPadding.left, this.mPadding.top, this.mPadding.right, this.mPadding.bottom);
        CustomButtonAnimation.Params animationParams = CustomButtonAnimation.Params.create(this).color(this.mColor, params.color).cornerRadius(this.mCornerRadius, params.cornerRadius).strokeWidth(this.mStrokeWidth, params.strokeWidth).strokeColor(this.mStrokeColor, params.strokeColor).height(this.getHeight(), params.height).width(this.getWidth(), params.width).duration(params.duration).listener(new CustomButtonAnimation.Listener(){

            @Override
            public void onAnimationEnd() {
                PTTButton.this.finalizeAnimation(params);
            }
        });
        CustomButtonAnimation animation = new CustomButtonAnimation(animationParams);
        animation.start();
    }

    private void aniBtWithoutAnimation(@NonNull Params params) {
        this.mDrawableNormal.setColor(params.color);
        this.mDrawableNormal.setCornerRadius(params.cornerRadius);
        this.mDrawableNormal.setStrokeColor(params.strokeColor);
        this.mDrawableNormal.setStrokeWidth(params.strokeWidth);
        if (params.width != 0 && params.height != 0) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.width = params.width;
            layoutParams.height = params.height;
            this.setLayoutParams(layoutParams);
        }
        this.finalizeAnimation(params);
    }

    private void finalizeAnimation(@NonNull Params params) {
        this.mAnimationInProgress = false;
        if (params.icon != 0 && params.text != null) {
            this.setIconLeft(params.icon);
            this.setText(params.text);
        } else if (params.icon != 0) {
            this.setIcon(params.icon);
        } else if (params.text != null) {
            this.setText(params.text);
        }
        if (params.animationListener != null) {
            params.animationListener.onAnimationEnd();
        }
    }

    public void blockTouch() {
        this.getBackground().setColorFilter(-7829368, PorterDuff.Mode.MULTIPLY);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void unblockTouch() {
        this.getBackground().setColorFilter(null);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        PTTButton.this.startTalking();
                        return true;
                    }
                    case 1: {
                        PTTButton.this.stopTalking();
                    }
                }
                return false;
            }
        });
    }

    private boolean requestToken() {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String url = "http://" + Conf.SERVER_IP + ":" + Conf.TOKEN_PORT + "/gettoken?imei=" + this.getIMEINumber() + "&groupId=" + this.groupList.get((int)this.groupIndex).idGroup + "&API_KEY=" + this.API_KEY + "&clientName=" + this.name + "&username=" + this.username;
        HttpPost httpPost = new HttpPost(url);
        ArrayList params = new ArrayList();
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                String content = EntityUtils.toString((HttpEntity)respEntity);
                Log.e((String)this.TAG, (String)content);
                return TOKEN_TAKEN.equals(content);
            }
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void leaveToken() {
        if (Utils.isConnect(this.context)) {
            try {
                DefaultHttpClient httpClient = new DefaultHttpClient();
                String url = "http://" + Conf.SERVER_IP + ":" + Conf.TOKEN_PORT + "/releasetoken?imei=" + this.getIMEINumber() + "&groupId=" + this.groupList.get((int)this.groupIndex).idGroup + "&API_KEY=" + this.API_KEY + "&clientName=" + this.name + "&username=" + this.username;
                HttpPost httpPost = new HttpPost(url);
                ArrayList params = new ArrayList();
                try {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity respEntity = response.getEntity();
                if (respEntity != null && TOKEN_RELEASED.equals(EntityUtils.toString((HttpEntity)respEntity))) {
                    PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean(TOKEN_RELEASED_ERROR, false).apply();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean(TOKEN_RELEASED_ERROR, true).apply();
            }
        } else {
            PreferenceManager.getDefaultSharedPreferences((Context)this.context).edit().putBoolean(TOKEN_RELEASED_ERROR, true).apply();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initView() {
        if (!Utils.isServiceRunning(WebSocketPTTService.class, this.context)) {
            Intent i = new Intent(this.context, WebSocketPTTService.class);
            i.putExtra("name", this.name);
            i.putExtra("idGroup", this.groupList.get((int)this.groupIndex).idGroup);
            i.putExtra("imei", this.getIMEINumber());
            i.putExtra("apiKey", this.API_KEY);
            this.context.startService(i);
        } else {
            Utils.traces("PTTButton WebSocketPTTService already exists");
        }
        int intSize = AudioTrack.getMinBufferSize((int)this.sampleRate, (int)4, (int)this.audioFormat);
        this.at = new AudioTrack(3, this.sampleRate, 4, this.audioFormat, intSize, 1);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        PTTButton.this.startTalking();
                        return true;
                    }
                    case 1: {
                        PTTButton.this.stopTalking();
                    }
                }
                return false;
            }
        });
        this.mPadding = new Padding();
        this.mPadding.left = this.getPaddingLeft();
        this.mPadding.right = this.getPaddingRight();
        this.mPadding.top = this.getPaddingTop();
        this.mPadding.bottom = this.getPaddingBottom();
        this.setBackgroundCompat(this.getResources().getDrawable(R.drawable.ptt_selector));
        this.setWidth(100);
        this.setHeight(100);
    }

    private String getIMEINumber() {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)this.context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }

    public void PlayShortAudioFileViaAudioTrack(byte[] byteData) throws IOException {
        if (this.at != null) {
            this.at.write(byteData, 0, byteData.length);
            this.at.play();
        } else {
            Log.d((String)"TCAudio", (String)"audio track is not initialised ");
        }
    }

    private StrokeGradientDrawable createDrawable(int color2, int cornerRadius, int strokeWidth) {
        StrokeGradientDrawable drawable2 = new StrokeGradientDrawable(new GradientDrawable());
        drawable2.getGradientDrawable().setShape(1);
        drawable2.setColor(color2);
        drawable2.setCornerRadius(cornerRadius);
        drawable2.setStrokeColor(color2);
        drawable2.setStrokeWidth(strokeWidth);
        return drawable2;
    }

    public void setBackgroundCompat(@Nullable Drawable drawable2) {
        if (Build.VERSION.SDK_INT <= 16) {
            this.setBackgroundDrawable(drawable2);
        } else {
            this.setBackground(drawable2);
        }
    }

    public void setIcon(final @DrawableRes int icon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Drawable drawable2 = PTTButton.this.getResources().getDrawable(icon);
                int padding = PTTButton.this.getWidth() / 2 - drawable2.getIntrinsicWidth() / 2;
                PTTButton.this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
                PTTButton.this.setPadding(padding, 0, 0, 0);
            }
        });
    }

    public void setIconLeft(@DrawableRes int icon) {
        this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
    }

    public void setSendingText(String sendingText) {
        this.sendingText = sendingText;
    }

    @Override
    public void onSpeechDetected() {
        System.out.println("Speech detected");
        if (!this.isTalking) {
            this.isTalking = true;
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PTTButton.this.startTalking();
                }
            });
        }
    }

    @Override
    public void onNoiseDetected() {
        if (this.isTalking) {
            this.isTalking = false;
            ((Activity)this.context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    PTTButton.this.stopTalking();
                }
            });
        }
    }

    public final class AudioQuality {
        public static final int HIGH = 1;
        public static final int MEDIUM = 2;
        public static final int LOW = 3;
    }

    public static class Params {
        private int cornerRadius;
        private int width;
        private int height;
        private int color;
        private int colorPressed;
        private int duration;
        private int icon;
        private int strokeWidth;
        private int strokeColor;
        private String text;
        private CustomButtonAnimation.Listener animationListener;

        private Params() {
        }

        public static Params create() {
            return new Params();
        }

        public Params text(@NonNull String text) {
            this.text = text;
            return this;
        }

        public Params icon(@DrawableRes int icon) {
            this.icon = icon;
            return this;
        }

        public Params cornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Params width(int width) {
            this.width = width;
            return this;
        }

        public Params height(int height) {
            this.height = height;
            return this;
        }

        public Params color(int color2) {
            this.color = color2;
            return this;
        }

        public Params colorPressed(int colorPressed) {
            this.colorPressed = colorPressed;
            return this;
        }

        public Params duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Params strokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Params strokeColor(int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Params animationListener(CustomButtonAnimation.Listener animationListener) {
            this.animationListener = animationListener;
            return this;
        }
    }

    private class Padding {
        public int left;
        public int right;
        public int top;
        public int bottom;

        private Padding() {
        }
    }

    public class MyRunnable
    implements Runnable {
        public String message;

        public MyRunnable(String parameter) {
            this.message = parameter;
        }

        @Override
        public void run() {
        }
    }
}

