/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.siggytech.utils.communication.PTTButton;
import com.siggytech.utils.communication.StrokeGradientDrawable;

public class CustomButtonAnimation {
    private Params mParams;

    public CustomButtonAnimation(@NonNull Params params) {
        this.mParams = params;
    }

    public void start() {
        StrokeGradientDrawable background = this.mParams.button.getDrawableNormal();
        ObjectAnimator cornerAnimation = ObjectAnimator.ofFloat((Object)background, (String)"cornerRadius", (float[])new float[]{this.mParams.fromCornerRadius, this.mParams.toCornerRadius});
        ObjectAnimator strokeWidthAnimation = ObjectAnimator.ofInt((Object)background, (String)"strokeWidth", (int[])new int[]{this.mParams.fromStrokeWidth, this.mParams.toStrokeWidth});
        ObjectAnimator strokeColorAnimation = ObjectAnimator.ofInt((Object)background, (String)"strokeColor", (int[])new int[]{this.mParams.fromStrokeColor, this.mParams.toStrokeColor});
        strokeColorAnimation.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        ObjectAnimator bgColorAnimation = ObjectAnimator.ofInt((Object)background, (String)"color", (int[])new int[]{this.mParams.fromColor, this.mParams.toColor});
        bgColorAnimation.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        ValueAnimator heightAnimation = ValueAnimator.ofInt((int[])new int[]{this.mParams.fromHeight, this.mParams.toHeight});
        heightAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CustomButtonAnimation.this.mParams.button.getLayoutParams();
                layoutParams.height = val;
                CustomButtonAnimation.this.mParams.button.setLayoutParams(layoutParams);
            }
        });
        ValueAnimator widthAnimation = ValueAnimator.ofInt((int[])new int[]{this.mParams.fromWidth, this.mParams.toWidth});
        widthAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int val = (Integer)valueAnimator.getAnimatedValue();
                ViewGroup.LayoutParams layoutParams = CustomButtonAnimation.this.mParams.button.getLayoutParams();
                layoutParams.width = val;
                CustomButtonAnimation.this.mParams.button.setLayoutParams(layoutParams);
            }
        });
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration((long)this.mParams.duration);
        animatorSet.playTogether(new Animator[]{strokeWidthAnimation, strokeColorAnimation, cornerAnimation, bgColorAnimation, heightAnimation, widthAnimation});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (CustomButtonAnimation.this.mParams.animationListener != null) {
                    CustomButtonAnimation.this.mParams.animationListener.onAnimationEnd();
                }
            }
        });
        animatorSet.start();
    }

    public static class Params {
        private float fromCornerRadius;
        private float toCornerRadius;
        private int fromHeight;
        private int toHeight;
        private int fromWidth;
        private int toWidth;
        private int fromColor;
        private int toColor;
        private int duration;
        private int fromStrokeWidth;
        private int toStrokeWidth;
        private int fromStrokeColor;
        private int toStrokeColor;
        private PTTButton button;
        private Listener animationListener;

        private Params(@NonNull PTTButton button) {
            this.button = button;
        }

        public static Params create(@NonNull PTTButton button) {
            return new Params(button);
        }

        public Params duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Params listener(@NonNull Listener animationListener) {
            this.animationListener = animationListener;
            return this;
        }

        public Params color(int fromColor, int toColor) {
            this.fromColor = fromColor;
            this.toColor = toColor;
            return this;
        }

        public Params cornerRadius(int fromCornerRadius, int toCornerRadius) {
            this.fromCornerRadius = fromCornerRadius;
            this.toCornerRadius = toCornerRadius;
            return this;
        }

        public Params height(int fromHeight, int toHeight) {
            this.fromHeight = fromHeight;
            this.toHeight = toHeight;
            return this;
        }

        public Params width(int fromWidth, int toWidth) {
            this.fromWidth = fromWidth;
            this.toWidth = toWidth;
            return this;
        }

        public Params strokeWidth(int fromStrokeWidth, int toStrokeWidth) {
            this.fromStrokeWidth = fromStrokeWidth;
            this.toStrokeWidth = toStrokeWidth;
            return this;
        }

        public Params strokeColor(int fromStrokeColor, int toStrokeColor) {
            this.fromStrokeColor = fromStrokeColor;
            this.toStrokeColor = toStrokeColor;
            return this;
        }
    }

    public static interface Listener {
        public void onAnimationEnd();
    }
}

