/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.siggytech.utils.communication.ChatModel;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.ImageActivity;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.VideoActivity;
import com.siggytech.view.MyImage;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;

public class CustomAdapterBubble
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String TAG = CustomAdapterBubble.class.getSimpleName();
    private List<ChatModel> lstChat;
    private Context context;
    private MediaPlayer mPlayer;
    private Activity mActivity;
    private static final int ITEM = 0;
    private static final int LOADING = 1;
    private boolean isLoadingAdded = false;

    public CustomAdapterBubble(List<ChatModel> lstChat, Context context, Activity activity) {
        this.lstChat = lstChat;
        this.context = context;
        this.mActivity = activity;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder = null;
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        switch (viewType) {
            case 0: {
                viewHolder = this.getViewHolder(parent, inflater);
                break;
            }
            case 1: {
                View v2 = inflater.inflate(R.layout.item_progress, parent, false);
                viewHolder = new LoadingViewHolder(v2);
            }
        }
        assert (viewHolder != null);
        return viewHolder;
    }

    @NonNull
    private RecyclerView.ViewHolder getViewHolder(ViewGroup parent, LayoutInflater inflater) {
        View v1 = inflater.inflate(R.layout.chat_cell_out, parent, false);
        MessageViewHolder viewHolder = new MessageViewHolder(v1);
        return viewHolder;
    }

    /*
     * Unable to fully structure code
     */
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        model = this.lstChat.get(position);
        switch (this.getItemViewType(position)) {
            case 0: {
                messageViewHolder = (MessageViewHolder)holder;
                if (model.isMine()) {
                    if (Build.VERSION.SDK_INT > 23) {
                        messageViewHolder.lnMessage.setBackgroundResource(R.drawable.bubble_nine_pach);
                    } else {
                        messageViewHolder.lnMessage.setBackgroundResource(R.drawable.mine_bubble);
                    }
                    messageViewHolder.lnLayout.setGravity(0x800005);
                } else {
                    if (Build.VERSION.SDK_INT > 23) {
                        messageViewHolder.lnMessage.setBackgroundResource(R.drawable.bubble_nine_pach_agent);
                    } else {
                        messageViewHolder.lnMessage.setBackgroundResource(R.drawable.other_bubble);
                    }
                    messageViewHolder.lnLayout.setGravity(0x800003);
                }
                messageViewHolder.chat_out_from.setText((CharSequence)model.getFromMessage());
                messageViewHolder.chat_text_datetime.setText((CharSequence)model.getDateTimeMessage());
                if (!"Message".equals(model.getMessageModel().getType())) ** GOTO lbl25
                messageViewHolder.lnAudio.setVisibility(8);
                messageViewHolder.ivPreviewImage.setVisibility(8);
                messageViewHolder.chat_out_text.setVisibility(0);
                messageViewHolder.chat_out_text.setText((CharSequence)model.getMessageModel().getMessage());
                ** GOTO lbl94
lbl25:
                // 1 sources

                if (!"audio".equals(model.getMessageModel().getType())) ** GOTO lbl40
                messageViewHolder.lnAudio.setVisibility(0);
                messageViewHolder.ivPreviewImage.setVisibility(8);
                messageViewHolder.chat_out_text.setVisibility(8);
                messageViewHolder.tvAudioDuration.setText((CharSequence)this.getDurationString(model.getMessageModel().getDuration()));
                messageViewHolder.tvAudioDuration.setTag((Object)this.getDurationString(model.getMessageModel().getDuration()));
                try {
                    if (!model.isMine()) ** GOTO lbl35
                    messageViewHolder.audioUri = Utils.base64ToUri(model.getMessageModel().getMessage(), Utils.getDateName() + ".3gp");
                    ** GOTO lbl94
lbl35:
                    // 1 sources

                    messageViewHolder.audioUri = Uri.parse((String)this.getDownloadUrl(model.getMessageModel().getMessage()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ** GOTO lbl94
lbl40:
                // 1 sources

                if (!"video".equals(model.getMessageModel().getType())) ** GOTO lbl67
                messageViewHolder.chat_out_text.setVisibility(8);
                messageViewHolder.lnAudio.setVisibility(8);
                messageViewHolder.ivPreviewImage.setVisibility(0);
                try {
                    if (!model.isMine()) ** GOTO lbl56
                    try {
                        messageViewHolder.uri = Utils.base64ToUri(model.getMessageModel().getMessage(), Utils.getDateName() + ".mp4");
                        decodedByte = ThumbnailUtils.createVideoThumbnail((String)messageViewHolder.uri.toString(), (int)1);
                        messageViewHolder.ivPreviewImage.setRoundImage(Bitmap.createScaledBitmap((Bitmap)decodedByte, (int)decodedByte.getWidth(), (int)decodedByte.getHeight(), (boolean)false));
                        messageViewHolder.ivPreviewImage.getProgressBar().hide();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    messageViewHolder.ivPreviewImage.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, lambda$onBindViewHolder$0(com.siggytech.utils.communication.CustomAdapterBubble$MessageViewHolder android.view.View ), (Landroid/view/View;)V)((CustomAdapterBubble)this, (MessageViewHolder)messageViewHolder));
                    ** GOTO lbl94
lbl56:
                    // 1 sources

                    videoUrl = this.getDownloadUrl(model.getMessageModel().getMessage());
                    thumb = 5000000L;
                    options = (RequestOptions)new RequestOptions().frame(thumb);
                    Glide.with((Context)this.context).load(videoUrl).apply((BaseRequestOptions)options).into(messageViewHolder.ivPreviewImage.getImageView());
                    messageViewHolder.ivPreviewImage.getProgressBar().hide();
                    messageViewHolder.ivPreviewImage.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, lambda$onBindViewHolder$1(java.lang.String android.view.View ), (Landroid/view/View;)V)((CustomAdapterBubble)this, (String)videoUrl));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ** GOTO lbl94
lbl67:
                // 1 sources

                if (!"photo".equals(model.getMessageModel().getType())) ** GOTO lbl94
                messageViewHolder.lnAudio.setVisibility(8);
                messageViewHolder.ivPreviewImage.setVisibility(0);
                messageViewHolder.chat_out_text.setVisibility(8);
                try {
                    if (!model.isMine()) ** GOTO lbl84
                    decodedString = Base64.decode((String)model.getMessageModel().getMessage(), (int)0);
                    decodedByte = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
                    messageViewHolder.ivPreviewImage.setRoundImage(Bitmap.createScaledBitmap((Bitmap)decodedByte, (int)decodedByte.getWidth(), (int)decodedByte.getHeight(), (boolean)false));
                    messageViewHolder.ivPreviewImage.getProgressBar().hide();
                    try {
                        messageViewHolder.uri = Utils.base64ToUri(model.getMessageModel().getMessage(), Utils.getDateName() + ".bmp");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    messageViewHolder.ivPreviewImage.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, lambda$onBindViewHolder$2(com.siggytech.utils.communication.CustomAdapterBubble$MessageViewHolder android.view.View ), (Landroid/view/View;)V)((CustomAdapterBubble)this, (MessageViewHolder)messageViewHolder));
                    ** GOTO lbl94
lbl84:
                    // 1 sources

                    url = this.getDownloadUrl(model.getMessageModel().getMessage());
                    thumb = 5000000L;
                    options = (RequestOptions)new RequestOptions().frame(thumb);
                    Glide.with((Context)this.context).load(url).apply((BaseRequestOptions)options).into(messageViewHolder.ivPreviewImage.getImageView());
                    messageViewHolder.ivPreviewImage.getProgressBar().hide();
                    messageViewHolder.ivPreviewImage.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, lambda$onBindViewHolder$3(java.lang.String android.view.View ), (Landroid/view/View;)V)((CustomAdapterBubble)this, (String)url));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
lbl94:
                // 11 sources

                messageViewHolder.chat_out_from.setTextColor(Conf.CHAT_COLOR_FROM);
                messageViewHolder.chat_out_text.setTextColor(Conf.CHAT_COLOR_TEXT);
                messageViewHolder.chat_text_datetime.setTextColor(Conf.CHAT_COLOR_DATE);
                messageViewHolder.tvAudioDuration.setTextColor(Conf.CHAT_COLOR_DATE);
                messageViewHolder.ivPlay.setTag((Object)false);
                messageViewHolder.ivPlay.setOnClickListener((View.OnClickListener)LambdaMetafactory.metafactory(null, null, null, (Landroid/view/View;)V, lambda$onBindViewHolder$4(com.siggytech.utils.communication.CustomAdapterBubble$MessageViewHolder android.view.View ), (Landroid/view/View;)V)((CustomAdapterBubble)this, (MessageViewHolder)messageViewHolder));
                messageViewHolder.sbPlay.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

                    public void onStartTrackingTouch(SeekBar seekBar) {
                    }

                    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
                        try {
                            if (fromTouch) {
                                CustomAdapterBubble.this.mPlayer.seekTo(progress * messageViewHolder.factor);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void onStopTrackingTouch(SeekBar seekBar) {
                    }
                });
                break;
            }
        }
    }

    public int getItemCount() {
        return this.lstChat == null ? 0 : this.lstChat.size();
    }

    public int getItemViewType(int position) {
        return position == 0 && this.isLoadingAdded ? 1 : 0;
    }

    public long getItemId(int position) {
        return position;
    }

    public void add(ChatModel chatModel) {
        this.lstChat.add(0, chatModel);
        this.notifyItemInserted(0);
    }

    public void addAll(List<ChatModel> mcList) {
        for (ChatModel mc : mcList) {
            this.add(mc);
        }
    }

    public void remove(ChatModel chatModel) {
        int position = this.lstChat.indexOf(chatModel);
        if (position > -1) {
            this.lstChat.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public void clear() {
        this.isLoadingAdded = false;
        while (this.getItemCount() > 0) {
            this.remove(this.getItem(0));
        }
    }

    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    public void addLoadingHeader() {
        this.isLoadingAdded = true;
        this.lstChat.add(0, new ChatModel());
        this.notifyItemInserted(0);
    }

    public void removeLoadingHeader() {
        this.isLoadingAdded = false;
        int position = 0;
        ChatModel item = this.getItem(position);
        if (item != null) {
            this.lstChat.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public ChatModel getItem(int position) {
        return this.lstChat.get(position);
    }

    private void stopPlaying(SeekBar mSeekBar, ImageView mImage) {
        try {
            this.mActivity.runOnUiThread(() -> {
                mImage.setTag((Object)false);
                mImage.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_play_arrow));
                mSeekBar.setProgress(0);
            });
            try {
                if (this.mPlayer != null) {
                    this.mPlayer.stop();
                    this.mPlayer.reset();
                    this.mPlayer = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeSeekBar(SeekBar mSeekBar, TextView tvDuration, ImageView mImage, int factor) {
        Log.d((String)TAG, (String)("TOTAL " + this.mPlayer.getDuration() / factor));
        mSeekBar.setMax(this.mPlayer.getDuration() / factor);
        new Thread(() -> {
            try {
                while (this.mPlayer != null && this.mPlayer.isPlaying() && this.mPlayer.getCurrentPosition() / factor < this.mPlayer.getDuration() / factor) {
                    int mCurrentPosition = this.mPlayer.getCurrentPosition() / factor;
                    mSeekBar.setProgress(mCurrentPosition);
                    this.mActivity.runOnUiThread(() -> {
                        if (this.mPlayer != null) {
                            try {
                                if (this.mPlayer.isPlaying()) {
                                    tvDuration.setText((CharSequence)this.getDurationString(this.mPlayer.getCurrentPosition() / 1000));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            tvDuration.setText((CharSequence)((String)tvDuration.getTag()));
                        }
                    });
                }
                if (this.mPlayer != null && this.mPlayer.getDuration() == this.mPlayer.getCurrentPosition()) {
                    this.stopPlaying(mSeekBar, mImage);
                }
                if (this.mPlayer != null && !this.mPlayer.isPlaying()) {
                    this.stopPlaying(mSeekBar, mImage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopPlaying(mSeekBar, mImage);
            }
        }).start();
    }

    private String getDurationString(int seconds) {
        int minutes = seconds / 60;
        return String.format("%02d:%02d", minutes, seconds %= 60);
    }

    private void goImageView(Uri uri) {
        try {
            Intent intent = new Intent(this.context, ImageActivity.class);
            intent.putExtra("ImageUri", uri.toString());
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goVideoView(Uri uri) {
        try {
            Intent intent = new Intent(this.context, VideoActivity.class);
            intent.putExtra("VideoUri", uri.toString());
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getDownloadUrl(String name) {
        return Conf.HTTP + "" + Conf.SERVER_IP + ":" + Conf.SERVER_IMAGE_PORT + "/" + name;
    }

    private /* synthetic */ void lambda$onBindViewHolder$4(MessageViewHolder messageViewHolder, View v) {
        try {
            if (!((Boolean)v.getTag()).booleanValue()) {
                this.stopPlaying(messageViewHolder.sbPlay, messageViewHolder.ivPlay);
                v.setTag((Object)true);
                ((ImageView)v).setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_pause));
                this.mPlayer = MediaPlayer.create((Context)this.context, (Uri)messageViewHolder.audioUri);
                this.mPlayer.start();
                this.initializeSeekBar(messageViewHolder.sbPlay, messageViewHolder.tvAudioDuration, messageViewHolder.ivPlay, messageViewHolder.factor);
            } else {
                this.stopPlaying(messageViewHolder.sbPlay, messageViewHolder.ivPlay);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$onBindViewHolder$3(String url, View v) {
        try {
            Intent intent = new Intent(this.context, ImageActivity.class);
            intent.putExtra("ImageUri", url);
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$onBindViewHolder$2(MessageViewHolder messageViewHolder, View v) {
        this.goImageView(messageViewHolder.uri);
    }

    private /* synthetic */ void lambda$onBindViewHolder$1(String videoUrl, View v) {
        try {
            Intent intent = new Intent(this.context, VideoActivity.class);
            intent.putExtra("VideoUri", videoUrl);
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$onBindViewHolder$0(MessageViewHolder messageViewHolder, View v) {
        this.goVideoView(messageViewHolder.uri);
    }

    protected static class MessageViewHolder
    extends RecyclerView.ViewHolder {
        LinearLayout lnLayout;
        LinearLayout lnMessage;
        LinearLayout lnDate;
        TextView chat_out_from;
        TextView chat_out_text;
        TextView chat_text_datetime;
        TextView tvDate;
        LinearLayout lnAudio;
        TextView tvAudioDuration;
        ImageView ivPlay;
        SeekBar sbPlay;
        Uri audioUri;
        Uri uri;
        int factor = 1;
        MyImage ivPreviewImage;

        public MessageViewHolder(View itemView) {
            super(itemView);
            this.lnLayout = (LinearLayout)itemView.findViewById(R.id.lnLayout);
            this.lnDate = (LinearLayout)itemView.findViewById(R.id.lnDate);
            this.lnMessage = (LinearLayout)itemView.findViewById(R.id.lnMessage);
            this.chat_out_from = (TextView)itemView.findViewById(R.id.chat_out_name);
            this.chat_out_text = (TextView)itemView.findViewById(R.id.chat_out_text);
            this.chat_text_datetime = (TextView)itemView.findViewById(R.id.chat_text_datetime);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.lnAudio = (LinearLayout)itemView.findViewById(R.id.lnAudio);
            this.tvAudioDuration = (TextView)itemView.findViewById(R.id.tvAudioDuration);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.sbPlay = (SeekBar)itemView.findViewById(R.id.sbPlay);
            this.ivPreviewImage = (MyImage)itemView.findViewById(R.id.ivPreviewImage);
        }
    }

    protected static class LoadingViewHolder
    extends RecyclerView.ViewHolder {
        public LoadingViewHolder(View itemView) {
            super(itemView);
        }
    }
}

