/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.FileProvider;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.FilePath;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import java.io.File;
import java.io.IOException;

public class UtilActivity
extends AppCompatActivity {
    private static final String TAG = UtilActivity.class.getSimpleName();
    private static final int ACTIVITY_START_CAMARA_APP = 0;
    private String mImageFileLocation = "";
    Context context = this;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(1);
        this.setContentView(R.layout.activity_util);
        System.out.println("Package name: " + this.getApplicationContext().getPackageName());
        if (this.getWindow() != null) {
            this.getWindow().setBackgroundDrawableResource(17170445);
            this.getWindow().setFlags(32, 32);
            this.getWindow().setFlags(262144, 262144);
        }
        LinearLayout lnCamera = (LinearLayout)this.findViewById(R.id.lnCamera);
        LinearLayout lnPhotoVideo = (LinearLayout)this.findViewById(R.id.lnPhotoVideo);
        LinearLayout lnCancel = (LinearLayout)this.findViewById(R.id.lnCancel);
        lnCamera.setOnClickListener(v -> this.takePhoto(v));
        lnPhotoVideo.setOnClickListener(v -> {
            Intent chooser = new Intent("android.intent.action.GET_CONTENT");
            Uri uri = Uri.parse((String)Environment.getDownloadCacheDirectory().getPath());
            chooser.addCategory("android.intent.category.OPENABLE");
            chooser.setDataAndType(uri, "*/*");
            chooser.setType("video/*, image/*");
            try {
                this.startActivityForResult(chooser, 100);
            }
            catch (ActivityNotFoundException ex) {
                Toast.makeText((Context)this.context, (CharSequence)"Por favor instale un gestor de archivos (File Manager).", (int)0).show();
            }
        });
        lnCancel.setOnClickListener(v -> this.finish());
        this.createFolder();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.v((String)TAG, (String)("Entro al onActivityResult del Main el codigo " + requestCode));
        if (requestCode == 0 && resultCode == -1) {
            this.setPathToFile(new File(this.mImageFileLocation).getAbsolutePath(), "photo");
            this.finish();
        } else if (requestCode == 0 && resultCode == 0) {
            this.finish();
        } else if (requestCode == 100 && data != null) {
            String selectedImagePath = FilePath.getPath(this.getApplicationContext(), data.getData());
            File filex = new File(selectedImagePath);
            if (filex.exists()) {
                Log.d((String)TAG, (String)"EXISTS");
            }
            switch (selectedImagePath.substring(selectedImagePath.lastIndexOf(".") + 1).toUpperCase()) {
                case "JPG": 
                case "JPEG": 
                case "BMP": 
                case "TIFF": 
                case "PNG": {
                    this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "photo");
                    break;
                }
                case "3GP": {
                    this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                    break;
                }
                case "MP4": {
                    this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                    break;
                }
                case "MPEG": {
                    this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "video");
                    break;
                }
                default: {
                    this.setPathToFile(FilePath.getPath(this.getApplicationContext(), data.getData()), "file");
                }
            }
            this.finish();
        }
    }

    public void takePhoto(View view) {
        Intent callCamaraApplicationIntent = new Intent();
        callCamaraApplicationIntent.setAction("android.media.action.IMAGE_CAPTURE");
        File photoFile = null;
        try {
            photoFile = this.createImageFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 24) {
            callCamaraApplicationIntent.putExtra("output", (Parcelable)FileProvider.getUriForFile((Context)this, (String)(this.getApplicationContext().getPackageName() + ".provider"), (File)photoFile));
        } else {
            callCamaraApplicationIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
        }
        this.startActivityForResult(callCamaraApplicationIntent, 0);
    }

    private File createImageFile() throws IOException {
        File storageDirectory = new File(Conf.ROOT_PATH);
        String imageFileName = Utils.GetDateName();
        File image = File.createTempFile(imageFileName, ".jpg", storageDirectory);
        this.mImageFileLocation = image.getAbsolutePath();
        return image;
    }

    private void createFolder() {
        File directory = new File(Conf.ROOT_PATH);
        try {
            if (directory.mkdirs()) {
                Log.v((String)TAG, (String)"Directory created");
            } else {
                Log.v((String)TAG, (String)"Directory is not created");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onStart() {
        super.onStart();
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("pickFile", true);
        editor.commit();
    }

    private void setPathToFile(String abolutePath, String type) {
        SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)this);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean("pickFile", false);
        editor.putString("pathToFile", abolutePath);
        editor.putString("fileType", type);
        editor.commit();
    }
}

