/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.MessengerBroadcastReceiver;
import com.siggytech.utils.communication.R;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Timer;
import java.util.TimerTask;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.json.JSONObject;

public class MessengerService
extends Service {
    public static final int MESSAGE_READ = 1;
    public static final int MESSAGE_WRITE = 2;
    public int LocalPort = 1984;
    public Context context;
    public String TAG = "MessengerService";
    public static String packageName;
    public static String messageTittle;
    public static String imei;
    public static String clientname;
    public static String api_key;
    public static String messageText;
    public static String idgroup;
    WebSocketListener webSocketListenerCoinPrice;
    OkHttpClient clientCoinPrice;
    Response responseObj;
    private Timer timer;
    private TimerTask timerTask;

    public MessengerService(Context applicationContext) {
        this.context = applicationContext;
        Log.i((String)"HERE", (String)"here I am!");
    }

    public MessengerService() {
    }

    public void onCreate() {
        super.onCreate();
        this.startForeground(1, new Notification());
    }

    public void onStart(Intent intent, int startid) {
        this.context = this.getApplicationContext();
        try {
            Bundle extras = intent.getExtras();
            if (extras == null) {
                Log.d((String)this.TAG, (String)"extras null");
                String res = this.readFromFile(this.context);
                String[] resArray = res.split(";");
                imei = resArray[0];
                clientname = resArray[1];
                api_key = resArray[2];
                idgroup = resArray[3];
            } else {
                Log.d((String)this.TAG, (String)"extras not null");
                imei = extras.get("imei").toString();
                clientname = extras.get("clientname").toString();
                api_key = extras.get("api_key").toString();
                idgroup = extras.get("groupid").toString();
                this.writeToFile(imei + ";" + clientname + ";" + api_key + ";" + String.valueOf(idgroup), this.context);
            }
        }
        catch (Exception ex) {
            Log.d((String)"intent.getExtras", (String)("Error: " + ex.getMessage()));
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        this.context = this.getApplicationContext();
        try {
            Bundle extras = intent.getExtras();
            if (extras == null) {
                Log.d((String)"Service", (String)"null");
            } else {
                Log.d((String)"Service", (String)"not null");
                packageName = extras.get("packageName").toString();
            }
        }
        catch (Exception ex) {
            Log.d((String)"intent.getExtras", (String)("Error: " + ex.getMessage()));
        }
        this.startTimer();
        return 1;
    }

    private void webSocketConnection() {
        this.clientCoinPrice = new OkHttpClient();
        String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_MSG_PORT + "?imei=" + imei + "&groupId=" + idgroup + "&API_KEY=" + api_key + "&clientName=" + clientname;
        Request requestCoinPrice = new Request.Builder().url(url).build();
        this.webSocketListenerCoinPrice = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                MessengerService.this.responseObj = response;
            }

            public void onMessage(WebSocket webSocket, String text) {
                try {
                    JSONObject obj = new JSONObject(text);
                    MessengerService.this.addNotification(obj.getString("messageTittle"), obj.getString("messageText"), obj.getString("packageName"), obj.getInt("resIcon"), obj.getString("notificationMessage"));
                }
                catch (Exception ex) {
                    Log.e((String)MessengerService.this.TAG, (String)("Error MESSAGE String: " + ex.getMessage()));
                }
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                webSocket.cancel();
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            }
        };
        this.clientCoinPrice.newWebSocket(requestCoinPrice, this.webSocketListenerCoinPrice);
        this.clientCoinPrice.dispatcher().executorService().shutdown();
    }

    public void onDestroy() {
        super.onDestroy();
        Log.e((String)"EXIT", (String)"ondestroy!");
        this.responseObj.body().close();
        Intent broadcastIntent = new Intent((Context)this, MessengerBroadcastReceiver.class);
        this.sendBroadcast(broadcastIntent);
    }

    public void startTimer() {
        this.timer = new Timer();
        this.initializeTimerTask();
        this.timer.schedule(this.timerTask, 1000L, 1000L);
        this.webSocketConnection();
    }

    public void initializeTimerTask() {
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
            }
        };
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void addNotification(String title, String text, String packageName, int resIcon, String notificationMessage) {
        PackageManager pmg = this.context.getPackageManager();
        String name = "";
        Intent LaunchIntent = null;
        try {
            if (pmg != null) {
                ApplicationInfo app = this.context.getPackageManager().getApplicationInfo(packageName, 0);
                name = (String)pmg.getApplicationLabel(app);
                LaunchIntent = pmg.getLaunchIntentForPackage(packageName);
            }
            Log.d((String)"intent.getExtras", (String)("Found!: " + name));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        Intent intent = LaunchIntent;
        intent.putExtra("notificationMessage", notificationMessage);
        intent.addFlags(0x24000000);
        PendingIntent pIntent = PendingIntent.getActivity((Context)this.context, (int)0, (Intent)intent, (int)0x40000000);
        Uri uri = RingtoneManager.getDefaultUri((int)2);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.context).setSmallIcon(R.drawable.ic_launcher_round).setContentTitle((CharSequence)title).setContentText((CharSequence)text).setContentIntent(pIntent).setSound(uri).setSmallIcon(resIcon).setAutoCancel(true);
        NotificationManager manager = (NotificationManager)this.context.getSystemService("notification");
        if (Build.VERSION.SDK_INT >= 26) {
            String channelId = "Your_channel_id";
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)"Channel human readable title", 3);
            manager.createNotificationChannel(channel);
            builder.setChannelId(channelId);
        }
        manager.notify(0, builder.build());
        PowerManager pm = (PowerManager)this.context.getSystemService("power");
        boolean isScreenOn = pm.isScreenOn();
        Log.e((String)"screen on.........", (String)("" + isScreenOn));
        if (!isScreenOn) {
            PowerManager.WakeLock wl = pm.newWakeLock(805306394, "MyLock");
            wl.acquire(10000L);
            PowerManager.WakeLock wl_cpu = pm.newWakeLock(1, "MyCpuLock");
            wl_cpu.acquire(10000L);
        }
    }

    private void writeToFile(String data, Context context) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(context.openFileOutput("config.txt", 0));
            outputStreamWriter.write(data);
            outputStreamWriter.close();
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("File write failed: " + e.toString()));
        }
    }

    private String readFromFile(Context context) {
        String ret = "";
        try {
            FileInputStream inputStream = context.openFileInput("config.txt");
            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";
                StringBuilder stringBuilder = new StringBuilder();
                while ((receiveString = bufferedReader.readLine()) != null) {
                    stringBuilder.append(receiveString);
                }
                ((InputStream)inputStream).close();
                ret = stringBuilder.toString();
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)this.TAG, (String)("File not found: " + e.toString()));
        }
        catch (IOException e) {
            Log.e((String)this.TAG, (String)("Can not read file: " + e.toString()));
        }
        return ret;
    }
}

