/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.ImageActivity;
import com.siggytech.utils.communication.VideoActivity;
import com.siggytech.view.MyImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownloadTask {
    private static final String TAG = DownloadTask.class.getSimpleName();
    private Context context;
    private String downloadUrl = "";
    private String downloadFileName = "";
    private MyImage mImage;
    private String mType;

    public DownloadTask(Context context, String downloadUrl, MyImage imageView, String type) {
        this.context = context;
        this.downloadUrl = downloadUrl;
        this.mImage = imageView;
        this.downloadFileName = downloadUrl.substring(downloadUrl.lastIndexOf(47), downloadUrl.length());
        this.mType = type;
        new DownloadingTask().execute(new Void[0]);
    }

    private class DownloadingTask
    extends AsyncTask<Void, Void, Void> {
        File fileStorage = null;
        File outputFile = null;

        private DownloadingTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            DownloadTask.this.mImage.getProgressBar().show();
        }

        protected void onPostExecute(Void result) {
            block7: {
                try {
                    if (this.outputFile != null) {
                        Uri uri = Uri.parse((String)this.outputFile.getPath());
                        if ("video".equals(DownloadTask.this.mType)) {
                            Bitmap decodedByte = ThumbnailUtils.createVideoThumbnail((String)uri.toString(), (int)1);
                            DownloadTask.this.mImage.setRoundImage(Bitmap.createScaledBitmap((Bitmap)decodedByte, (int)decodedByte.getWidth(), (int)decodedByte.getHeight(), (boolean)false));
                        } else {
                            DownloadTask.this.mImage.setRoundImage(BitmapFactory.decodeFile((String)this.outputFile.getPath()));
                        }
                        DownloadTask.this.mImage.getProgressBar().hide();
                        DownloadTask.this.mImage.setOnClickListener(v -> {
                            try {
                                if ("video".equals(DownloadTask.this.mType)) {
                                    Intent intent = new Intent(DownloadTask.this.context, VideoActivity.class);
                                    intent.putExtra("VideoUri", uri.toString());
                                    DownloadTask.this.context.startActivity(intent);
                                } else {
                                    Intent intent = new Intent(DownloadTask.this.context, ImageActivity.class);
                                    intent.putExtra("ImageUri", uri.toString());
                                    DownloadTask.this.context.startActivity(intent);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    } else {
                        new Handler().postDelayed(() -> {}, 3000L);
                        Toast.makeText((Context)DownloadTask.this.context, (CharSequence)"Fail", (int)0).show();
                        if (this.outputFile.exists()) {
                            this.outputFile.delete();
                        }
                        DownloadTask.this.mImage.getProgressBar().hide();
                        DownloadTask.this.mImage.getImageView().setImageDrawable((Drawable)new ColorDrawable(-65536));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    new Handler().postDelayed(() -> {}, 3000L);
                    Log.e((String)TAG, (String)("Download Failed with Exception - " + e.getLocalizedMessage()));
                    if (this.outputFile == null || !this.outputFile.exists()) break block7;
                    this.outputFile.delete();
                }
            }
            super.onPostExecute((Object)result);
        }

        protected Void doInBackground(Void ... arg0) {
            try {
                URL url = new URL(DownloadTask.this.downloadUrl);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                c.setRequestMethod("GET");
                c.connect();
                if (c.getResponseCode() != 200) {
                    Log.e((String)TAG, (String)("Server returned HTTP " + c.getResponseCode() + " " + c.getResponseMessage()));
                }
                this.fileStorage = new File(Conf.ROOT_PATH);
                if (!this.fileStorage.exists()) {
                    this.fileStorage.mkdir();
                    Log.e((String)TAG, (String)"Directory Created.");
                }
                this.outputFile = new File(this.fileStorage, DownloadTask.this.downloadFileName);
                if (!this.outputFile.exists()) {
                    this.outputFile.createNewFile();
                    Log.e((String)TAG, (String)"File Created");
                }
                FileOutputStream fos = new FileOutputStream(this.outputFile);
                InputStream is = c.getInputStream();
                byte[] buffer = new byte[1024];
                int len1 = 0;
                while ((len1 = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, len1);
                }
                fos.close();
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.outputFile = null;
                Log.e((String)TAG, (String)("Download Error Exception " + e.getMessage()));
            }
            return null;
        }
    }
}

