/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication.audio;

import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;

public class AudioRecorder {
    final MediaRecorder recorder = new MediaRecorder();
    final String path;
    private int duration;
    public MediaRecorder.OnErrorListener l = new MediaRecorder.OnErrorListener(){

        public void onError(MediaRecorder mr, int what, int extra) {
            Log.e((String)"error in recording", (String)("" + what + " ,reason " + extra));
        }
    };

    public AudioRecorder(String path) {
        this.path = path;
    }

    private String sanitizePath(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.contains(".")) {
            path = path + ".3gp";
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath() + path;
    }

    public void start() throws IOException {
        String state = Environment.getExternalStorageState();
        if (!state.equals("mounted")) {
            throw new IOException("SD Card is not mounted. It is " + state + ".");
        }
        File directory = new File(this.path).getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Path to file could not be created.");
        }
        this.recorder.setAudioSource(1);
        this.recorder.setOutputFormat(1);
        this.recorder.setAudioEncoder(1);
        this.recorder.setOutputFile(this.path);
        this.recorder.prepare();
        this.recorder.start();
        this.recorder.setOnErrorListener(this.l);
    }

    public void stop() throws IOException {
        this.recorder.stop();
    }

    public void recordAudio() {
        try {
            MediaRecorder newRecorder = new MediaRecorder();
            newRecorder.setAudioSource(1);
            newRecorder.setOutputFormat(1);
            newRecorder.setAudioEncoder(1);
            newRecorder.setOutputFile("/sdcard/testRecord.3gp");
            newRecorder.prepare();
            newRecorder.start();
        }
        catch (Exception e) {
            Log.e((String)"exception recordAudio", (String)("" + e));
        }
    }

    public int getMaxAmplitude() {
        return this.recorder.getMaxAmplitude();
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }
}

