/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.ws.RealWebSocket;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;

public class Socket {
    private static final String TAG = Socket.class.getSimpleName();
    private static final String CLOSE_REASON = "End of session";
    private static final int MAX_COLLISION = 7;
    public static final String EVENT_OPEN = "open";
    public static final String EVENT_RECONNECT_ATTEMPT = "reconnecting";
    public static final String EVENT_CLOSED = "closed";
    private static OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
    private static State state;
    private static Request request;
    private static RealWebSocket realWebSocket;
    private static Handler delayedReconnection;
    private static Map<String, OnEventListener> eventListener;
    private static Map<String, OnEventResponseListener> eventResponseListener;
    private static Map<String, String> onOpenMessageQueue;
    private static OnStateChangeListener onChangeStateListener;
    private static OnMessageListener messageListener;
    private static int reconnectionAttempts;
    private static boolean skipOnFailure;
    private WebSocketListener webSocketListener = new WebSocketListener(){

        public void onOpen(WebSocket webSocket, Response response) {
            Log.v((String)TAG, (String)"Socket has been opened successfully.");
            reconnectionAttempts = 0;
            if (eventListener.get(Socket.EVENT_OPEN) != null) {
                ((OnEventListener)eventListener.get(Socket.EVENT_OPEN)).onMessage(Socket.this, Socket.EVENT_OPEN);
            }
            for (String event : onOpenMessageQueue.keySet()) {
                Socket.this.send(event, (String)onOpenMessageQueue.get(event));
            }
            onOpenMessageQueue.clear();
            Socket.this.changeState(State.OPEN);
        }

        public void onMessage(WebSocket webSocket, String text) {
            Log.v((String)TAG, (String)("New Message received " + text));
            if (messageListener != null) {
                messageListener.onMessage(Socket.this, text);
            }
            try {
                JSONObject response = new JSONObject(text);
                String event = response.getString("event");
                JSONObject data = response.getJSONObject("data");
                if (eventResponseListener.get(event) != null) {
                    ((OnEventResponseListener)eventResponseListener.get(event)).onMessage(Socket.this, event, data);
                }
                if (eventListener.get(event) != null) {
                    ((OnEventListener)eventListener.get(event)).onMessage(Socket.this, event);
                }
            }
            catch (JSONException e) {
                Log.e((String)TAG, (String)"Unknown message format.");
            }
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            Log.v((String)TAG, (String)("Close request from server with reason '" + reason + "'"));
            Socket.this.changeState(State.CLOSING);
            webSocket.close(1000, reason);
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            Log.v((String)TAG, (String)("Socket connection closed with reason '" + reason + "'"));
            Socket.this.changeState(State.CLOSED);
            if (eventListener.get(Socket.EVENT_CLOSED) != null) {
                ((OnEventListener)eventListener.get(Socket.EVENT_CLOSED)).onMessage(Socket.this, Socket.EVENT_CLOSED);
            }
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            if (!skipOnFailure) {
                skipOnFailure = false;
                Log.v((String)TAG, (String)("Socket connection fail, try to reconnect. (" + reconnectionAttempts + ")"));
                Socket.this.changeState(State.CONNECT_ERROR);
                Socket.this.reconnect();
            }
        }
    };

    private Socket(Request request) {
        Socket.request = request;
        state = State.CLOSED;
        eventListener = new HashMap<String, OnEventListener>();
        eventResponseListener = new HashMap<String, OnEventResponseListener>();
        delayedReconnection = new Handler(Looper.getMainLooper());
        skipOnFailure = false;
    }

    public Socket connect() {
        if (httpClient == null) {
            throw new IllegalStateException("Make sure to use Socket.Builder before using Socket#connect.");
        }
        if (realWebSocket == null) {
            realWebSocket = (RealWebSocket)httpClient.build().newWebSocket(request, this.webSocketListener);
            this.changeState(State.OPENING);
        } else if (state == State.CLOSED) {
            realWebSocket.connect(httpClient.build());
            this.changeState(State.OPENING);
        }
        return this;
    }

    public Socket onEvent(@NonNull String event, @NonNull OnEventListener listener) {
        eventListener.put(event, listener);
        return this;
    }

    public Socket onEventResponse(@NonNull String event, @NonNull OnEventResponseListener listener) {
        eventResponseListener.put(event, listener);
        return this;
    }

    public boolean send(@NonNull String event, @NonNull String data) {
        try {
            JSONObject text = new JSONObject();
            text.put("event", (Object)event);
            text.put("data", (Object)new JSONObject(data));
            Log.v((String)TAG, (String)("Try to send data " + text.toString()));
            return realWebSocket.send(text.toString());
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("Try to send data with wrong JSON format, data: " + data));
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)("Error on Socket.send: " + ex.getMessage()));
        }
        return false;
    }

    public Socket setOnChangeStateListener(@NonNull OnStateChangeListener listener) {
        onChangeStateListener = listener;
        return this;
    }

    public Socket setMessageListener(@NonNull OnMessageListener listener) {
        messageListener = listener;
        return this;
    }

    public void removeEventListener(@NonNull String event) {
        eventListener.remove(event);
        onOpenMessageQueue.remove(event);
    }

    public void clearListeners() {
        eventListener.clear();
        messageListener = null;
        onChangeStateListener = null;
    }

    public void close() {
        if (realWebSocket != null) {
            realWebSocket.close(1000, CLOSE_REASON);
        }
    }

    public void close(int code, @NonNull String reason) {
        if (realWebSocket != null) {
            realWebSocket.close(code, reason);
        }
    }

    public void terminate() {
        skipOnFailure = true;
        if (realWebSocket != null) {
            realWebSocket.cancel();
            realWebSocket = null;
        }
    }

    public void sendOnOpen(@NonNull String event, @NonNull String data) {
        if (state != State.OPEN) {
            onOpenMessageQueue.put(event, data);
        } else {
            this.send(event, data);
        }
    }

    public State getState() {
        return state;
    }

    private void changeState(State newState) {
        state = newState;
        if (onChangeStateListener != null) {
            Socket.onChangeStateListener.onChange(this, Socket.state);
        }
    }

    private void reconnect() {
        if (state != State.CONNECT_ERROR) {
            return;
        }
        this.changeState(State.RECONNECT_ATTEMPT);
        if (realWebSocket != null) {
            realWebSocket.cancel();
            realWebSocket = null;
        }
        if (eventListener.get(EVENT_RECONNECT_ATTEMPT) != null) {
            Socket.eventListener.get(EVENT_RECONNECT_ATTEMPT).onMessage(this, EVENT_RECONNECT_ATTEMPT);
        }
        int collision = reconnectionAttempts > 7 ? 7 : reconnectionAttempts;
        long delayTime = Math.round((Math.pow(2.0, collision) - 1.0) / 2.0) * 1000L;
        delayedReconnection.removeCallbacksAndMessages(null);
        delayedReconnection.postDelayed(new Runnable(){

            @Override
            public void run() {
                Socket.this.changeState(State.RECONNECTING);
                reconnectionAttempts++;
                Socket.this.connect();
            }
        }, delayTime);
    }

    static {
        onOpenMessageQueue = new HashMap<String, String>();
    }

    public static abstract class OnStateChangeListener {
        public abstract void onChange(State var1);

        private void onChange(Socket socket, final State status) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    this.onChange(status);
                }
            });
        }
    }

    public static abstract class OnEventResponseListener
    extends OnEventListener {
        public abstract void onMessage(String var1, String var2);

        @Override
        public void onMessage(String event) {
        }

        private void onMessage(Socket socket, final String event, final JSONObject data) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    this.onMessage(event, data.toString());
                    this.onMessage(event);
                }
            });
        }
    }

    public static abstract class OnEventListener {
        public abstract void onMessage(String var1);

        private void onMessage(Socket socket, final String event) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    this.onMessage(event);
                }
            });
        }
    }

    public static abstract class OnMessageListener {
        public abstract void onMessage(String var1);

        private void onMessage(Socket socket, final String data) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    this.onMessage(data);
                }
            });
        }
    }

    public static class Builder {
        private Request.Builder request;

        private Builder(Request.Builder request) {
            this.request = request;
        }

        public static Builder with(@NonNull String url) {
            if (!url.regionMatches(true, 0, "ws:", 0, 3) && !url.regionMatches(true, 0, "wss:", 0, 4)) {
                throw new IllegalArgumentException("web socket url must start with ws or wss, passed url is " + url);
            }
            return new Builder(new Request.Builder().url(url));
        }

        public Builder setPingInterval(long interval, @NonNull TimeUnit unit) {
            httpClient.pingInterval(interval, unit);
            return this;
        }

        public Builder addHeader(@NonNull String name, @NonNull String value) {
            this.request.addHeader(name, value);
            return this;
        }

        public Socket build() {
            return new Socket(this.request.build());
        }
    }

    public static enum State {
        CLOSED,
        CLOSING,
        CONNECT_ERROR,
        RECONNECT_ATTEMPT,
        RECONNECTING,
        OPENING,
        OPEN;

    }
}

