/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.CountDownTimer;
import android.os.StrictMode;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.app.ActivityCompat;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.CustomButtonAnimation;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.StrokeGradientDrawable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class PTTButton
extends AppCompatButton
implements View.OnTouchListener {
    private String TAG = "PTTButton";
    private static final int READ_PHONE_STATE = 0;
    private static final int REQUEST = 112;
    private Padding mPadding;
    private int mHeight;
    private int mWidth;
    private int mColor;
    private int mCornerRadius;
    private int mStrokeWidth;
    private int mStrokeColor;
    protected boolean mAnimationInProgress;
    private StrokeGradientDrawable mDrawableNormal;
    private StrokeGradientDrawable mDrawablePressed;
    private String buttonName;
    private String sendingText = "Sending...";
    AudioTrack at;
    public static final int MESSAGE_READ = 1;
    public static final int MESSAGE_WRITE = 2;
    private int sampleRate = 44100;
    private int channelConfig = 16;
    private int audioFormat = 2;
    int minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
    private boolean status = true;
    public AudioRecord recorder;
    private String API_KEY;
    private String name;
    private int idGroup;
    private Context context;
    CountDownTimer timer;
    boolean canTalk = true;

    public PTTButton(Context context, int idGroup, String API_KEY, String nameClient, int quality) {
        super(context);
        this.context = context;
        this.idGroup = idGroup;
        this.API_KEY = API_KEY;
        this.name = nameClient;
        switch (quality) {
            case 1: {
                this.sampleRate = 44100;
                this.channelConfig = 16;
                this.audioFormat = 2;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
                break;
            }
            case 2: {
                this.sampleRate = 8000;
                this.channelConfig = 16;
                this.audioFormat = 2;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
                break;
            }
            case 3: {
                this.sampleRate = 8000;
                this.channelConfig = 16;
                this.audioFormat = 3;
                this.minBufSize = AudioRecord.getMinBufferSize((int)this.sampleRate, (int)this.channelConfig, (int)this.audioFormat);
            }
        }
        this.initView();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mHeight == 0 && this.mWidth == 0 && w != 0 && h != 0) {
            this.mHeight = this.getHeight();
            this.mWidth = this.getWidth();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            System.out.println(keyCode);
            switch (keyCode) {
                case 25: {
                    System.out.println("Button pressed");
                    this.status = true;
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.getAction() == 0) {
            System.out.println(keyCode);
            switch (keyCode) {
                case 25: {
                    System.out.println("Button released");
                    this.status = false;
                    this.recorder.release();
                    return true;
                }
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void startTalking() {
        Log.d((String)"log", (String)"startStreming");
        this.status = true;
        this.startStreaming();
        this.canTalk = false;
        this.buttonName = this.getText().toString();
        this.setText(this.sendingText);
    }

    public void stopTalking() {
        Log.d((String)"log", (String)"stopStreming");
        this.status = false;
        this.recorder.release();
        this.blockTouch();
        this.timer = new CountDownTimer(3000L, 100L){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                PTTButton.this.canTalk = true;
                PTTButton.this.setText(PTTButton.this.buttonName);
                PTTButton.this.unblockTouch();
            }
        }.start();
    }

    public boolean onTouch(View arg0, MotionEvent arg1) {
        switch (arg1.getAction()) {
            case 0: {
                System.out.println("Button pressed");
                this.status = true;
                return true;
            }
            case 1: {
                System.out.println("Button released");
                this.status = false;
                this.recorder.release();
            }
        }
        return true;
    }

    private void startStreaming() {
        String message = "{ \"name\": \"" + this.name + "\",\"imei\": " + this.getIMEINumber() + ", \"api_key\": \"" + this.API_KEY + "\",\"idgroup\": " + this.idGroup + " }";
        Thread streamThread = new Thread(new MyRunnable(message){

            @Override
            public void run() {
                try {
                    DatagramSocket socket = new DatagramSocket();
                    Log.d((String)"VS", (String)"Socket Created");
                    Log.d((String)"VS", (String)"Socket Created");
                    InetAddress destination = InetAddress.getByName(Conf.SERVER_IP);
                    DatagramPacket packet = new DatagramPacket(this.message.getBytes(), this.message.getBytes().length, destination, Conf.SERVER_PORT);
                    socket.send(packet);
                    PTTButton.this.minBufSize = AudioRecord.getMinBufferSize((int)PTTButton.this.sampleRate, (int)PTTButton.this.channelConfig, (int)PTTButton.this.audioFormat);
                    byte[] buffer = new byte[PTTButton.this.minBufSize];
                    Log.d((String)"VS", (String)("Buffer created of size " + PTTButton.this.minBufSize));
                    PTTButton.this.recorder = new AudioRecord(1, PTTButton.this.sampleRate, PTTButton.this.channelConfig, PTTButton.this.audioFormat, PTTButton.this.minBufSize * 10);
                    Log.d((String)"VS", (String)"Recorder initialized");
                    PTTButton.this.recorder.startRecording();
                    while (PTTButton.this.status) {
                        PTTButton.this.minBufSize = PTTButton.this.recorder.read(buffer, 0, buffer.length);
                        packet = new DatagramPacket(buffer, buffer.length, destination, Conf.SERVER_PORT);
                        socket.send(packet);
                        System.out.println("MinBufferSize: " + PTTButton.this.minBufSize);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Log.e((String)"VS", (String)"IOException");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        streamThread.start();
    }

    public StrokeGradientDrawable getDrawableNormal() {
        return this.mDrawableNormal;
    }

    public void animation(@NonNull Params params) {
        if (!this.mAnimationInProgress) {
            this.mDrawablePressed.setColor(params.colorPressed);
            this.mDrawablePressed.setCornerRadius(params.cornerRadius);
            this.mDrawablePressed.setStrokeColor(params.strokeColor);
            this.mDrawablePressed.setStrokeWidth(params.strokeWidth);
            if (params.duration == 0) {
                this.aniBtWithoutAnimation(params);
            } else {
                this.aniBtWithAnimation(params);
            }
            this.mColor = params.color;
            this.mCornerRadius = params.cornerRadius;
            this.mStrokeWidth = params.strokeWidth;
            this.mStrokeColor = params.strokeColor;
        }
    }

    private void aniBtWithAnimation(final @NonNull Params params) {
        this.mAnimationInProgress = true;
        this.setText(null);
        this.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.setPadding(this.mPadding.left, this.mPadding.top, this.mPadding.right, this.mPadding.bottom);
        CustomButtonAnimation.Params animationParams = CustomButtonAnimation.Params.create(this).color(this.mColor, params.color).cornerRadius(this.mCornerRadius, params.cornerRadius).strokeWidth(this.mStrokeWidth, params.strokeWidth).strokeColor(this.mStrokeColor, params.strokeColor).height(this.getHeight(), params.height).width(this.getWidth(), params.width).duration(params.duration).listener(new CustomButtonAnimation.Listener(){

            @Override
            public void onAnimationEnd() {
                PTTButton.this.finalizeAnimation(params);
            }
        });
        CustomButtonAnimation animation = new CustomButtonAnimation(animationParams);
        animation.start();
    }

    private void aniBtWithoutAnimation(@NonNull Params params) {
        this.mDrawableNormal.setColor(params.color);
        this.mDrawableNormal.setCornerRadius(params.cornerRadius);
        this.mDrawableNormal.setStrokeColor(params.strokeColor);
        this.mDrawableNormal.setStrokeWidth(params.strokeWidth);
        if (params.width != 0 && params.height != 0) {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.width = params.width;
            layoutParams.height = params.height;
            this.setLayoutParams(layoutParams);
        }
        this.finalizeAnimation(params);
    }

    private void finalizeAnimation(@NonNull Params params) {
        this.mAnimationInProgress = false;
        if (params.icon != 0 && params.text != null) {
            this.setIconLeft(params.icon);
            this.setText(params.text);
        } else if (params.icon != 0) {
            this.setIcon(params.icon);
        } else if (params.text != null) {
            this.setText(params.text);
        }
        if (params.animationListener != null) {
            params.animationListener.onAnimationEnd();
        }
    }

    public void blockTouch() {
        this.getBackground().setColorFilter(-7829368, PorterDuff.Mode.MULTIPLY);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return true;
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public void unblockTouch() {
        this.getBackground().setColorFilter(null);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        Log.d((String)"log", (String)"unblockTouch() onTouch: push");
                        PTTButton.this.status = true;
                        PTTButton.this.startStreaming();
                        PTTButton.this.canTalk = false;
                        PTTButton.this.buttonName = PTTButton.this.getText().toString();
                        PTTButton.this.setText(PTTButton.this.sendingText);
                        return true;
                    }
                    case 1: {
                        Log.d((String)"log", (String)"unblockTouch() onTouch: release");
                        PTTButton.this.status = false;
                        PTTButton.this.recorder.release();
                        PTTButton.this.blockTouch();
                        PTTButton.this.timer = new CountDownTimer(3000L, 100L){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                PTTButton.this.canTalk = true;
                                PTTButton.this.setText(PTTButton.this.buttonName);
                                PTTButton.this.unblockTouch();
                            }
                        }.start();
                    }
                }
                return false;
            }
        });
    }

    private void webSocketConnection() {
        OkHttpClient clientCoinPrice = new OkHttpClient();
        String url = "ws://" + Conf.SERVER_IP + ":" + Conf.SERVER_WS_PORT + "?imei=" + this.getIMEINumber() + "&groupId=" + this.idGroup + "&API_KEY=" + this.API_KEY + "&clientName=" + this.name;
        Request requestCoinPrice = new Request.Builder().url(url).build();
        WebSocketListener webSocketListenerCoinPrice = new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
            }

            public void onMessage(WebSocket webSocket, String text) {
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                Log.e((String)PTTButton.this.TAG, (String)("MESSAGE bytes: " + bytes.hex()));
                try {
                    PTTButton.this.PlayShortAudioFileViaAudioTrack(bytes.toByteArray());
                }
                catch (Exception ex) {
                    System.out.print(ex.getMessage());
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                webSocket.close(1000, null);
                webSocket.cancel();
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            }
        };
        clientCoinPrice.newWebSocket(requestCoinPrice, webSocketListenerCoinPrice);
        clientCoinPrice.dispatcher().executorService().shutdown();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initView() {
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        try {
            this.webSocketConnection();
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)("error en webSocketConnection: " + ex.getMessage()));
        }
        int intSize = AudioTrack.getMinBufferSize((int)this.sampleRate, (int)4, (int)this.audioFormat);
        this.at = new AudioTrack(3, this.sampleRate, 4, this.audioFormat, intSize, 1);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        Log.d((String)"log", (String)"this.setOnTouchListener onTouch: push");
                        PTTButton.this.status = true;
                        PTTButton.this.startStreaming();
                        PTTButton.this.canTalk = false;
                        PTTButton.this.buttonName = PTTButton.this.getText().toString();
                        PTTButton.this.setText(PTTButton.this.sendingText);
                        return true;
                    }
                    case 1: {
                        Log.d((String)"log", (String)"this.setOnTouchListener onTouch: release");
                        PTTButton.this.status = false;
                        PTTButton.this.recorder.release();
                        PTTButton.this.blockTouch();
                        PTTButton.this.timer = new CountDownTimer(3000L, 100L){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                PTTButton.this.canTalk = true;
                                PTTButton.this.setText(PTTButton.this.buttonName);
                                PTTButton.this.unblockTouch();
                            }
                        }.start();
                    }
                }
                return false;
            }
        });
        this.mPadding = new Padding();
        this.mPadding.left = this.getPaddingLeft();
        this.mPadding.right = this.getPaddingRight();
        this.mPadding.top = this.getPaddingTop();
        this.mPadding.bottom = this.getPaddingBottom();
        this.setTextColor(this.getResources().getColor(R.color.bt_white));
        this.setBackgroundCompat(this.getResources().getDrawable(R.drawable.circle_blue_selector));
    }

    private String getIMEINumber() {
        String IMEINumber = "";
        if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_PHONE_STATE") == 0) {
            TelephonyManager telephonyMgr = (TelephonyManager)this.context.getSystemService("phone");
            IMEINumber = Build.VERSION.SDK_INT >= 26 ? telephonyMgr.getImei() : telephonyMgr.getDeviceId();
        }
        return IMEINumber;
    }

    private void PlayShortAudioFileViaAudioTrack(byte[] byteData) throws IOException {
        if (this.at != null) {
            this.at.write(byteData, 0, byteData.length);
            this.at.play();
        } else {
            Log.d((String)"TCAudio", (String)"audio track is not initialised ");
        }
    }

    private StrokeGradientDrawable createDrawable(int color2, int cornerRadius, int strokeWidth) {
        StrokeGradientDrawable drawable2 = new StrokeGradientDrawable(new GradientDrawable());
        drawable2.getGradientDrawable().setShape(1);
        drawable2.setColor(color2);
        drawable2.setCornerRadius(cornerRadius);
        drawable2.setStrokeColor(color2);
        drawable2.setStrokeWidth(strokeWidth);
        return drawable2;
    }

    public void setBackgroundCompat(@Nullable Drawable drawable2) {
        if (Build.VERSION.SDK_INT <= 16) {
            this.setBackgroundDrawable(drawable2);
        } else {
            this.setBackground(drawable2);
        }
    }

    public void setIcon(final @DrawableRes int icon) {
        this.post(new Runnable(){

            @Override
            public void run() {
                Drawable drawable2 = PTTButton.this.getResources().getDrawable(icon);
                int padding = PTTButton.this.getWidth() / 2 - drawable2.getIntrinsicWidth() / 2;
                PTTButton.this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
                PTTButton.this.setPadding(padding, 0, 0, 0);
            }
        });
    }

    public void setIconLeft(@DrawableRes int icon) {
        this.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
    }

    public void setSendingText(String sendingText) {
        this.sendingText = sendingText;
    }

    public final class AudioQuality {
        public static final int HIGH = 1;
        public static final int MEDIUM = 2;
        public static final int LOW = 3;
    }

    public static class Params {
        private int cornerRadius;
        private int width;
        private int height;
        private int color;
        private int colorPressed;
        private int duration;
        private int icon;
        private int strokeWidth;
        private int strokeColor;
        private String text;
        private CustomButtonAnimation.Listener animationListener;

        private Params() {
        }

        public static Params create() {
            return new Params();
        }

        public Params text(@NonNull String text) {
            this.text = text;
            return this;
        }

        public Params icon(@DrawableRes int icon) {
            this.icon = icon;
            return this;
        }

        public Params cornerRadius(int cornerRadius) {
            this.cornerRadius = cornerRadius;
            return this;
        }

        public Params width(int width) {
            this.width = width;
            return this;
        }

        public Params height(int height) {
            this.height = height;
            return this;
        }

        public Params color(int color2) {
            this.color = color2;
            return this;
        }

        public Params colorPressed(int colorPressed) {
            this.colorPressed = colorPressed;
            return this;
        }

        public Params duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Params strokeWidth(int strokeWidth) {
            this.strokeWidth = strokeWidth;
            return this;
        }

        public Params strokeColor(int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Params animationListener(CustomButtonAnimation.Listener animationListener) {
            this.animationListener = animationListener;
            return this;
        }
    }

    private class Padding {
        public int left;
        public int right;
        public int top;
        public int bottom;

        private Padding() {
        }
    }

    public class MyRunnable
    implements Runnable {
        public String message;

        public MyRunnable(String parameter) {
            this.message = parameter;
        }

        @Override
        public void run() {
        }
    }
}

