/*
 * Decompiled with CFR 0.152.
 */
package com.siggytech.utils.communication;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaPlayer;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.recyclerview.widget.RecyclerView;
import com.siggytech.utils.communication.ChatModel;
import com.siggytech.utils.communication.Conf;
import com.siggytech.utils.communication.DownloadTask;
import com.siggytech.utils.communication.ImageActivity;
import com.siggytech.utils.communication.R;
import com.siggytech.utils.communication.Utils;
import com.siggytech.utils.communication.VideoActivity;
import com.siggytech.view.MyImage;
import java.util.List;

public class CustomAdapterBubble
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = CustomAdapterBubble.class.getSimpleName();
    private List<ChatModel> lstChat;
    private Context context;
    private MediaPlayer mPlayer;
    private Activity mActivity;

    public CustomAdapterBubble(List<ChatModel> lstChat, Context context, Activity activity) {
        this.lstChat = lstChat;
        this.context = context;
        this.mActivity = activity;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.chat_cell_out, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        block24: {
            ChatModel model = this.lstChat.get(position);
            if (model.isMine()) {
                if (Build.VERSION.SDK_INT > 23) {
                    holder.lnMessage.setBackgroundResource(R.drawable.bubble_nine_pach);
                } else {
                    holder.lnMessage.setBackgroundResource(R.drawable.mine_bubble);
                }
                holder.lnLayout.setGravity(0x800005);
            } else {
                if (Build.VERSION.SDK_INT > 23) {
                    holder.lnMessage.setBackgroundResource(R.drawable.bubble_nine_pach_agent);
                } else {
                    holder.lnMessage.setBackgroundResource(R.drawable.other_bubble);
                }
                holder.lnLayout.setGravity(0x800003);
            }
            holder.chat_out_from.setText((CharSequence)model.getFromMessage());
            holder.chat_text_datetime.setText((CharSequence)model.getDateTimeMessage());
            if ("Message".equals(model.getMessageModel().getType())) {
                holder.lnAudio.setVisibility(8);
                holder.ivPreviewImage.setVisibility(8);
                holder.chat_out_text.setVisibility(0);
                holder.chat_out_text.setText((CharSequence)model.getMessageModel().getMessage());
            }
            if ("audio".equals(model.getMessageModel().getType())) {
                holder.lnAudio.setVisibility(0);
                holder.ivPreviewImage.setVisibility(8);
                holder.chat_out_text.setVisibility(8);
                holder.tvAudioDuration.setText((CharSequence)this.getDurationString(model.getMessageModel().getDuration()));
                holder.tvAudioDuration.setTag((Object)this.getDurationString(model.getMessageModel().getDuration()));
                try {
                    holder.audioUri = Utils.Base64ToUrl(model.getMessageModel().getMessage(), Utils.GetDateName() + ".3gp");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("video".equals(model.getMessageModel().getType())) {
                holder.chat_out_text.setVisibility(8);
                holder.lnAudio.setVisibility(8);
                holder.ivPreviewImage.setVisibility(0);
                try {
                    if (model.isMine()) {
                        try {
                            holder.uri = Utils.Base64ToUrl(model.getMessageModel().getMessage(), Utils.GetDateName() + ".mp4");
                            Bitmap decodedByte = ThumbnailUtils.createVideoThumbnail((String)holder.uri.toString(), (int)1);
                            holder.ivPreviewImage.setRoundImage(Bitmap.createScaledBitmap((Bitmap)decodedByte, (int)decodedByte.getWidth(), (int)decodedByte.getHeight(), (boolean)false));
                            holder.ivPreviewImage.getProgressBar().hide();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        holder.ivPreviewImage.setOnClickListener(v -> this.goVideoView(holder.uri));
                        break block24;
                    }
                    new DownloadTask(this.context, this.getDownloadUrl(model.getMessageModel().getMessage()), holder.ivPreviewImage, model.getMessageModel().getType());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if ("photo".equals(model.getMessageModel().getType())) {
                holder.lnAudio.setVisibility(8);
                holder.ivPreviewImage.setVisibility(0);
                holder.chat_out_text.setVisibility(8);
                try {
                    if (model.isMine()) {
                        byte[] decodedString = Base64.decode((String)model.getMessageModel().getMessage(), (int)0);
                        Bitmap decodedByte = BitmapFactory.decodeByteArray((byte[])decodedString, (int)0, (int)decodedString.length);
                        holder.ivPreviewImage.setRoundImage(Bitmap.createScaledBitmap((Bitmap)decodedByte, (int)decodedByte.getWidth(), (int)decodedByte.getHeight(), (boolean)false));
                        holder.ivPreviewImage.getProgressBar().hide();
                        try {
                            holder.uri = Utils.Base64ToUrl(model.getMessageModel().getMessage(), Utils.GetDateName() + ".bmp");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        holder.ivPreviewImage.setOnClickListener(v -> this.goImageView(holder.uri));
                        break block24;
                    }
                    new DownloadTask(this.context, this.getDownloadUrl(model.getMessageModel().getMessage()), holder.ivPreviewImage, model.getMessageModel().getType());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        holder.chat_out_from.setTextColor(Conf.CHAT_COLOR_FROM);
        holder.chat_out_text.setTextColor(Conf.CHAT_COLOR_TEXT);
        holder.chat_text_datetime.setTextColor(Conf.CHAT_COLOR_DATE);
        holder.tvAudioDuration.setTextColor(Conf.CHAT_COLOR_DATE);
        holder.ivPlay.setTag((Object)false);
        holder.ivPlay.setOnClickListener(v -> {
            try {
                if (!((Boolean)v.getTag()).booleanValue()) {
                    this.stopPlaying(holder.sbPlay, holder.ivPlay);
                    v.setTag((Object)true);
                    ((ImageView)v).setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_pause));
                    this.mPlayer = MediaPlayer.create((Context)this.context, (Uri)holder.audioUri);
                    this.mPlayer.start();
                    this.initializeSeekBar(holder.sbPlay, holder.tvAudioDuration, holder.ivPlay, holder.factor);
                } else {
                    this.stopPlaying(holder.sbPlay, holder.ivPlay);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        holder.sbPlay.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
                try {
                    if (fromTouch) {
                        CustomAdapterBubble.this.mPlayer.seekTo(progress * holder.factor);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.lstChat.size();
    }

    private void stopPlaying(AppCompatSeekBar mSeekBar, ImageView mImage) {
        try {
            this.mActivity.runOnUiThread(() -> {
                mImage.setTag((Object)false);
                mImage.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_play_arrow));
                mSeekBar.setProgress(0);
            });
            try {
                if (this.mPlayer != null) {
                    this.mPlayer.stop();
                    this.mPlayer.release();
                    this.mPlayer = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initializeSeekBar(AppCompatSeekBar mSeekBar, TextView tvDuration, ImageView mImage, int factor) {
        Log.d((String)TAG, (String)("TOTAL " + this.mPlayer.getDuration() / factor));
        mSeekBar.setMax(this.mPlayer.getDuration() / factor);
        new Thread(() -> {
            try {
                while (this.mPlayer != null && this.mPlayer.isPlaying() && this.mPlayer.getCurrentPosition() / factor < this.mPlayer.getDuration() / factor) {
                    int mCurrentPosition = this.mPlayer.getCurrentPosition() / factor;
                    mSeekBar.setProgress(mCurrentPosition);
                    this.mActivity.runOnUiThread(() -> {
                        if (this.mPlayer != null) {
                            try {
                                if (this.mPlayer.isPlaying()) {
                                    tvDuration.setText((CharSequence)this.getDurationString(this.mPlayer.getCurrentPosition() / 1000));
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            tvDuration.setText((CharSequence)((String)tvDuration.getTag()));
                        }
                    });
                }
                if (this.mPlayer != null && this.mPlayer.getDuration() == this.mPlayer.getCurrentPosition()) {
                    this.stopPlaying(mSeekBar, mImage);
                }
                if (this.mPlayer != null && !this.mPlayer.isPlaying()) {
                    this.stopPlaying(mSeekBar, mImage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopPlaying(mSeekBar, mImage);
            }
        }).start();
    }

    private String getDurationString(int seconds) {
        int minutes = seconds / 60;
        return String.format("%02d:%02d", minutes, seconds %= 60);
    }

    private void goImageView(Uri uri) {
        try {
            Intent intent = new Intent(this.context, ImageActivity.class);
            intent.putExtra("ImageUri", uri.toString());
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void goVideoView(Uri uri) {
        try {
            Intent intent = new Intent(this.context, VideoActivity.class);
            intent.putExtra("VideoUri", uri.toString());
            this.context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getDownloadUrl(String name) {
        return Conf.HTTP + "" + Conf.SERVER_IP + ":" + Conf.SERVER_IMAGE_PORT + "/" + name;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        LinearLayout lnLayout;
        LinearLayout lnMessage;
        LinearLayout lnDate;
        TextView chat_out_from;
        TextView chat_out_text;
        TextView chat_text_datetime;
        TextView tvDate;
        LinearLayout lnAudio;
        TextView tvAudioDuration;
        ImageView ivPlay;
        AppCompatSeekBar sbPlay;
        Uri audioUri;
        Uri uri;
        int factor;
        MyImage ivPreviewImage;

        public ViewHolder(View itemView) {
            super(itemView);
            this.factor = 1;
            this.lnLayout = (LinearLayout)itemView.findViewById(R.id.lnLayout);
            this.lnDate = (LinearLayout)itemView.findViewById(R.id.lnDate);
            this.lnMessage = (LinearLayout)itemView.findViewById(R.id.lnMessage);
            this.chat_out_from = (TextView)itemView.findViewById(R.id.chat_out_name);
            this.chat_out_text = (TextView)itemView.findViewById(R.id.chat_out_text);
            this.chat_text_datetime = (TextView)itemView.findViewById(R.id.chat_text_datetime);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
            this.lnAudio = (LinearLayout)itemView.findViewById(R.id.lnAudio);
            this.tvAudioDuration = (TextView)itemView.findViewById(R.id.tvAudioDuration);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.sbPlay = (AppCompatSeekBar)itemView.findViewById(R.id.sbPlay);
            this.ivPreviewImage = (MyImage)itemView.findViewById(R.id.ivPreviewImage);
        }
    }
}

