/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.provider.Settings;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;
import com.sic.module.utils.AppContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class Utils {
    public static final byte BIT_7 = -128;
    public static final byte BIT_6 = 64;
    public static final byte BIT_5 = 32;
    public static final byte BIT_4 = 16;
    public static final byte BIT_3 = 8;
    public static final byte BIT_2 = 4;
    public static final byte BIT_1 = 2;
    public static final byte BIT_0 = 1;
    private static final String TAG = Utils.class.getName();
    private static final String TAG_DIALOG_FRAGMENT = "dialog_fragment";
    private static Utils instance;
    private final Context mContext;

    private Utils(Context context) {
        this.mContext = context;
    }

    private Utils() {
        this(AppContext.getInstance().getContext());
    }

    public static Utils getInstance() {
        if (instance == null) {
            instance = new Utils();
        }
        return instance;
    }

    public static Utils getInstance(Context context) {
        if (instance == null) {
            instance = new Utils(context);
        }
        return instance;
    }

    public static String getDateAndTimeString() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("   dd/MM/yyyy       HH:mm:ss    ", Locale.US);
        return format.format(date);
    }

    public static String getTimeString() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss", Locale.US);
        return format.format(date);
    }

    public static String getCapitalizeFirstLetter(String original) {
        if (original.length() == 0) {
            return original;
        }
        return original.substring(0, 1).toUpperCase() + original.substring(1).toLowerCase();
    }

    public static void scrollAmountTextView(TextView view) {
        try {
            int scrollAmount = view.getLayout().getLineTop(view.getLineCount()) - view.getHeight();
            if (scrollAmount > 0) {
                view.scrollTo(0, scrollAmount);
            } else {
                view.scrollTo(0, 0);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static byte checkSum(byte[] input) {
        byte sum = 0;
        for (int i = 0; i < input.length - 1; ++i) {
            sum = (byte)(sum ^ input[i]);
        }
        return sum;
    }

    public static byte checkSum(byte[] data, int start, int length) {
        byte crc = 0;
        if (data == null) {
            return 0;
        }
        if (start < 0 || length < 1 || start + length > data.length + 1) {
            return 0;
        }
        for (int i = start; i < start + length - 1; ++i) {
            crc = (byte)(crc ^ data[i]);
        }
        return crc;
    }

    public static Spannable toSpannable(String text) {
        return new SpannableString((CharSequence)text);
    }

    public static Spannable setSpannable(Spannable text, int color) {
        text.setSpan((Object)new ForegroundColorSpan(color), 0, text.length(), 33);
        return text;
    }

    public static Spannable setSpannable(Spannable fulltext, String subtext, int color) {
        int index = fulltext.toString().indexOf(subtext);
        if (index < 0) {
            return fulltext;
        }
        fulltext.setSpan((Object)new ForegroundColorSpan(color), index, index + subtext.length(), 33);
        return fulltext;
    }

    public static Spannable setSpannable(Spannable text, int index, int length, int color) {
        if (index + length > text.length() || index < 0 || length < 0) {
            return text;
        }
        text.setSpan((Object)new ForegroundColorSpan(color), index, index + length, 33);
        return text;
    }

    public static boolean checkArraySize(byte[] data, int min_size, int max_size) {
        return data != null && min_size >= 0 && data.length >= min_size && data.length <= max_size;
    }

    public static byte[][] chunkSplit(byte[] data, int size) {
        if (Utils.checkArraySize(data, 1, data.length)) {
            int dalen = data.length;
            int maxlen = (int)Math.ceil((double)dalen / (double)size);
            byte[][] buffer = new byte[maxlen--][];
            for (int i = 0; i < maxlen; ++i) {
                buffer[i] = new byte[size];
                System.arraycopy(data, i * size, buffer[i], 0, size);
            }
            if (dalen % size > 0) {
                size = dalen % size;
            }
            buffer[maxlen] = new byte[size];
            System.arraycopy(data, dalen - size, buffer[maxlen], 0, size);
            return buffer;
        }
        return null;
    }

    public static byte[] getPackageLimited(byte cmd, byte[] data, int size) {
        if (data == null) {
            return null;
        }
        int length = Math.min(size, data.length);
        byte[] buffer = new byte[length + 1];
        buffer[0] = cmd;
        System.arraycopy(data, 0, buffer, 1, length);
        return buffer;
    }

    public static byte[][] getPackageSplit(byte cmd, byte[][] data, int size) {
        return Utils.getPackageSplit(cmd, cmd, data, size);
    }

    public static byte[][] getPackageSplit(byte cmd, byte lastcmd, byte[][] data, int size) {
        ArrayList<byte[]> buffer = new ArrayList<byte[]>();
        for (byte[] each : data) {
            byte[] temp;
            if (!Utils.checkArraySize(each, 1, each.length)) continue;
            int dalen = each.length;
            int localSize = size;
            int maxlen = (int)Math.ceil((double)dalen / (double)localSize) - 1;
            for (int i = 0; i < maxlen; ++i) {
                temp = new byte[localSize + 1];
                temp[0] = cmd;
                System.arraycopy(each, i * localSize, temp, 1, localSize);
                buffer.add(temp);
            }
            if (dalen % localSize > 0) {
                localSize = dalen % localSize;
            }
            temp = new byte[localSize + 1];
            temp[0] = lastcmd;
            System.arraycopy(each, dalen - localSize, temp, 1, localSize);
            buffer.add(temp);
        }
        byte[][] array = new byte[buffer.size()][];
        return (byte[][])buffer.toArray((T[])array);
    }

    public String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
    }

    public String getVersionName() {
        try {
            PackageInfo pInfo = this.mContext.getPackageManager().getPackageInfo(this.mContext.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (Exception e) {
            return "1.0";
        }
    }

    public int dpToPx(float dp) {
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
        return (int)px;
    }

    public List<ApplicationInfo> getInstalledApplication() {
        PackageManager packageManager = this.mContext.getPackageManager();
        List apps = packageManager.getInstalledApplications(0);
        Collections.sort(apps, new ApplicationInfo.DisplayNameComparator(packageManager));
        return apps;
    }
}

